/*
 * Decompiled with CFR 0.152.
 */
package corpusapi;

import corpusapi.Corpus;
import corpusapi.SegmentGroup;
import corpusapi.SenseSegmentGroup;
import corpusapi.SenseStatistics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CorpusTools {
    private HashMap<String, SenseStatistics> statisticsMap = new HashMap();

    public abstract SenseSegmentGroup getNextSenseInstance(Corpus var1, String var2);

    public abstract SenseSegmentGroup getNextSenseEntryInstance(Corpus var1);

    public abstract SenseSegmentGroup getNextSenseEntryInstance(Corpus var1, String var2);

    public SenseStatistics getSenseStatistics(Corpus corpus, String senseEntry) {
        if (!this.statisticsMap.containsKey(corpus.getId()) || !this.statisticsMap.get(corpus.getId()).availableSenseEntries().contains(senseEntry)) {
            SenseStatistics s = this.makeSenseStatistics(corpus, new HashSet<String>(Arrays.asList(senseEntry)));
            this.statisticsMap.put(corpus.getId(), s);
            return this.statisticsMap.get(corpus.getId());
        }
        return this.statisticsMap.get(corpus.getId()).projectionToSenseEntries(Arrays.asList(senseEntry));
    }

    public SenseStatistics getSenseStatistics(Corpus corpus) {
        if (!this.statisticsMap.containsKey(corpus.getId()) || !this.statisticsMap.get(corpus.getId()).isComplete()) {
            SenseStatistics s = this.makeSenseStatistics(corpus, null);
            this.statisticsMap.put(corpus.getId(), s);
        }
        return this.statisticsMap.get(corpus.getId());
    }

    public abstract String format(Corpus var1, List<List<? extends SegmentGroup>> var2);

    protected abstract SenseStatistics makeSenseStatistics(Corpus var1, Set<String> var2);
}

