/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.MorphoSegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEIInterpretation;
import corpusapi.tei.TEIMorphLex;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.readers.TEIMorphoReader;
import corpusapi.tei.readers.TEIReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class TEIMorphoSegmentGroup
extends TEISegmentGroup
implements MorphoSegmentGroup {
    private List<TEIMorphLex> interps;
    private TEIInterpretation interpChoice = null;
    public String orth;
    public String disambTool;
    public String disambResp;
    public String disambDate;
    public String disambChoice;

    public TEIMorphoSegmentGroup(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId) {
        super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
    }

    @Override
    public TEIMorphoSegmentGroup getNext(ContinueMode mode) {
        if (this.nextGroupId == null) {
            return null;
        }
        TEIMorphoSegmentGroup segmentGroup = null;
        try {
            TEIMorphoReader morphoReader = TEIReader.getTEIMorphoReader(this.corpusText);
            segmentGroup = morphoReader.getMorphoSegmentGroupById(this.nextGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEIMorphoSegmentGroup)this.getNeighbour(mode, this, segmentGroup, false);
    }

    @Override
    public TEIMorphoSegmentGroup getPrev(ContinueMode mode) {
        if (this.prevGroupId == null) {
            return null;
        }
        TEIMorphoSegmentGroup segmentGroup = null;
        try {
            TEIMorphoReader senseReader = TEIReader.getTEIMorphoReader(this.corpusText);
            segmentGroup = senseReader.getMorphoSegmentGroupById(this.prevGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEIMorphoSegmentGroup)this.getNeighbour(mode, segmentGroup, this, true);
    }

    @Override
    public String toString() {
        String r = "TEIMorpho   [id:" + this.id + ", next:" + this.nextGroupId + ", prev:" + this.prevGroupId + ", segments:" + this.segmentIdList + ",\n" + "           orth:" + this.orth + ",\n" + "           tool:" + this.disambTool + ",\n" + "           resp:" + this.disambResp + ",\n" + "           date:" + this.disambDate + ",\n" + "         choice:" + this.getChosenInterpretation() + ",\n" + "        interps:";
        for (TEIInterpretation t : this.getAllInterpretations()) {
            r = String.valueOf(r) + "\n           " + t;
        }
        r = String.valueOf(r) + "]";
        return r;
    }

    public TEIInterpretation getChosenInterpretation() {
        if (this.interpChoice == null) {
            for (TEIMorphLex ml : this.interps) {
                if (!ml.msd.containsKey(this.disambChoice)) continue;
                this.interpChoice = new TEIInterpretation(this.disambChoice, ml.base, ml.ctag, ml.msd.get(this.disambChoice));
                break;
            }
        }
        return this.interpChoice;
    }

    public List<TEIInterpretation> getAllInterpretations() {
        ArrayList<TEIInterpretation> result = new ArrayList<TEIInterpretation>();
        for (TEIMorphLex ml : this.interps) {
            for (Map.Entry<String, String> entry : ml.msd.entrySet()) {
                TEIInterpretation i = new TEIInterpretation(entry.getKey(), ml.base, ml.ctag, entry.getValue());
                result.add(i);
            }
        }
        return result;
    }

    public void setInterps(List<TEIMorphLex> interps) {
        this.interps = interps;
    }
}

