/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.Sense;
import corpusapi.tei.TEISenseEntry;
import corpusapi.util.MultiSelection;
import java.util.List;
import java.util.Vector;

public class TEISense
implements Sense {
    private MultiSelection definition = null;
    private String senseID = null;
    private TEISense coarserSense;
    private int n;
    private int coarseLevel;
    private List<MultiSelection> quotes;
    private List<TEISense> subsenses;

    public void setDefinition(MultiSelection definition) {
        this.definition = definition;
    }

    public TEISense(String senseID, TEISense coarserSense, int coarseLevel) {
        this.senseID = senseID;
        this.subsenses = new Vector<TEISense>();
        this.coarseLevel = coarseLevel;
        this.coarserSense = coarserSense;
        this.quotes = new Vector<MultiSelection>();
    }

    public void addSense(TEISense sense) {
        this.subsenses.add(sense);
    }

    public void addQuote(MultiSelection quote) {
        this.quotes.add(quote);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("   def: " + this.getMultiDefinition() + "(" + this.getId() + " n: " + this.getN() + ")" + "\n");
        List<TEISense> subsenses = this.getSubSenses();
        for (TEISense subsense : subsenses) {
            sb.append("       def: " + subsense.getMultiDefinition() + "(n: " + this.getN() + ")\n");
            List<String> quotes = subsense.getQuotes();
            for (String quote : quotes) {
                sb.append("           quo: " + quote + "\n");
            }
        }
        return sb.toString();
    }

    @Override
    public TEISenseEntry getSenseEntry() {
        return null;
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    public MultiSelection getMultiDefinition() {
        return this.definition;
    }

    @Override
    public String getId() {
        return this.senseID;
    }

    public List<TEISense> getSubSenses() {
        return this.subsenses;
    }

    @Override
    public List<String> getQuotes() {
        Vector<String> qs = new Vector<String>();
        for (MultiSelection quote : this.quotes) {
            String stringQuote = quote.toString();
            if (stringQuote == null || stringQuote.length() <= 0) continue;
            qs.add(quote.toString());
        }
        return qs;
    }

    public List<MultiSelection> getMultiQuotes() {
        return this.quotes;
    }

    @Override
    public Sense getCoarserSense() {
        return this.coarserSense;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    @Override
    public int getCoarseness() {
        return this.coarseLevel;
    }

    @Override
    public List<String> getAllQuotes() {
        List<String> qs = this.getQuotes();
        for (TEISense subsense : this.subsenses) {
            qs.addAll(subsense.getAllQuotes());
        }
        return qs;
    }

    public List<MultiSelection> getAllMultiQuotes() {
        Vector<MultiSelection> qs = new Vector<MultiSelection>();
        qs.addAll(this.quotes);
        for (TEISense subsense : this.subsenses) {
            qs.addAll(subsense.getAllMultiQuotes());
        }
        return qs;
    }

    @Override
    public List<String> getDefinitions() {
        Vector<String> defs = new Vector<String>();
        defs.add(this.definition.toString());
        for (TEISense subsense : this.subsenses) {
            defs.addAll(subsense.getDefinitions());
        }
        return defs;
    }

    public List<MultiSelection> getMultiDefinitions() {
        Vector<MultiSelection> defs = new Vector<MultiSelection>();
        defs.add(this.definition);
        for (TEISense subsense : this.subsenses) {
            defs.addAll(subsense.getMultiDefinitions());
        }
        return defs;
    }
}

