/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.SenseInventory;
import corpusapi.tei.TEISense;
import corpusapi.tei.TEISenseEntry;
import corpusapi.util.MultiSelection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TEISenseInventory
implements SenseInventory {
    private Map<String, TEISenseEntry> senseEntries;
    private String configFile;
    private String title;
    private Map<String, String> senseEntriesBaseMap = new HashMap<String, String>();

    public String getConfigFile() {
        return this.configFile;
    }

    public static TEISenseInventory createFromXML(String senseInventoryFile) {
        String nameSpaceURI = "http://www.w3.org/XML/1998/namespace";
        TEISenseInventory teiSI = new TEISenseInventory();
        teiSI.configFile = senseInventoryFile;
        TEISenseEntry currentSenseEntry = null;
        TEISense currentSense = null;
        TEISense currentSubSense = null;
        String currentStartElementName = null;
        boolean inDefinition = false;
        boolean inQuote = false;
        boolean inSelection = false;
        String entryID = null;
        String senseID = null;
        int senseDepth = 0;
        MultiSelection currentDefinition = new MultiSelection();
        MultiSelection currentQuote = new MultiSelection();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(senseInventoryFile), "UTF-8");
            XMLEventReader eventReader = factory.createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent element;
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    currentStartElementName = element.getName().getLocalPart();
                    if ("entry".equalsIgnoreCase(element.getName().getLocalPart())) {
                        entryID = element.getAttributeByName(new QName("http://www.w3.org/XML/1998/namespace", "id")).getValue();
                        currentSenseEntry = new TEISenseEntry(entryID, teiSI);
                    }
                    if ("sense".equalsIgnoreCase(element.getName().getLocalPart())) {
                        if (++senseDepth == 1) {
                            senseID = element.getAttributeByName(new QName("http://www.w3.org/XML/1998/namespace", "id")).getValue();
                            currentSense = new TEISense(senseID, null, senseDepth);
                            currentSense.setN(Integer.parseInt(element.getAttributeByName(new QName("n")).getValue()));
                        }
                        if (senseDepth == 2) {
                            currentSubSense = new TEISense(null, currentSense, senseDepth);
                            currentSubSense.setN(Integer.parseInt(element.getAttributeByName(new QName("n")).getValue()));
                        }
                    }
                    if ("def".equalsIgnoreCase(element.getName().getLocalPart())) {
                        inDefinition = true;
                        currentDefinition = new MultiSelection();
                    }
                    if ("quote".equalsIgnoreCase(element.getName().getLocalPart())) {
                        inQuote = true;
                        currentQuote = new MultiSelection();
                    }
                    if ("hi".equalsIgnoreCase(element.getName().getLocalPart())) {
                        inSelection = true;
                    }
                }
                if (event.isCharacters()) {
                    element = (Characters)event;
                    if (currentStartElementName.equalsIgnoreCase("pos")) {
                        currentSenseEntry.setPOS(element.getData());
                    }
                    if (currentStartElementName.equalsIgnoreCase("orth")) {
                        currentSenseEntry.setOrthForm(element.getData());
                    }
                    if (inDefinition) {
                        currentDefinition.addText(element.getData(), inSelection);
                    }
                    if (inQuote) {
                        currentQuote.addText(element.getData(), inSelection);
                    }
                    if (currentStartElementName.equalsIgnoreCase("title")) {
                        teiSI.title = element.getData();
                    }
                }
                if (!event.isEndElement()) continue;
                element = (EndElement)event;
                currentStartElementName = "";
                if ("entry".equalsIgnoreCase(element.getName().getLocalPart().toString())) {
                    teiSI.addSenseEntry(currentSenseEntry.getID(), currentSenseEntry);
                }
                if ("sense".equalsIgnoreCase(element.getName().getLocalPart())) {
                    if (senseDepth == 1) {
                        currentSenseEntry.addSense(currentSense);
                    }
                    if (senseDepth == 2) {
                        currentSense.addSense(currentSubSense);
                    }
                    --senseDepth;
                }
                if ("hi".equalsIgnoreCase(element.getName().getLocalPart())) {
                    inSelection = false;
                }
                if ("def".equalsIgnoreCase(element.getName().getLocalPart())) {
                    if (senseDepth == 1) {
                        currentSense.setDefinition(currentDefinition);
                    }
                    if (senseDepth == 2) {
                        currentSubSense.setDefinition(currentDefinition);
                    }
                    inDefinition = false;
                }
                if (!"quote".equalsIgnoreCase(element.getName().getLocalPart())) continue;
                if (senseDepth == 1) {
                    currentSense.addQuote(currentQuote);
                }
                if (senseDepth == 2) {
                    currentSubSense.addQuote(currentQuote);
                }
                inQuote = false;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teiSI;
    }

    public TEISenseInventory() {
        this.senseEntries = new HashMap<String, TEISenseEntry>();
    }

    public Map<String, TEISenseEntry> getSenseEntries() {
        return this.senseEntries;
    }

    @Override
    public TEISenseEntry getSenseEntryByOrth(String orth) {
        return this.senseEntries.get(this.senseEntriesBaseMap.get(orth));
    }

    public TEISense getSenseById(String senseId) {
        String entryName = null;
        String entryVer = null;
        String entryId = null;
        String[] s = senseId.split("\\#");
        if (s.length == 2) {
            entryId = s[1];
        } else if (s.length == 1) {
            entryId = s[0];
        } else {
            return null;
        }
        s = entryId.split("\\.");
        if (s.length == 2) {
            entryName = s[0];
            entryVer = s[1];
        } else if (s.length == 1) {
            entryName = s[0];
        } else {
            return null;
        }
        TEISenseEntry entry = this.getSenseEntries().get(entryName);
        for (TEISense sense : entry.getSenseList()) {
            if (!sense.getId().equals(entryId)) continue;
            return sense;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public void addSenseEntry(String entryID, TEISenseEntry senseEntry) {
        this.senseEntries.put(entryID, senseEntry);
        this.senseEntriesBaseMap.put(senseEntry.getOrthForm(), entryID);
    }
}

