/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei.readers;

import corpusapi.tei.TEICorpusText;
import corpusapi.tei.readers.TEIMorphoReader;
import corpusapi.tei.readers.TEISegmentationReader;
import corpusapi.tei.readers.TEISenseReader;
import corpusapi.tei.readers.TEITextReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class TEIReader {
    protected static Map<String, TEIReader> teiReaderMap = new HashMap<String, TEIReader>();
    protected static XMLInputFactory factory = XMLInputFactory.newInstance();
    protected TEICorpusText corpusText;
    protected File file;
    protected String fileContents;
    protected Reader reader;
    protected boolean cached;
    protected Integer cacheMaxItems = null;

    protected TEIReader(String fileName, TEICorpusText corpusText) {
        this.file = new File(fileName);
        this.corpusText = corpusText;
        this.cached = corpusText.getCorpus().isCached();
        if (this.cached) {
            this.cacheMaxItems = 100;
        }
    }

    public static void closeTEIReader(String filename) throws XMLStreamException, IOException {
        TEIReader t = teiReaderMap.remove(filename);
        if (t != null) {
            t.close();
        }
    }

    public static TEIReader getTEIReader(String fileName, TEICorpusText corpusText) {
        TEIReader teiReader = null;
        teiReader = teiReaderMap.get(fileName);
        if (teiReader == null) {
            teiReader = new TEIReader(fileName, corpusText);
            teiReaderMap.put(fileName, teiReader);
        }
        return teiReader;
    }

    public static TEISegmentationReader getTEISegmentationReader(TEICorpusText corpusText) {
        String fileName = corpusText.getSegmentationFilePath();
        TEIReader teiReader = teiReaderMap.get(fileName);
        if (teiReader == null) {
            teiReader = new TEISegmentationReader(fileName, corpusText);
            teiReaderMap.put(fileName, teiReader);
            return (TEISegmentationReader)teiReader;
        }
        if (teiReader instanceof TEISegmentationReader) {
            return (TEISegmentationReader)teiReader;
        }
        return null;
    }

    public static TEISenseReader getTEISenseReader(TEICorpusText corpusText) {
        String fileName = corpusText.getSensesFilePath();
        TEIReader teiReader = teiReaderMap.get(fileName);
        if (teiReader == null) {
            teiReader = new TEISenseReader(fileName, corpusText);
            teiReaderMap.put(fileName, teiReader);
            return (TEISenseReader)teiReader;
        }
        if (teiReader instanceof TEISenseReader) {
            return (TEISenseReader)teiReader;
        }
        return null;
    }

    public static TEIMorphoReader getTEIMorphoReader(TEICorpusText corpusText) {
        String fileName = corpusText.getMorphoFilePath();
        TEIReader teiReader = teiReaderMap.get(fileName);
        if (teiReader == null) {
            teiReader = new TEIMorphoReader(fileName, corpusText);
            teiReaderMap.put(fileName, teiReader);
            return (TEIMorphoReader)teiReader;
        }
        if (teiReader instanceof TEIMorphoReader) {
            return (TEIMorphoReader)teiReader;
        }
        return null;
    }

    public static TEITextReader getTEITextReader(TEICorpusText corpusText) {
        String fileName = corpusText.getTextFilePath();
        TEIReader teiReader = teiReaderMap.get(fileName);
        if (teiReader == null) {
            teiReader = new TEITextReader(fileName, corpusText);
            teiReaderMap.put(fileName, teiReader);
            return (TEITextReader)teiReader;
        }
        if (teiReader instanceof TEITextReader) {
            return (TEITextReader)teiReader;
        }
        return null;
    }

    public Reader getTextReader() throws IOException {
        if (this.reader == null) {
            this.reader = this.createTextReader();
        }
        return this.reader;
    }

    public Reader createTextReader() throws IOException {
        if (this.fileContents == null) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
            String line = null;
            StringBuilder buffer = new StringBuilder((int)this.file.length());
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
            br.close();
            this.fileContents = buffer.toString();
            if (TEITextReader.class.isInstance(this)) {
                this.fileContents = this.fileContents.replace("&quot;", "\"");
                this.fileContents = this.fileContents.replace("&amp;", "*");
                this.fileContents = this.fileContents.replace("&gt;", "}");
                this.fileContents = this.fileContents.replace("&lt;", "{");
                this.fileContents = this.fileContents.replace("&apos;", "'");
            }
        }
        StringReader sr = new StringReader(this.fileContents);
        sr.mark(0);
        return sr;
    }

    public XMLEventReader createEventReader() throws XMLStreamException, IOException {
        return factory.createXMLEventReader(this.createTextReader());
    }

    public XMLStreamReader2 createStreamReader() throws XMLStreamException, IOException {
        return (XMLStreamReader2)factory.createXMLStreamReader(this.createTextReader());
    }

    public void close() throws XMLStreamException, IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.fileContents = null;
        this.file = null;
        this.corpusText = null;
    }
}

