/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei.readers;

import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegment;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISentenceSegmentGroup;
import corpusapi.tei.readers.TEIReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class TEISegmentationReader
extends TEIReader {
    private Map<String, TEISegment> segmentCacheId;
    private String currentComment1 = null;
    private String currentSentenceId1 = null;
    private String currentPId1 = null;
    private TEISegment currentSegment1 = null;
    private XMLStreamReader2 sr1;
    private TEISentenceSegmentGroup currentSentence2 = null;
    private XMLStreamReader2 sr2;
    private String currentTextBlockId3 = null;
    private XMLStreamReader2 sr3;
    private String currentTextBlockId4 = null;
    private String currentSentenceId4 = null;
    private String currentPId4 = null;
    private String currentSegmentId4 = null;
    private String prevSegmentId4 = null;
    private String currentComment4 = null;
    private XMLStreamReader2 sr4 = null;

    protected TEISegmentationReader(String fileName, TEICorpusText corpusText) {
        super(fileName, corpusText);
        if (this.cached) {
            this.segmentCacheId = this.cacheMaxItems == null ? new LinkedHashMap<String, TEISegment>() : new LinkedHashMap<String, TEISegment>(){
                private static final long serialVersionUID = -6839392540762832442L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, TEISegment> eldest) {
                    return this.size() > TEISegmentationReader.this.cacheMaxItems;
                }
            };
        }
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.currentComment1 = null;
        this.currentComment4 = null;
        this.currentSegment1 = null;
        this.currentSegmentId4 = null;
        this.currentSentence2 = null;
        this.currentSentenceId1 = null;
        this.currentSentenceId4 = null;
        this.currentTextBlockId3 = null;
        this.currentTextBlockId4 = null;
        this.prevSegmentId4 = null;
        if (this.segmentCacheId != null) {
            this.segmentCacheId.clear();
            this.segmentCacheId = null;
        }
        if (this.sr1 != null) {
            this.sr1.close();
            this.sr1 = null;
        }
        if (this.sr2 != null) {
            this.sr2.close();
            this.sr2 = null;
        }
        if (this.sr3 != null) {
            this.sr3.close();
            this.sr3 = null;
        }
        if (this.sr4 != null) {
            this.sr4.close();
            this.sr4 = null;
        }
        super.close();
    }

    public TEISegment createSegment(String segmentId, TEICorpusText corpusText, String nextSegmentId, String prevSegmentId, String textBlockId, String sentenceId, int startIdx, int endIdx, int segmentPosition, String pId, String resultOrth) {
        resultOrth = resultOrth.trim();
        if (this.cached) {
            TEISegment segment = null;
            segment = this.segmentCacheId.get(segmentId);
            if (segment == null) {
                segment = new TEISegment(segmentId, corpusText, nextSegmentId, prevSegmentId, textBlockId, sentenceId, startIdx, endIdx, segmentPosition, pId, resultOrth);
                this.segmentCacheId.put(segmentId, segment);
            }
            return segment;
        }
        return new TEISegment(segmentId, corpusText, nextSegmentId, prevSegmentId, textBlockId, sentenceId, startIdx, endIdx, segmentPosition, pId, resultOrth);
    }

    public TEISegment getFirstSegmentItText() throws XMLStreamException, IOException {
        XMLStreamReader2 sr = this.createStreamReader();
        int resultStartIdx = 0;
        int resultEndIdx = 0;
        int resultSegmentPosition = 0;
        String resultSegmentId = null;
        String resultNextSegmentId = null;
        String resultSentenceId = null;
        String resultPrevSegmentId = null;
        String resultTextBlockId = null;
        String resultPId = null;
        String resultOrth = null;
        boolean found = false;
        String currentSegmentId = null;
        String currentSentenceId = null;
        String currentTextBlockId = null;
        String currentPId = null;
        String prevSegmentId = null;
        String currentComment = null;
        while (sr.hasNext()) {
            int event = sr.next();
            if (event == 5) {
                currentComment = sr.getText();
                continue;
            }
            if (event != 1) continue;
            QName name = sr.getName();
            String local = name.getLocalPart();
            if ("seg".equals(local)) {
                String rejected = sr.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected");
                if (rejected != null && rejected.equals("true")) continue;
                currentSegmentId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                String corresp = sr.getAttributeValue(null, "corresp");
                String[] chopped = corresp.split("[(,)]");
                currentTextBlockId = chopped.length > 3 ? chopped[1] : "";
                if (!found) {
                    found = true;
                    resultOrth = currentComment;
                    resultSegmentId = currentSegmentId;
                    resultSentenceId = currentSentenceId;
                    resultPrevSegmentId = prevSegmentId;
                    resultTextBlockId = currentTextBlockId;
                    resultPId = currentPId;
                    resultSegmentPosition = 0;
                    if (chopped.length > 3) {
                        resultStartIdx = Integer.parseInt(chopped[2]);
                        resultEndIdx = resultStartIdx + Integer.parseInt(chopped[3]);
                    }
                } else {
                    resultNextSegmentId = currentSegmentId;
                    break;
                }
                prevSegmentId = currentSegmentId;
                continue;
            }
            if ("s".equals(local)) {
                currentSentenceId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                continue;
            }
            if (!"p".equals(local)) continue;
            currentPId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
        }
        TEISegment result = null;
        if (found) {
            result = this.createSegment(resultSegmentId, this.corpusText, resultNextSegmentId, resultPrevSegmentId, resultTextBlockId, resultSentenceId, resultStartIdx, resultEndIdx, resultSegmentPosition, resultPId, resultOrth);
        }
        return result;
    }

    private boolean setStreamReader1(String segmentId) throws XMLStreamException, IOException {
        if (this.currentSegment1 == null || !segmentId.equals(this.currentSegment1.getNextSegmentId())) {
            this.sr1 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEISegment getSegmentById(String segmentId) throws XMLStreamException, IOException {
        if (this.cached && this.segmentCacheId.containsKey(segmentId)) {
            return this.segmentCacheId.get(segmentId);
        }
        boolean oldStream = this.setStreamReader1(segmentId);
        int resultStartIdx = 0;
        int resultEndIdx = 0;
        int resultSegmentPosition = 0;
        String resultSegmentId = null;
        String resultNextSegmentId = null;
        String resultSentenceId = null;
        String resultPrevSegmentId = null;
        String resultTextBlockId = null;
        String resultPId = null;
        String resultOrth = null;
        boolean found = false;
        int currentSegmentPosition = -1;
        String currentSegmentId = null;
        String currentSentenceId = null;
        String currentTextBlockId = null;
        String currentPId = null;
        String prevSegmentId = null;
        String currentComment = null;
        while (this.sr1.hasNext() || oldStream) {
            int event = 0;
            if (!oldStream) {
                event = this.sr1.next();
            }
            if (event == 1 || oldStream) {
                QName name;
                String local;
                if (oldStream) {
                    oldStream = false;
                    currentSegmentPosition = this.currentSegment1.getSegmentPosition();
                    currentSegmentId = this.currentSegment1.getNextSegmentId();
                    currentSentenceId = this.currentSentenceId1;
                    currentPId = this.currentPId1;
                    currentComment = this.currentComment1;
                    currentTextBlockId = this.currentSegment1.getTextBlockId();
                    prevSegmentId = this.currentSegment1.getId();
                }
                if ("seg".equals(local = (name = this.sr1.getName()).getLocalPart())) {
                    String rejected = this.sr1.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected");
                    if (rejected != null && rejected.equals("true")) continue;
                    currentSegmentId = this.sr1.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                    if (!found) {
                        String corresp = this.sr1.getAttributeValue(null, "corresp");
                        String[] chopped = corresp.split("[(,)]");
                        String textBlockId = "";
                        if (chopped.length > 3) {
                            textBlockId = chopped[1];
                        }
                        if (textBlockId.equals(currentTextBlockId)) {
                            ++currentSegmentPosition;
                        } else {
                            currentTextBlockId = textBlockId;
                            currentSegmentPosition = 0;
                        }
                        if (currentSegmentId.equals(segmentId)) {
                            found = true;
                            resultOrth = currentComment;
                            resultSegmentId = currentSegmentId;
                            resultSentenceId = currentSentenceId;
                            resultPrevSegmentId = prevSegmentId;
                            resultTextBlockId = currentTextBlockId;
                            resultPId = currentPId;
                            resultSegmentPosition = currentSegmentPosition;
                            if (chopped.length <= 3) continue;
                            resultStartIdx = Integer.parseInt(chopped[2]);
                            resultEndIdx = resultStartIdx + Integer.parseInt(chopped[3]);
                            continue;
                        }
                        prevSegmentId = currentSegmentId;
                        continue;
                    }
                    resultNextSegmentId = currentSegmentId;
                    break;
                }
                if ("s".equals(local)) {
                    currentSentenceId = this.sr1.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                    continue;
                }
                if (!"p".equals(local)) continue;
                currentPId = this.sr1.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                continue;
            }
            if (event != 5) continue;
            currentComment = this.sr1.getText();
        }
        TEISegment result = null;
        if (found) {
            result = this.createSegment(resultSegmentId, this.corpusText, resultNextSegmentId, resultPrevSegmentId, resultTextBlockId, resultSentenceId, resultStartIdx, resultEndIdx, resultSegmentPosition, resultPId, resultOrth);
            this.currentComment1 = currentComment;
            this.currentSegment1 = result;
            this.currentSentenceId1 = currentSentenceId;
            this.currentPId1 = currentPId;
        } else {
            this.currentSegment1 = null;
        }
        return result;
    }

    public TEISegmentGroup getFirstSentenceSegmentGroup() throws XMLStreamException, IOException {
        XMLStreamReader2 sr = this.createStreamReader();
        boolean start = false;
        String currentSegmentId = null;
        ArrayList<String> segmentIdList = new ArrayList<String>();
        String resultId = null;
        String nextSentId = null;
        TEISentenceSegmentGroup result = null;
        while (sr.hasNext()) {
            String rejected;
            int event = sr.next();
            if (event != 1) continue;
            QName name = sr.getName();
            String local = name.getLocalPart();
            if ("s".equals(local)) {
                String sentenceId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                if (!start) {
                    resultId = sentenceId;
                    start = true;
                    continue;
                }
                nextSentId = sentenceId;
                break;
            }
            if (!start || !"seg".equals(local) || (rejected = sr.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected")) != null && rejected.equals("true")) continue;
            currentSegmentId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            segmentIdList.add(currentSegmentId);
        }
        if (resultId != null) {
            result = new TEISentenceSegmentGroup(resultId, segmentIdList, nextSentId, null, this.corpusText);
        }
        sr.close();
        return result;
    }

    private boolean setStreamReader2(String groupId) throws XMLStreamException, IOException {
        if (this.currentSentence2 == null || !groupId.equals(this.currentSentence2.nextGroupId)) {
            this.sr2 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEISentenceSegmentGroup getSentenceSegmentGroupById(String sentenceGroupId) throws XMLStreamException, IOException {
        boolean oldStream = this.setStreamReader2(sentenceGroupId);
        boolean start = false;
        String currentSegmentId = null;
        ArrayList<String> segmentIdList = new ArrayList<String>();
        String nextSentId = null;
        String prevSentId = null;
        TEISentenceSegmentGroup result = null;
        while (this.sr2.hasNext() || oldStream) {
            String rejected;
            QName name;
            String local;
            int event = 0;
            if (!oldStream) {
                event = this.sr2.next();
            }
            if (event != 1 && !oldStream) continue;
            if (oldStream) {
                oldStream = false;
                prevSentId = this.currentSentence2.getId();
            }
            if ("s".equals(local = (name = this.sr2.getName()).getLocalPart())) {
                if (!start) {
                    String sentenceId = this.sr2.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                    if (sentenceGroupId.equals(sentenceId)) {
                        start = true;
                        continue;
                    }
                    prevSentId = sentenceId;
                    continue;
                }
                nextSentId = this.sr2.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                break;
            }
            if (!start || !"seg".equals(local) || (rejected = this.sr2.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected")) != null && rejected.equals("true")) continue;
            currentSegmentId = this.sr2.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            segmentIdList.add(currentSegmentId);
        }
        this.currentSentence2 = sentenceGroupId != null ? (result = new TEISentenceSegmentGroup(sentenceGroupId, segmentIdList, nextSentId, prevSentId, this.corpusText)) : null;
        return result;
    }

    private boolean setStreamReader3(String blockId) throws XMLStreamException, IOException {
        if (this.currentTextBlockId3 == null || !this.currentTextBlockId3.equals(blockId)) {
            this.sr3 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public int getBlockSize(String blockId) throws XMLStreamException, IOException {
        boolean oldStream = this.setStreamReader3(blockId);
        this.currentTextBlockId3 = null;
        int foundSegments = 0;
        while (this.sr3.hasNext() || oldStream) {
            String rejected;
            QName name;
            String local;
            int event = 0;
            if (!oldStream) {
                event = this.sr3.next();
            }
            if (event != 1 && !oldStream) continue;
            if (oldStream) {
                oldStream = false;
            }
            if (!"seg".equals(local = (name = this.sr3.getName()).getLocalPart()) || (rejected = this.sr3.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected")) != null && rejected.equals("true")) continue;
            String corresp = this.sr3.getAttributeValue(null, "corresp");
            if (corresp.contains(blockId)) {
                ++foundSegments;
                continue;
            }
            if (foundSegments <= 0) continue;
            String[] chopped = corresp.split("[(,)]");
            if (chopped.length <= 3) break;
            this.currentTextBlockId3 = chopped[1];
            break;
        }
        return foundSegments;
    }

    private boolean setStreamReader4(String blockId) throws XMLStreamException, IOException {
        if (this.currentTextBlockId4 == null || !this.currentTextBlockId4.equals(blockId)) {
            this.sr4 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEISegment getFirstSegmentInBlock(String blockId) throws XMLStreamException, IOException {
        boolean oldStream = this.setStreamReader4(blockId);
        this.currentTextBlockId4 = null;
        int resultStartIdx = 0;
        int resultEndIdx = 0;
        int resultSegmentPosition = 0;
        String resultSegmentId = null;
        String resultNextSegmentId = null;
        String resultSentenceId = null;
        String resultPrevSegmentId = null;
        String resultTextBlockId = null;
        String resultPId = null;
        String resultOrth = null;
        boolean found = false;
        String currentSegmentId = null;
        String currentSentenceId = null;
        String currentTextBlockId = null;
        String currentPId = null;
        String prevSegmentId = null;
        String currentComment = null;
        while (this.sr4.hasNext() || oldStream) {
            int event;
            block7: {
                String local;
                block8: {
                    block10: {
                        block9: {
                            QName name;
                            event = 0;
                            if (!oldStream) {
                                event = this.sr4.next();
                            }
                            if (event != 1 && !oldStream) break block7;
                            if (oldStream) {
                                oldStream = false;
                                currentComment = this.currentComment4;
                                currentSegmentId = this.currentSegmentId4;
                                currentSentenceId = this.currentSentenceId4;
                                currentPId = this.currentPId4;
                                currentTextBlockId = blockId;
                                prevSegmentId = this.prevSegmentId4;
                            }
                            if (!"seg".equals(local = (name = this.sr4.getName()).getLocalPart())) break block8;
                            String rejected = this.sr4.getAttributeValue("http://www.nkjp.pl/ns/1.0", "rejected");
                            if (rejected != null && rejected.equals("true")) continue;
                            currentSegmentId = this.sr4.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                            String corresp = this.sr4.getAttributeValue(null, "corresp");
                            String[] chopped = corresp.split("[(,)]");
                            currentTextBlockId = chopped.length > 3 ? chopped[1] : "";
                            if (found) break block9;
                            if (!blockId.equals(currentTextBlockId)) break block10;
                            found = true;
                            resultOrth = currentComment;
                            resultPId = currentPId;
                            resultSegmentId = currentSegmentId;
                            resultSentenceId = currentSentenceId;
                            resultPrevSegmentId = prevSegmentId;
                            resultTextBlockId = currentTextBlockId;
                            resultSegmentPosition = 0;
                            if (chopped.length <= 3) break block10;
                            resultStartIdx = Integer.parseInt(chopped[2]);
                            resultEndIdx = resultStartIdx + Integer.parseInt(chopped[3]);
                            break block10;
                        }
                        if (resultNextSegmentId == null) {
                            resultNextSegmentId = currentSegmentId;
                        }
                        if (!currentTextBlockId.equals(blockId)) {
                            this.prevSegmentId4 = prevSegmentId;
                            this.currentSegmentId4 = currentSegmentId;
                            this.currentSentenceId4 = currentSentenceId;
                            this.currentTextBlockId4 = currentTextBlockId;
                            this.currentPId4 = currentPId;
                            this.currentComment4 = currentComment;
                            break;
                        }
                    }
                    prevSegmentId = currentSegmentId;
                    continue;
                }
                if ("s".equals(local)) {
                    currentSentenceId = this.sr4.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                    continue;
                }
                if (!"p".equals(local)) continue;
                currentPId = this.sr4.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                continue;
            }
            if (event != 5) continue;
            currentComment = this.sr4.getText();
        }
        TEISegment result = null;
        if (found) {
            result = this.createSegment(resultSegmentId, this.corpusText, resultNextSegmentId, resultPrevSegmentId, resultTextBlockId, resultSentenceId, resultStartIdx, resultEndIdx, resultSegmentPosition, resultPId, resultOrth);
        }
        return result;
    }
}

