/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei.readers;

import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISenseSegmentGroup;
import corpusapi.tei.readers.TEIReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class TEISenseReader
extends TEIReader {
    private TEISegmentGroup lastSegmentGroup = null;
    private XMLStreamReader2 streamReader;

    protected TEISenseReader(String fileName, TEICorpusText corpusText) {
        super(fileName, corpusText);
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.lastSegmentGroup = null;
        if (this.streamReader != null) {
            this.streamReader.close();
            this.streamReader = null;
        }
        super.close();
    }

    public TEISegmentGroup getFirstSenseSegmentGroup() throws XMLStreamException, IOException {
        XMLStreamReader2 sr = this.createStreamReader();
        String id = null;
        String fVal = null;
        ArrayList<String> segmentIdList = new ArrayList<String>();
        while (sr.hasNext()) {
            int event = sr.next();
            if (event != 1) continue;
            QName name = sr.getName();
            String local = name.getLocalPart();
            if (id != null && "f".equals(local)) {
                fVal = sr.getAttributeValue(null, "fVal");
            }
            if (!"seg".equals(local)) continue;
            String segmentId = sr.getAttributeValue(null, "corresp").split("#")[1];
            if (id != null) {
                String nextId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                sr.close();
                return new TEISenseSegmentGroup(id, this.corpusText, segmentIdList, nextId, null, fVal);
            }
            id = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            segmentIdList.add(segmentId);
        }
        sr.close();
        if (fVal != null) {
            return new TEISenseSegmentGroup(id, this.corpusText, segmentIdList, null, null, fVal);
        }
        return null;
    }

    public TEISenseSegmentGroup getSenseSegmentGroupBySegmentId(String segmentId) throws XMLStreamException, IOException {
        ArrayList<String> segmentIdList = new ArrayList<String>();
        segmentIdList.add(segmentId);
        XMLStreamReader2 sr = this.createStreamReader();
        String id = null;
        String lastId = null;
        String fVal = null;
        while (sr.hasNext()) {
            int event = sr.next();
            if (event != 1) continue;
            QName name = sr.getName();
            String local = name.getLocalPart();
            if (id != null && "f".equals(local)) {
                fVal = sr.getAttributeValue(null, "fVal");
            }
            if (!"seg".equals(local)) continue;
            String corresp = sr.getAttributeValue(null, "corresp");
            if (id != null) {
                String nextId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                sr.close();
                return new TEISenseSegmentGroup(id, this.corpusText, segmentIdList, nextId, lastId, fVal);
            }
            if (corresp.contains(segmentId)) {
                id = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                continue;
            }
            lastId = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            sr.skipElement();
        }
        sr.close();
        if (fVal != null) {
            return new TEISenseSegmentGroup(id, this.corpusText, segmentIdList, null, lastId, fVal);
        }
        return null;
    }

    private boolean setStreamReaderForGroupId(String groupId) throws XMLStreamException, IOException {
        if (this.lastSegmentGroup == null || !groupId.equals(this.lastSegmentGroup.nextGroupId)) {
            this.streamReader = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEISenseSegmentGroup getSenseSegmentGroupById(String groupId) throws XMLStreamException, IOException {
        boolean oldStream = this.setStreamReaderForGroupId(groupId);
        ArrayList<String> segmentIdList = new ArrayList<String>();
        String segmentId = null;
        String lastId = null;
        String nextId = null;
        String fVal = null;
        while (this.streamReader.hasNext() || oldStream) {
            int event = 0;
            if (!oldStream) {
                event = this.streamReader.next();
            }
            if (event != 1 && !oldStream) continue;
            if (oldStream) {
                oldStream = false;
                lastId = this.lastSegmentGroup.getId();
            }
            QName name = this.streamReader.getName();
            String local = name.getLocalPart();
            if (segmentId != null && "f".equals(local)) {
                fVal = this.streamReader.getAttributeValue(null, "fVal");
            }
            if (!"seg".equals(local)) continue;
            if (fVal != null) {
                nextId = this.streamReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                break;
            }
            String id = this.streamReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            if (id.equals(groupId)) {
                segmentId = this.streamReader.getAttributeValue(null, "corresp").split("#")[1];
                segmentIdList.add(segmentId);
                continue;
            }
            lastId = id;
            this.streamReader.skipElement();
        }
        if (fVal != null) {
            this.lastSegmentGroup = new TEISenseSegmentGroup(groupId, this.corpusText, segmentIdList, nextId, lastId, fVal);
            return (TEISenseSegmentGroup)this.lastSegmentGroup;
        }
        this.lastSegmentGroup = null;
        return null;
    }
}

