/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei.readers;

import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEITextBlock;
import corpusapi.tei.readers.TEIReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TEITextReader
extends TEIReader {
    protected StringReader textOrthReader;
    protected String orthFileContents;

    protected TEITextReader(String fileName, TEICorpusText corpusText) {
        super(fileName, corpusText);
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        if (this.textOrthReader != null) {
            this.textOrthReader.close();
            this.textOrthReader = null;
        }
        this.orthFileContents = null;
        super.close();
    }

    public StringReader getTextReaderForOrth() throws IOException {
        if (this.textOrthReader == null) {
            this.textOrthReader = this.createTextReaderForOrth();
        }
        return this.textOrthReader;
    }

    public StringReader createTextReaderForOrth() throws IOException {
        if (this.orthFileContents == null) {
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            String line = null;
            StringBuilder buffer = new StringBuilder((int)this.file.length());
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
            br.close();
            this.orthFileContents = buffer.toString();
            this.orthFileContents = this.orthFileContents.replace("&quot;", "\"");
            this.orthFileContents = this.orthFileContents.replace("&amp;", "&");
            this.orthFileContents = this.orthFileContents.replace("&gt;", ">");
            this.orthFileContents = this.orthFileContents.replace("&lt;", "<");
            this.orthFileContents = this.orthFileContents.replace("&apos;", "'");
        }
        StringReader sr = new StringReader(this.orthFileContents);
        sr.mark(0);
        return sr;
    }

    public TEITextBlock getTextBlockById(String textBlockId) throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.createEventReader();
        boolean prevRelated = true;
        int textBlockLength = 0;
        int textBlockFilePosition = 0;
        int textBlockPosition = -1;
        boolean textBlockNextRelated = false;
        String textBlockType = null;
        boolean textBlockFound = false;
        try {
            boolean blockOpened = false;
            while (eventReader.hasNext()) {
                XMLEvent element;
                QName qName;
                XMLEvent event = eventReader.nextEvent();
                if (event.isEndElement() && ((qName = (element = (EndElement)event).getName()).getLocalPart().equalsIgnoreCase("ab") || qName.getLocalPart().equalsIgnoreCase("p") || qName.getLocalPart().equalsIgnoreCase("u"))) {
                    if (textBlockFound) {
                        textBlockLength = element.getLocation().getCharacterOffset() - textBlockFilePosition;
                    }
                    blockOpened = false;
                }
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    qName = element.getName();
                    if (qName.getLocalPart().equalsIgnoreCase("div")) {
                        if (textBlockFound) {
                            textBlockNextRelated = false;
                            break;
                        }
                        prevRelated = false;
                    }
                    if (qName.getLocalPart().equalsIgnoreCase("ab") || qName.getLocalPart().equalsIgnoreCase("p") || qName.getLocalPart().equalsIgnoreCase("u")) {
                        blockOpened = true;
                        if (textBlockFound) {
                            textBlockNextRelated = true;
                            break;
                        }
                        QName attrName = new QName("http://www.w3.org/XML/1998/namespace", "id");
                        ++textBlockPosition;
                        if (textBlockId.equals(element.getAttributeByName(attrName).getValue())) {
                            textBlockType = qName.getLocalPart();
                            textBlockFound = true;
                        } else {
                            prevRelated = true;
                        }
                    }
                }
                if (!event.isCharacters() || !blockOpened || !textBlockFound) continue;
                Characters chars = (Characters)event;
                textBlockFilePosition = chars.getLocation().getCharacterOffset();
            }
            eventReader.close();
        }
        catch (XMLStreamException e) {
            System.out.println(e);
        }
        return new TEITextBlock(this.corpusText, textBlockId, textBlockType, textBlockFilePosition, textBlockLength, prevRelated, textBlockNextRelated, textBlockPosition);
    }
}

