/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.Corpus;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISenseSegmentGroup;

class InCorpusPosition {
    Corpus corpus;
    String textId;
    TEICorpusText text;
    TEISenseSegmentGroup ssgroup;
    int textNumber = 0;

    public InCorpusPosition(Corpus corpus) {
        this.corpus = corpus;
        this.textId = null;
        this.ssgroup = null;
        this.text = null;
    }

    public TEISenseSegmentGroup getNext() {
        if (this.ssgroup == null ? !this.nextText() : (this.ssgroup = (TEISenseSegmentGroup)this.ssgroup.getNext()) == null && !this.nextText()) {
            return null;
        }
        return this.ssgroup;
    }

    private boolean getFirstGroupInText() {
        TEISegmentGroup sg = null;
        try {
            sg = this.text.getFirstSegmentGroup(TEISenseSegmentGroup.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ssgroup = (TEISenseSegmentGroup)sg;
        return this.ssgroup != null;
    }

    private boolean nextText() {
        if (this.textNumber >= this.corpus.getCorpusTextIds().size()) {
            return false;
        }
        if (this.text != null) {
            this.text.closeCorpusText();
        }
        this.textId = this.corpus.getCorpusTextIds().get(this.textNumber);
        this.text = (TEICorpusText)this.corpus.getCorpusText(this.textId);
        ++this.textNumber;
        if (!this.getFirstGroupInText()) {
            return this.nextText();
        }
        return true;
    }
}

