/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.SegmentGroup;
import corpusapi.TextBlock;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegment;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;

public class TEITextBlock
implements TextBlock {
    private TEICorpusText corpusText;
    private String textBlockId;
    private TextBlock.TextBlockType textBlockType;
    protected long filePosition;
    protected int position;
    protected boolean prevRelated;
    protected boolean nextRelated;
    protected long length;
    private int size = -1;

    public TEITextBlock(TEICorpusText corpusText, String textBlockId, String textBlockType, long filePosition, int length, boolean prevRelated, boolean nextRelated, int position) {
        this.corpusText = corpusText;
        this.length = length;
        this.textBlockId = textBlockId;
        if ("ab".equalsIgnoreCase(textBlockType)) {
            this.textBlockType = TextBlock.TextBlockType.AB;
        } else if ("ab".equalsIgnoreCase(textBlockType)) {
            this.textBlockType = TextBlock.TextBlockType.P;
        } else if ("u".equalsIgnoreCase(textBlockType)) {
            this.textBlockType = TextBlock.TextBlockType.U;
        }
        this.filePosition = filePosition;
        this.prevRelated = prevRelated;
        this.nextRelated = nextRelated;
        this.position = position;
    }

    @Override
    public TEISegment getSegment(int idx) throws Exception {
        if (idx < 0 || idx >= this.getSize()) {
            return null;
        }
        TEISegment result = null;
        TEISegmentationReader reader = TEIReader.getTEISegmentationReader(this.corpusText);
        try {
            int currentIndex = 0;
            result = reader.getFirstSegmentInBlock(this.textBlockId);
            while (currentIndex < idx && result != null) {
                result = result.getNext();
                ++currentIndex;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null) {
            result.textBlock = this;
        }
        return result;
    }

    @Override
    public int getSize() {
        if (this.size == -1) {
            TEISegmentationReader reader = TEIReader.getTEISegmentationReader(this.corpusText);
            try {
                this.size = reader.getBlockSize(this.textBlockId);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.size;
    }

    @Override
    public TextBlock.TextBlockType getType() {
        return this.textBlockType;
    }

    @Override
    public boolean isNextRelated() {
        return this.nextRelated;
    }

    @Override
    public boolean isPrevRelated() {
        return this.prevRelated;
    }

    @Override
    public TEICorpusText getCorpusText() {
        return this.corpusText;
    }

    public String toString() {
        TEIReader teiReader = TEIReader.getTEIReader(this.corpusText.getTextFilePath(), this.corpusText);
        try {
            Reader reader = teiReader.getTextReader();
            reader.reset();
            reader.skip(this.filePosition);
            char[] buf = new char[80];
            reader.read(buf, 0, this.length < 80L ? (int)this.length : 80);
            return (Object)((Object)this.textBlockType) + " : " + this.filePosition + " : " + this.length + " : " + this.textBlockId + " : " + this.prevRelated + " : " + this.nextRelated + " : " + new String(buf, 0, this.length < 80L ? (int)this.length : 80);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public TEITextBlock getNext() {
        return this.corpusText.getTextBlock(this.position + 1);
    }

    @Override
    public TEITextBlock getPrev() {
        return this.corpusText.getTextBlock(this.position - 1);
    }

    @Override
    public TEISegmentGroup getSegmentGroup(int idx, Class<? extends SegmentGroup> type) throws Exception {
        TEISegment s = this.getSegment(idx);
        if (s != null) {
            return s.getSegmentGroup((Class)type);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.corpusText == null ? 0 : this.corpusText.hashCode());
        result = 31 * result + (this.textBlockId == null ? 0 : this.textBlockId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEITextBlock other = (TEITextBlock)obj;
        if (this.corpusText == null ? other.corpusText != null : !this.corpusText.equals(other.corpusText)) {
            return false;
        }
        return !(this.textBlockId == null ? other.textBlockId != null : !this.textBlockId.equals(other.textBlockId));
    }

    public boolean isRelatedToSuccessor(TEITextBlock other) {
        TEITextBlock block;
        if (this.equals(other)) {
            return true;
        }
        if (!this.isNextRelated()) {
            return false;
        }
        for (block = this.getNext(); block != null && !block.equals(other); block = block.getNext()) {
            if (block.isNextRelated()) {
                continue;
            }
            return false;
        }
        return block != null;
    }

    @Override
    public String getId() {
        return this.textBlockId;
    }

    public int getPosition() {
        return this.position;
    }
}

