package corpusapi.tei;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

import corpusapi.Corpus;

public class TEICorpus implements Corpus {
	private boolean cached = false;
	private List<String> corpusTexts = null;
	private Map<String, String> corpusTextMap = null;
	private String corpusId;

	public TEICorpus(List<String> corpusTexts, boolean cached, String corpusId) {
		this.cached = cached;
		this.corpusTexts = corpusTexts;
		this.corpusId = corpusId;
	}

	@Override
	public boolean close() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public TEICorpusHeader getCorpusHeader() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public TEICorpusText getCorpusText(String textId) {
		return new TEICorpusText(this, textId, corpusTextMap.get(textId));
	}

	@Override
	public List<String> getCorpusTextIds() {
		if (corpusTextMap == null) {
			return null;
		}
		List<String> ids = new ArrayList<String>();
		ids.addAll(corpusTextMap.keySet());
		return ids;
	}

	@Override
	public boolean open() {
		this.corpusTextMap = getTextMap();

		if (this.corpusTextMap != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isCached() {
		return cached;
	}

	private Map<String, String> getTextMap() {
		Map<String, String> corpusTextMap = new LinkedHashMap<String, String>();

		XMLInputFactory factory = XMLInputFactory.newInstance();
		factory.setProperty(factory.SUPPORT_DTD, false);
		InputStreamReader reader;

		try {
			for (String ct : corpusTexts) {
				reader = new InputStreamReader(new FileInputStream(ct + File.separator + "header.xml"), "UTF-8");
				XMLEventReader eventReader = factory.createXMLEventReader(reader);
				while (eventReader.hasNext()) {
					XMLEvent event = eventReader.nextEvent();
					if (event.isStartElement()) {
						StartElement element = (StartElement) event;
						if (element.getName().toString().endsWith("teiHeader")) {
							Iterator it = element.getAttributes();
							while (it.hasNext()) {
								Attribute attr = (Attribute) it.next();
								if (attr.getName().getLocalPart().equalsIgnoreCase("id")) {
									String key = attr.getValue();
									if (corpusTextMap.containsKey(key)) {
										System.out.println("Key already exists!");
//										System.out.println(corpusTextMap.get(key));
										System.out.println(ct);
										Random r = new Random(1);
										while (corpusTextMap.containsKey(key)) {
											key += r.nextInt(10);
										}
									}
									corpusTextMap.put(key, ct);
								}
							}
							break;
						}
					}
				}
				eventReader.close();
				reader.close();
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return corpusTextMap;
	}

	@Override
	public String getId() {
		return corpusId;
	}
}
