package corpusapi;

import java.util.List;

public interface Segment {
	
	/**
	 * Zwraca następny segment, zawsze kontynuuje w następnym bloku
	 * @return
	 * @throws Exception 
	 */
	public Segment getNext() throws Exception;
	
	/**
	 * Zwraca następny segment. W zależności od wskazanego trybu:
	 * zwraca null, kiedy dojdzie do końca bloku,
	 * kontynuuje w następnym bloku tekstu, jeśli stanowią one ciągły fragment(np. kolejne paragrafy z książki)
	 * 
	 * @param mode ALWAYS_STOP, CONTINUOUS, ALWAYS_CONTINUE - odpowiednio 1, 2 lub 3 przypadek
	 * @return
	 * @throws Exception 
	 */	
	public Segment getNext(ContinueMode mode) throws Exception;
	
	/**
	 * Zwraca poprzedni segment, zawsze kontynuuje w poprzednim bloku
	 * @return
	 * @throws Exception 
	 */	
	public Segment getPrev() throws Exception;
	/**
	 * Zwraca poprzedni segment. W zależności od wskazanego trybu:
	 * zwraca null, kiedy dojdzie do początku bloku,
	 * kontynuuje w poprzednim bloku tekstu, jeśli stanowią one ciągły fragment (np. kolejne paragrafy z książki)
	 * zawsze kontynuuje w poprzednim bloku
	 * @param mode ALWAYS_STOP, CONTINUOUS, ALWAYS_CONTINUE - odpowiednio 1, 2 lub 3 przypadek
	 * @return
	 * @throws Exception 
	 */
	public Segment getPrev(ContinueMode mode) throws Exception;
	
	/**
	 * Zwraca segment sąsiadujący, w podanej odległości od bieżącego (wartości ujemne - wcześniejsze) lub null, jeśli nie ma
	 * @param dist przemieszczenie
	 * @return
	 * @throws Exception 
	 */
	public Segment getNeighbor(int dist) throws Exception;
	
	/**
	 * Zwraca segment sąsiadujący, w podanej odległości od bieżącego. W zależności od wskazanego trybu:
	 * zwraca null, kiedy dojdzie do początku bloku,
	 * kontynuuje w poprzednim bloku tekstu, jeśli stanowią one ciągły fragment (np. kolejne paragrafy z książki)
	 * zawsze kontynuuje w poprzednim bloku
	 * @param dist przemieszczenie
	 * @param mode ALWAYS_STOP, CONTINUOUS, ALWAYS_CONTINUE - odpowiednio 1, 2 lub 3 przypadek
	 * @return
	 * @throws Exception 
	 */
	public Segment getNeighbor(int dist, ContinueMode mode) throws Exception;
	
	/**
	 * Zwraca pozycję segmentu w ramach bloku tekstu
	 * @return pozycja segmentu w ramach bloku tekstu
	 */
	public int getPosition();
	
	/**
	 * Zwraca listę grup segmentów, w których znajduje się bieżący segment
	 * @return lista grup segmentów, w których znajduje się bieżący segment
	 */
	public List<SegmentGroup> getSegmentGroups();
	
	/**
	 * Zwraca grupę segmentów o podanym typie, w której znajduje się bieżący segment
	 * lub null, jeśli takiej nie ma
	 * @param type typ grupy segmentów (poziom anotacji)
	 * @return grupa segmentów
	 */
	public SegmentGroup getSegmentGroup(Class<? extends SegmentGroup> type);
	
	/**
	 * Zwraca pierwszą grupę segmentów o podanym typie, która znajduje się za lub przed grupą segmentów,
	 * która dotyczy bieżącego segmentu, zgodnie z polityką w argumencie
	 * @param dir kierunek, w którym szukać (ujemna - w lewo, dodatnia - w prawo)
	 * @param type typ grupy segmentów (poziom anotacji)
	 * @param mode polityka przechodzenia do niezwiazanych blokow tekstu
	 * @return
	 * @throws Exception 
	 */
	public SegmentGroup getFirstSegmentGroup(int dir, Class<? extends SegmentGroup> type, ContinueMode mode) throws Exception;
	
	public TextBlock getTextBlock();
	
	/**
	 * Zwraca formę ortograficzną segmentu.
	 * @return forma ortograficzna w tekście
	 */
	public String getOrth();
	
	public String getId();
}
