/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.SegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegment;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public abstract class TEISegmentGroup
implements SegmentGroup {
    protected String id;
    protected List<String> segmentIdList;
    protected int currentPosition = 0;
    public String nextGroupId = null;
    protected String prevGroupId = null;
    public TEICorpusText corpusText;

    public TEISegmentGroup(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId) {
        this.id = id;
        this.corpusText = corpusText;
        this.segmentIdList = segmentIdList;
        this.nextGroupId = nextGroupId;
        this.prevGroupId = prevGroupId;
    }

    @Override
    public TEISegment getFirstSegment() {
        if (this.segmentIdList.isEmpty()) {
            return null;
        }
        this.currentPosition = 0;
        TEISegment segment = null;
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            segment = segmentationReader.getSegmentById(this.segmentIdList.get(this.currentPosition));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (segment != null) {
            ++this.currentPosition;
        }
        return segment;
    }

    @Override
    public TEISegmentGroup getNext() {
        return this.getNext(ContinueMode.ALWAYS_CONTINUE);
    }

    @Override
    public abstract TEISegmentGroup getNext(ContinueMode var1);

    @Override
    public TEISegment getNextSegment() {
        if (!this.hasNextSegment()) {
            return null;
        }
        TEISegment segment = null;
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            segment = segmentationReader.getSegmentById(this.segmentIdList.get(this.currentPosition));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (segment != null) {
            ++this.currentPosition;
        }
        return segment;
    }

    @Override
    public TEISegmentGroup getPrev() {
        return this.getPrev(ContinueMode.ALWAYS_CONTINUE);
    }

    @Override
    public abstract TEISegmentGroup getPrev(ContinueMode var1);

    @Override
    public TEISegment getSegment(int idx) {
        if (this.segmentIdList.size() <= idx || idx < 0) {
            return null;
        }
        TEISegment segment = null;
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            segment = segmentationReader.getSegmentById(this.segmentIdList.get(idx));
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return segment;
    }

    @Override
    public int[] getSegmentPositions() {
        int[] result = new int[this.segmentIdList.size()];
        int i = 0;
        for (String id : this.segmentIdList) {
            TEISegment seg = null;
            try {
                TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
                seg = segmentationReader.getSegmentById(id);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result[i++] = seg.segmentPosition;
        }
        return result;
    }

    @Override
    public int getSize() {
        return this.segmentIdList.size();
    }

    @Override
    public boolean hasNextSegment() {
        return this.segmentIdList.size() > this.currentPosition;
    }

    public String toString() {
        return "id=" + this.id + ", nextGroupId=" + this.nextGroupId + ", prevGroupId=" + this.prevGroupId;
    }

    protected TEISegmentGroup getNeighbour(ContinueMode mode, TEISegmentGroup first, TEISegmentGroup second, boolean returnFirst) {
        if (!mode.equals((Object)ContinueMode.ALWAYS_CONTINUE)) {
            TEISegment lastSegment = first.getSegment(first.getSize() - 1);
            TEISegment firstSegment = second.getFirstSegment();
            if (mode.equals((Object)ContinueMode.ALWAYS_STOP) ? !lastSegment.getTextBlock().equals(firstSegment.getTextBlock()) : mode.equals((Object)ContinueMode.CONTINUOUS) && !lastSegment.isRelatedToSuccessor(firstSegment)) {
                return null;
            }
        }
        if (returnFirst) {
            return first;
        }
        return second;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getSegmentIds() {
        return this.segmentIdList;
    }
}

