/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics;

import java.text.DecimalFormat;
import java.util.Vector;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.BlockDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.ChapmanLengthDeviation;
import uk.ac.shef.wit.simmetrics.similaritymetrics.ChapmanMatchingSoundex;
import uk.ac.shef.wit.simmetrics.similaritymetrics.ChapmanMeanLength;
import uk.ac.shef.wit.simmetrics.similaritymetrics.CosineSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.DiceSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.EuclideanDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaccardSimilarity;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Jaro;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaroWinkler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.MatchingCoefficient;
import uk.ac.shef.wit.simmetrics.similaritymetrics.MongeElkan;
import uk.ac.shef.wit.simmetrics.similaritymetrics.NeedlemanWunch;
import uk.ac.shef.wit.simmetrics.similaritymetrics.OverlapCoefficient;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWaterman;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotoh;
import uk.ac.shef.wit.simmetrics.similaritymetrics.SmithWatermanGotohWindowedAffine;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Soundex;

public final class TestEstimatedTimes {
    private static final int TESTTIMINGMILLISECONDSPERTEST = 200;
    private static final int TESTMAXLENGTHTIMINGTEST = 2000;
    private static final int TESTMAXLENGTHTIMINGSTEPSIZE = 50;
    private static final int TESTMAXLENGTHTIMINGTERMLENGTH = 10;

    public static void main(String[] args) {
        Vector<AbstractStringMetric> testMetricVector = new Vector<AbstractStringMetric>();
        testMetricVector.add(new Levenshtein());
        testMetricVector.add(new NeedlemanWunch());
        testMetricVector.add(new SmithWaterman());
        testMetricVector.add(new ChapmanLengthDeviation());
        testMetricVector.add(new ChapmanMeanLength());
        testMetricVector.add(new SmithWatermanGotoh());
        testMetricVector.add(new SmithWatermanGotohWindowedAffine());
        testMetricVector.add(new BlockDistance());
        testMetricVector.add(new MongeElkan());
        testMetricVector.add(new Jaro());
        testMetricVector.add(new JaroWinkler());
        testMetricVector.add(new Soundex());
        testMetricVector.add(new ChapmanMatchingSoundex());
        testMetricVector.add(new MatchingCoefficient());
        testMetricVector.add(new DiceSimilarity());
        testMetricVector.add(new JaccardSimilarity());
        testMetricVector.add(new OverlapCoefficient());
        testMetricVector.add(new EuclideanDistance());
        testMetricVector.add(new CosineSimilarity());
        testMetricVector.add(new QGramsDistance());
        TestEstimatedTimes.testMethod(testMetricVector, args);
    }

    private static void testMethod(Vector metricVector, String[] args) {
        System.out.println("Usage: testMethod ");
        System.out.println("AS NO INPUT - running defualt test\n");
        System.out.println("Performing Tests with Following Metrics:");
        for (int i = 0; i < metricVector.size(); ++i) {
            System.out.println("m" + (i + 1) + " " + ((AbstractStringMetric)metricVector.get(i)).getShortDescriptionString());
        }
        System.out.println();
        System.out.print("\n");
        DecimalFormat df = new DecimalFormat("0.00");
        int metricTests = 0;
        long totalTime = System.currentTimeMillis();
        for (int i = 0; i < metricVector.size(); ++i) {
            AbstractStringMetric metric = (AbstractStringMetric)metricVector.get(i);
            System.out.print("m" + (i + 1) + "\t");
            StringBuffer testString = new StringBuffer();
            int termLen = 0;
            int len = 1;
            while (len < 2000) {
                if (termLen < 10) {
                    testString.append((char)(97 + (int)(Math.random() * 25.0)));
                } else {
                    testString.append(' ');
                    termLen = 0;
                }
                ++len;
                ++termLen;
            }
            for (len = 1; len < 2000; len += 50) {
                long timeTaken = 0L;
                int iterations = 0;
                String input1 = testString.substring(0, len);
                while (timeTaken < 200L) {
                    timeTaken += metric.getSimilarityTimingActual(input1, input1);
                    ++iterations;
                    ++metricTests;
                }
                System.out.print(df.format((float)timeTaken / (float)iterations) + "(" + metric.getSimilarityTimingEstimated(input1, input1) + ")\t");
            }
            System.out.print("\t(" + metric.getShortDescriptionString() + ") - testsSoFar = " + metricTests + "\n");
        }
        totalTime = System.currentTimeMillis() - totalTime;
        System.out.println("\nTotal Metrics Tests = " + metricTests + " in " + totalTime + "ms\t\t meaning " + df.format((float)metricTests / (float)totalTime) + " tests per millisecond");
    }
}

