/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public final class EuclideanDistance
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 7.4457144E-5f;
    private final InterfaceTokeniser tokeniser;

    public EuclideanDistance() {
        this.tokeniser = new TokeniserWhitespace();
    }

    public EuclideanDistance(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    public String getShortDescriptionString() {
        return "EuclideanDistance";
    }

    public String getLongDescriptionString() {
        return "Implements the Euclidean Distancey algorithm providing a similarity measure between two stringsusing the vector space of combined terms as the dimensions";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return ((str1Tokens + str2Tokens) * str1Tokens + (str1Tokens + str2Tokens) * str2Tokens) * 7.4457144E-5f;
    }

    public float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        float totalPossible = (float)Math.sqrt(str1Tokens.size() * str1Tokens.size() + str2Tokens.size() * str2Tokens.size());
        float totalDistance = this.getUnNormalisedSimilarity(string1, string2);
        return (totalPossible - totalDistance) / totalPossible;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(str1Tokens);
        allTokens.addAll(str2Tokens);
        float totalDistance = 0.0f;
        for (String token : allTokens) {
            int countInString1 = 0;
            int countInString2 = 0;
            for (String sToken : str1Tokens) {
                if (!sToken.equals(token)) continue;
                ++countInString1;
            }
            for (String sToken : str2Tokens) {
                if (!sToken.equals(token)) continue;
                ++countInString2;
            }
            totalDistance += (float)((countInString1 - countInString2) * (countInString1 - countInString2));
        }
        totalDistance = (float)Math.sqrt(totalDistance);
        return totalDistance;
    }

    public float getEuclidDistance(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(str1Tokens);
        allTokens.addAll(str2Tokens);
        float totalDistance = 0.0f;
        for (String token : allTokens) {
            int countInString1 = 0;
            int countInString2 = 0;
            for (String sToken : str1Tokens) {
                if (!sToken.equals(token)) continue;
                ++countInString1;
            }
            for (String sToken : str2Tokens) {
                if (!sToken.equals(token)) continue;
                ++countInString2;
            }
            totalDistance += (float)((countInString1 - countInString2) * (countInString1 - countInString2));
        }
        return (float)Math.sqrt(totalDistance);
    }
}

