/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.math.MathFuncs;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Jaro;

public final class JaroWinkler
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 4.342E-5f;
    private final AbstractStringMetric internalStringMetric = new Jaro();
    private static final int MINPREFIXTESTLENGTH = 6;
    private static final float PREFIXADUSTMENTSCALE = 0.1f;

    public String getShortDescriptionString() {
        return "JaroWinkler";
    }

    public String getLongDescriptionString() {
        return "Implements the Jaro-Winkler algorithm providing a similarity measure between two strings allowing character transpositions to a degree adjusting the weighting for common prefixes";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 4.342E-5f;
    }

    public float getSimilarity(String string1, String string2) {
        float dist = this.internalStringMetric.getSimilarity(string1, string2);
        int prefixLength = JaroWinkler.getPrefixLength(string1, string2);
        return dist + (float)prefixLength * 0.1f * (1.0f - dist);
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.getSimilarity(string1, string2);
    }

    private static int getPrefixLength(String string1, String string2) {
        int n = MathFuncs.min3(6, string1.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string1.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n;
    }
}

