/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.math.MathFuncs;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AbstractSubstitutionCost;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.SubCost01;

public final class Levenshtein
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 1.8E-4f;
    private final AbstractSubstitutionCost dCostFunc = new SubCost01();

    public String getShortDescriptionString() {
        return "Levenshtein";
    }

    public String getLongDescriptionString() {
        return "Implements the basic Levenshtein algorithm providing a similarity measure between two strings";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 1.8E-4f;
    }

    public float getSimilarity(String string1, String string2) {
        float levensteinDistance = this.getUnNormalisedSimilarity(string1, string2);
        float maxLen = string1.length();
        if (maxLen < (float)string2.length()) {
            maxLen = string2.length();
        }
        if (maxLen == 0.0f) {
            return 1.0f;
        }
        return 1.0f - levensteinDistance / maxLen;
    }

    public float getUnNormalisedSimilarity(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                float cost = this.dCostFunc.getCost(s, i - 1, t, j - 1);
                d[i][j] = MathFuncs.min3(d[i - 1][j] + 1.0f, d[i][j - 1] + 1.0f, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }
}

