/*
 * Decompiled with CFR 0.152.
 */
package corpusapi;

import corpusapi.Corpus;
import corpusapi.SenseInventory;
import corpusapi.tei.TEICorpus;
import corpusapi.tei.TEISenseInventory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CorpusFactory {
    private static CorpusFactory INSTANCE;

    private CorpusFactory() {
    }

    public static CorpusFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CorpusFactory();
        }
        return INSTANCE;
    }

    public SenseInventory getSenseInventory(String configFile) {
        String senseInventoryFile = null;
        String senseInventoryType = null;
        String pathToConfig = this.getPathToConfig(configFile);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            FileReader reader = new FileReader(configFile);
            XMLEventReader eventReader = factory.createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                StartElement element;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !"senseInventory".equalsIgnoreCase((element = (StartElement)event).getName().toString())) continue;
                Attribute attr = element.getAttributeByName(new QName("path"));
                senseInventoryFile = attr.getValue();
                attr = element.getAttributeByName(new QName("type"));
                senseInventoryType = attr.getValue();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (senseInventoryType == null) {
            return null;
        }
        if ("TEI".equals(senseInventoryType.toUpperCase())) {
            return TEISenseInventory.createFromXML(String.valueOf(pathToConfig) + senseInventoryFile);
        }
        return null;
    }

    private String getPathToConfig(String configFile) {
        String result = "";
        int slash = configFile.lastIndexOf(File.separator);
        if (slash > -1) {
            result = configFile.substring(0, slash);
            result = result.concat(File.separator);
        }
        return result;
    }

    public Corpus getCorpus(String configFile, boolean cached) {
        String corpusType = null;
        String corpusId = null;
        List<String> corpusTexts = null;
        String pathToConfig = this.getPathToConfig(configFile);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            FileReader reader = new FileReader(configFile);
            XMLEventReader eventReader = factory.createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                Attribute attr;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = (StartElement)event;
                if ("corpus".equalsIgnoreCase(element.getName().toString())) {
                    attr = element.getAttributeByName(new QName("type"));
                    corpusType = attr.getValue();
                    Attribute attr2 = element.getAttributeByName(new QName("id"));
                    corpusId = attr2.getValue();
                }
                if (!"text".equalsIgnoreCase(element.getName().toString())) continue;
                attr = element.getAttributeByName(new QName("path"));
                corpusTexts = this.getCorpusTextsPaths(String.valueOf(pathToConfig) + attr.getValue());
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (corpusType == null) {
            return null;
        }
        if ("TEI".equals(corpusType.toUpperCase())) {
            return new TEICorpus(corpusTexts, cached, corpusId);
        }
        return null;
    }

    private List<String> getCorpusTextsPaths(String path) {
        ArrayList<String> result = new ArrayList<String>();
        CorpusFactory.walkIn(new File(path), result);
        return result;
    }

    public static void walkIn(File dir, List<String> result) {
        String pattern = "header.xml";
        File[] listFile = dir.listFiles();
        if (listFile != null) {
            File[] fileArray = listFile;
            int n = listFile.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    CorpusFactory.walkIn(file, result);
                } else if (file.getName().equals(pattern)) {
                    result.add(file.getParent());
                }
                ++n2;
            }
        }
    }

    public String[] getCorporaTypes() {
        return new String[]{"TEI"};
    }

    public String[] getSenseInventoryTypes() {
        return new String[]{"TEI"};
    }
}

