/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.Corpus;
import corpusapi.tei.TEICorpusHeader;
import corpusapi.tei.TEICorpusText;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TEICorpus
implements Corpus {
    private boolean cached = false;
    private List<String> corpusTexts = null;
    private Map<String, String> corpusTextMap = null;
    private String corpusId;

    public TEICorpus(List<String> corpusTexts, boolean cached, String corpusId) {
        this.cached = cached;
        this.corpusTexts = corpusTexts;
        this.corpusId = corpusId;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    public TEICorpusHeader getCorpusHeader() {
        return null;
    }

    @Override
    public TEICorpusText getCorpusText(String textId) {
        return new TEICorpusText(this, textId, this.corpusTextMap.get(textId));
    }

    @Override
    public List<String> getCorpusTextIds() {
        if (this.corpusTextMap == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(this.corpusTextMap.keySet());
        return ids;
    }

    @Override
    public boolean open() {
        this.corpusTextMap = this.getTextMap();
        return this.corpusTextMap != null;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    private Map<String, String> getTextMap() {
        LinkedHashMap<String, String> corpusTextMap = new LinkedHashMap<String, String>();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        try {
            for (String ct : this.corpusTexts) {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(String.valueOf(ct) + File.separator + "header.xml"), "UTF-8");
                XMLEventReader eventReader = factory.createXMLEventReader(reader);
                while (eventReader.hasNext()) {
                    StartElement element;
                    XMLEvent event = eventReader.nextEvent();
                    if (!event.isStartElement() || !(element = (StartElement)event).getName().toString().endsWith("teiHeader")) continue;
                    Iterator<Attribute> it = element.getAttributes();
                    while (it.hasNext()) {
                        Attribute attr = it.next();
                        if (!attr.getName().getLocalPart().equalsIgnoreCase("id")) continue;
                        String key = attr.getValue();
                        if (corpusTextMap.containsKey(key)) {
                            System.out.println("Key already exists!");
                            System.out.println(ct);
                            Random r = new Random(1L);
                            while (corpusTextMap.containsKey(key)) {
                                key = String.valueOf(key) + r.nextInt(10);
                            }
                        }
                        corpusTextMap.put(key, ct);
                    }
                    break block5;
                }
                eventReader.close();
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return corpusTextMap;
    }

    @Override
    public String getId() {
        return this.corpusId;
    }
}

