/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.Corpus;
import corpusapi.CorpusText;
import corpusapi.MorphoSegmentGroup;
import corpusapi.SegmentGroup;
import corpusapi.SenseSegmentGroup;
import corpusapi.SentenceSegmentGroup;
import corpusapi.tei.TEICorpus;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegment;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISenseSegmentGroup;
import corpusapi.tei.TEISentenceSegmentGroup;
import corpusapi.tei.TEITextBlock;
import corpusapi.tei.readers.TEIMorphoReader;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;
import corpusapi.tei.readers.TEISenseReader;
import corpusapi.tei.readers.TEITextReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class TEICorpusText
implements CorpusText {
    private TEICorpus corpus;
    private String textId;
    private String path;
    private int blockIterator = 0;
    private int blockCount = Integer.MAX_VALUE;
    protected List<TEITextBlock> blockList = new ArrayList<TEITextBlock>();
    XMLEventReader eventReader = null;
    XMLEvent eventBuffer = null;

    public TEICorpusText(TEICorpus corpus, String textId, String path) {
        this.corpus = corpus;
        this.textId = textId;
        this.path = path;
    }

    @Override
    public TEITextBlock getFirstTextBlock() {
        this.eventReader = null;
        this.blockIterator = 0;
        return this.getNextTextBlock();
    }

    @Override
    public TEITextBlock getNextTextBlock() {
        if (this.blockIterator >= this.blockCount) {
            return null;
        }
        if (this.blockIterator < this.blockList.size()) {
            TEITextBlock textBlock = this.blockList.get(this.blockIterator);
            ++this.blockIterator;
            return textBlock;
        }
        if (this.eventReader == null) {
            try {
                TEITextReader teiReader = TEIReader.getTEITextReader(this);
                this.eventReader = teiReader.createEventReader();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        TEITextBlock textBlock = null;
        boolean prevRelated = true;
        try {
            boolean blockOpened = false;
            while (this.eventBuffer != null || this.eventReader.hasNext()) {
                XMLEvent element;
                QName qName;
                XMLEvent event;
                if (this.eventBuffer != null) {
                    event = this.eventBuffer;
                    this.eventBuffer = null;
                } else {
                    event = this.eventReader.nextEvent();
                }
                if (event.isEndElement() && ((qName = (element = (EndElement)event).getName()).getLocalPart().equalsIgnoreCase("ab") || qName.getLocalPart().equalsIgnoreCase("p") || qName.getLocalPart().equalsIgnoreCase("u"))) {
                    if (textBlock != null) {
                        textBlock.length = (long)element.getLocation().getCharacterOffset() - textBlock.filePosition;
                    }
                    blockOpened = false;
                }
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    qName = element.getName();
                    if (qName.getLocalPart().equalsIgnoreCase("div")) {
                        if (textBlock != null) {
                            this.eventBuffer = element;
                            textBlock.nextRelated = false;
                            return textBlock;
                        }
                        prevRelated = false;
                    }
                    if (qName.getLocalPart().equalsIgnoreCase("ab") || qName.getLocalPart().equalsIgnoreCase("p") || qName.getLocalPart().equalsIgnoreCase("u")) {
                        blockOpened = true;
                        if (textBlock != null) {
                            this.eventBuffer = element;
                            textBlock.nextRelated = true;
                            return textBlock;
                        }
                        QName attrName = new QName("http://www.w3.org/XML/1998/namespace", "id");
                        textBlock = new TEITextBlock(this, element.getAttributeByName(attrName).getValue(), qName.getLocalPart(), 0L, 0, prevRelated, false, this.blockIterator);
                        ++this.blockIterator;
                        this.blockList.add(textBlock);
                    }
                }
                if (!event.isCharacters() || !blockOpened || textBlock == null) continue;
                Characters chars = (Characters)event;
                textBlock.filePosition = chars.getLocation().getCharacterOffset();
            }
            this.blockCount = this.blockList.size();
            this.eventReader.close();
        }
        catch (XMLStreamException e) {
            System.out.println(e);
        }
        return textBlock;
    }

    @Override
    public boolean hasNextTextBlock() {
        int oldIterator = this.blockIterator;
        TEITextBlock textBlock = this.getNextTextBlock();
        this.blockIterator = oldIterator;
        return textBlock != null;
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void closeCorpusText() {
        try {
            TEIReader.closeTEIReader(this.getMorphoFilePath());
            TEIReader.closeTEIReader(this.getSegmentationFilePath());
            TEIReader.closeTEIReader(this.getSensesFilePath());
            if (this.eventReader != null) {
                this.eventReader.close();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.eventBuffer = null;
        if (this.blockList != null) {
            this.blockList.clear();
        }
        this.blockList = null;
        this.blockIterator = 0;
        this.blockCount = Integer.MAX_VALUE;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getTextFilePath() {
        return String.valueOf(this.path) + File.separator + "text.xml";
    }

    public String getSegmentationFilePath() {
        return String.valueOf(this.path) + File.separator + "ann_segmentation.xml";
    }

    public String getMorphoFilePath() {
        return String.valueOf(this.path) + File.separator + "ann_morphosyntax.xml";
    }

    public String getSensesFilePath() {
        return String.valueOf(this.path) + File.separator + "ann_senses.xml";
    }

    @Override
    public TEITextBlock getTextBlock(int position) {
        if (position < 0) {
            return null;
        }
        if (position < this.blockList.size()) {
            return this.blockList.get(position);
        }
        int oldIterator = this.blockIterator;
        TEITextBlock textBlock = null;
        while (this.blockIterator != position) {
            textBlock = this.getNextTextBlock();
        }
        textBlock = this.getNextTextBlock();
        this.blockIterator = oldIterator;
        return textBlock;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.textId == null ? 0 : this.textId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEICorpusText other = (TEICorpusText)obj;
        return !(this.textId == null ? other.textId != null : !this.textId.equals(other.textId));
    }

    public TEISegmentGroup getFirstSegmentGroup(Class<? extends SegmentGroup> type) throws Exception {
        if (type.equals(SentenceSegmentGroup.class) || type.equals(TEISentenceSegmentGroup.class)) {
            TEISegmentationReader reader = TEIReader.getTEISegmentationReader(this);
            return reader.getFirstSentenceSegmentGroup();
        }
        if (type.equals(SenseSegmentGroup.class) || type.equals(TEISenseSegmentGroup.class)) {
            TEISenseReader reader = TEIReader.getTEISenseReader(this);
            return reader.getFirstSenseSegmentGroup();
        }
        if (type.equals(MorphoSegmentGroup.class) || type.equals(TEIMorphoSegmentGroup.class)) {
            TEIMorphoReader reader = TEIReader.getTEIMorphoReader(this);
            return reader.getFirstMorphoSegmentGroup();
        }
        return null;
    }

    @Override
    public TEISegment getFirstSegment() throws Exception {
        TEISegmentationReader reader = TEIReader.getTEISegmentationReader(this);
        return reader.getFirstSegmentItText();
    }
}

