/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.Corpus;
import corpusapi.CorpusFactory;
import corpusapi.CorpusTools;
import corpusapi.SegmentGroup;
import corpusapi.SenseSegmentGroup;
import corpusapi.SenseStatistics;
import corpusapi.tei.InCorpusPosition;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISenseSegmentGroup;
import corpusapi.tei.TEISenseStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TEICorpusTools
extends CorpusTools {
    HashMap<String, InCorpusPosition> corpusPositionsMap = new HashMap();

    @Override
    public String format(Corpus corpus, List<List<? extends SegmentGroup>> interp) {
        return null;
    }

    private SenseSegmentGroup getNextSense(Corpus corpus, String senseOrSenseEntry) {
        Type type = senseOrSenseEntry == null ? Type.ALL : (senseOrSenseEntry.matches(".*\\.[0-9]+") || senseOrSenseEntry.matches(".*\\.INNE") ? Type.SENSE_ENTRY : Type.SENSE);
        InCorpusPosition icp = null;
        if (!this.corpusPositionsMap.containsKey(String.valueOf(corpus.getId()) + "+" + senseOrSenseEntry)) {
            icp = new InCorpusPosition(corpus);
            this.corpusPositionsMap.put(String.valueOf(corpus.getId()) + "+" + senseOrSenseEntry, icp);
        } else {
            icp = this.corpusPositionsMap.get(String.valueOf(corpus.getId()) + "+" + senseOrSenseEntry);
        }
        TEISenseSegmentGroup s = null;
        while ((s = icp.getNext()) != null) {
            if (type == Type.ALL) {
                return s;
            }
            String toCompareFromS = s.getSenseId().substring(s.getSenseId().indexOf(35) + 1);
            if (type != Type.SENSE_ENTRY) {
                if (toCompareFromS.equals("NULL")) {
                    System.out.println("Warning! NULL sense");
                    continue;
                }
                toCompareFromS = toCompareFromS.substring(0, toCompareFromS.lastIndexOf(46));
            }
            if (!toCompareFromS.equals(senseOrSenseEntry)) continue;
            return s;
        }
        return null;
    }

    @Override
    public SenseSegmentGroup getNextSenseEntryInstance(Corpus corpus) {
        return this.getNextSense(corpus, null);
    }

    @Override
    public SenseSegmentGroup getNextSenseEntryInstance(Corpus corpus, String senseEntry) {
        return this.getNextSense(corpus, senseEntry);
    }

    @Override
    public SenseSegmentGroup getNextSenseInstance(Corpus corpus, String sense) {
        return this.getNextSense(corpus, sense);
    }

    @Override
    protected SenseStatistics makeSenseStatistics(Corpus corpus, Set<String> senseEntries) {
        TEISenseStatistics stats = new TEISenseStatistics(corpus.getId());
        HashMap senseCounter = new HashMap();
        corpus.open();
        List<String> textIDs = corpus.getCorpusTextIds();
        long time = System.nanoTime();
        for (String textID : textIDs) {
            TEICorpusText corpusText = (TEICorpusText)corpus.getCorpusText(textID);
            SenseSegmentGroup senseGroup = null;
            try {
                senseGroup = (SenseSegmentGroup)((Object)corpusText.getFirstSegmentGroup(SenseSegmentGroup.class));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (senseGroup != null) {
                do {
                    String sense = senseGroup.getSenseId();
                    if ((sense = sense.substring(sense.indexOf(35) + 1)).equals("NULL")) continue;
                    String senseEntry = sense.substring(0, sense.lastIndexOf(46));
                    if (senseEntries != null && !senseEntries.contains(senseEntry)) continue;
                    stats.addOccurence(senseEntry, sense);
                } while ((senseGroup = (SenseSegmentGroup)senseGroup.getNext(ContinueMode.ALWAYS_CONTINUE)) != null);
            }
            corpusText.closeCorpusText();
        }
        stats.complete = senseEntries == null;
        return stats;
    }

    public static void main(String[] args) {
        TEISenseSegmentGroup tEISenseSegmentGroup;
        TEISenseSegmentGroup tEISenseSegmentGroup2;
        CorpusFactory factory = CorpusFactory.getInstance();
        Corpus corpus = factory.getCorpus("data/nowy_format.xml", true);
        corpus.open();
        TEICorpusTools ct = new TEICorpusTools();
        TEISenseStatistics stats = (TEISenseStatistics)ct.getSenseStatistics(corpus, "raz");
        System.out.println(stats.getSenseEntryCount("raz"));
        Set<String> ss = stats.senseEntrySenseMap.get("raz");
        System.out.println(ss.toString());
        for (String string : ss) {
            System.out.println(String.valueOf(string) + ":" + stats.getSenseCount(string));
        }
        Object var6_8 = null;
        System.out.println(ct.getNextSenseEntryInstance(corpus, "wyjsc").getSenseId());
        System.out.println(ct.getNextSenseEntryInstance(corpus, "raz").getSenseId());
        System.out.println(ct.getNextSenseEntryInstance(corpus, "wyjsc").getSenseId());
        System.out.println(ct.getNextSenseEntryInstance(corpus, "raz").getSenseId());
        System.out.println(ct.getNextSenseEntryInstance(corpus, "raz.2").getSenseId());
        while ((tEISenseSegmentGroup2 = (TEISenseSegmentGroup)ct.getNextSenseInstance(corpus, "raz.2")) != null) {
            System.out.println("wystapienie: " + tEISenseSegmentGroup2.getSenseId() + " referencja do segmentu: " + tEISenseSegmentGroup2.getFirstSegment());
        }
        while ((tEISenseSegmentGroup = (TEISenseSegmentGroup)ct.getNextSenseEntryInstance(corpus)) != null) {
            System.out.println(tEISenseSegmentGroup.getSenseId());
        }
        System.out.println("OK");
        ct.getSenseStatistics(corpus);
        System.out.println("OK");
        ct.makeSenseStatistics(corpus, null);
    }

    private static enum Type {
        ALL,
        SENSE,
        SENSE_ENTRY;

    }
}

