/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.MorphoSegmentGroup;
import corpusapi.Segment;
import corpusapi.SegmentGroup;
import corpusapi.SenseSegmentGroup;
import corpusapi.SentenceSegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.TEISenseSegmentGroup;
import corpusapi.tei.TEISentenceSegmentGroup;
import corpusapi.tei.TEITextBlock;
import corpusapi.tei.readers.TEIMorphoReader;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;
import corpusapi.tei.readers.TEISenseReader;
import corpusapi.tei.readers.TEITextReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class TEISegment
implements Segment {
    protected String segmentId;
    protected TEICorpusText corpusText;
    protected String nextSegmentId;
    protected String prevSegmentId;
    protected String textBlockId = null;
    protected String sentenceId = null;
    protected String pId;
    protected int startIdx;
    protected int endIdx;
    protected int segmentPosition;
    protected String orth = null;
    protected TEITextBlock textBlock = null;

    public TEISegment(String segmentId, TEICorpusText corpusText, String nextSegmentId, String prevSegmentId, String textBlockId, String sentenceId, int startIdx, int endIdx, int segmentPosition, String pId, String resultOrth) {
        this.segmentId = segmentId;
        this.corpusText = corpusText;
        this.nextSegmentId = nextSegmentId;
        this.prevSegmentId = prevSegmentId;
        this.textBlockId = textBlockId;
        this.sentenceId = sentenceId;
        this.endIdx = endIdx;
        this.startIdx = startIdx;
        this.segmentPosition = segmentPosition;
        this.pId = pId;
        this.orth = resultOrth;
    }

    @Override
    public TEISegmentGroup getFirstSegmentGroup(int dir, Class<? extends SegmentGroup> type, ContinueMode mode) throws Exception {
        SegmentGroup currentSegmentGroup = this.getSegmentGroup((Class)type);
        if (currentSegmentGroup == null) {
            if (dir > 0) {
                TEISegment s = this.getNext(mode);
                while (s != null) {
                    SegmentGroup segmentGroup = s.getSegmentGroup((Class)type);
                    if (segmentGroup != null) {
                        return segmentGroup;
                    }
                    s = s.getNext(mode);
                }
            } else if (dir < 0) {
                TEISegment s = this.getPrev(mode);
                while (s != null) {
                    SegmentGroup segmentGroup = s.getSegmentGroup((Class)type);
                    if (segmentGroup != null) {
                        return segmentGroup;
                    }
                    s = s.getPrev(mode);
                }
            }
        } else {
            if (dir > 0) {
                return ((TEISegmentGroup)currentSegmentGroup).getNext(mode);
            }
            if (dir < 0) {
                return ((TEISegmentGroup)currentSegmentGroup).getPrev(mode);
            }
        }
        return null;
    }

    @Override
    public TEISegment getNeighbor(int dist) throws Exception {
        return this.getNeighbor(dist, ContinueMode.ALWAYS_STOP);
    }

    @Override
    public TEISegment getNeighbor(int dist, ContinueMode mode) throws Exception {
        int newIdx = this.segmentPosition + dist;
        TEITextBlock blockWithSegment = this.getTextBlock();
        while (newIdx + 1 > blockWithSegment.getSize()) {
            if (mode.equals((Object)ContinueMode.ALWAYS_STOP)) {
                return null;
            }
            if (mode.equals((Object)ContinueMode.CONTINUOUS) && !blockWithSegment.isNextRelated()) {
                return null;
            }
            newIdx -= blockWithSegment.getSize();
            if ((blockWithSegment = blockWithSegment.getNext()) != null) continue;
            return null;
        }
        while (newIdx < 0) {
            if (mode.equals((Object)ContinueMode.ALWAYS_STOP)) {
                return null;
            }
            if (mode.equals((Object)ContinueMode.CONTINUOUS) && !blockWithSegment.isPrevRelated()) {
                return null;
            }
            if ((blockWithSegment = blockWithSegment.getPrev()) == null) {
                return null;
            }
            newIdx = blockWithSegment.getSize() + newIdx;
        }
        return blockWithSegment.getSegment(newIdx);
    }

    @Override
    public TEISegment getNext() throws Exception {
        return this.getNext(ContinueMode.ALWAYS_CONTINUE);
    }

    @Override
    public TEISegment getNext(ContinueMode mode) throws Exception {
        if (this.nextSegmentId == null) {
            return null;
        }
        TEISegment nextSegment = null;
        TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
        nextSegment = segmentationReader.getSegmentById(this.nextSegmentId);
        if (mode.equals((Object)ContinueMode.ALWAYS_STOP) ? !this.getTextBlock().equals(nextSegment.getTextBlock()) : mode.equals((Object)ContinueMode.CONTINUOUS) && !this.isRelatedToSuccessor(nextSegment)) {
            return null;
        }
        return nextSegment;
    }

    @Override
    public TEISegment getPrev() throws Exception {
        return this.getPrev(ContinueMode.ALWAYS_CONTINUE);
    }

    @Override
    public TEISegment getPrev(ContinueMode mode) throws Exception {
        if (this.prevSegmentId == null) {
            return null;
        }
        TEISegment prevSegment = null;
        TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
        prevSegment = segmentationReader.getSegmentById(this.prevSegmentId);
        if (mode.equals((Object)ContinueMode.ALWAYS_STOP) ? !this.getTextBlock().equals(prevSegment.getTextBlock()) : mode.equals((Object)ContinueMode.CONTINUOUS) && !prevSegment.isRelatedToSuccessor(this)) {
            return null;
        }
        return prevSegment;
    }

    @Override
    public int getPosition() {
        return this.segmentPosition;
    }

    @Override
    public TEISegmentGroup getSegmentGroup(Class<? extends SegmentGroup> type) {
        block13: {
            if (type.equals(SentenceSegmentGroup.class) || type.equals(TEISentenceSegmentGroup.class)) {
                try {
                    TEISegmentationReader reader = TEIReader.getTEISegmentationReader(this.corpusText);
                    return reader.getSentenceSegmentGroupById(this.sentenceId);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                if (type.equals(SenseSegmentGroup.class) || type.equals(TEISenseSegmentGroup.class)) {
                    TEISenseReader reader = TEIReader.getTEISenseReader(this.corpusText);
                    try {
                        return reader.getSenseSegmentGroupBySegmentId(this.segmentId);
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                        break block13;
                    }
                    catch (IOException e) {
                        System.out.println("Error reading file: " + this.getTextBlock().getCorpusText().getSensesFilePath());
                        return null;
                    }
                }
                if (type.equals(MorphoSegmentGroup.class) || type.equals(TEIMorphoSegmentGroup.class)) {
                    TEIMorphoReader reader = TEIReader.getTEIMorphoReader(this.corpusText);
                    try {
                        return reader.getMorphoSegmentGroupBySegmentId(this.segmentId);
                    }
                    catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        System.out.println("Error reading file: " + this.getTextBlock().getCorpusText().getSensesFilePath());
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public List<SegmentGroup> getSegmentGroups() {
        ArrayList<SegmentGroup> l = new ArrayList<SegmentGroup>();
        ArrayList<Class<TEISentenceSegmentGroup>> types = new ArrayList<Class<TEISentenceSegmentGroup>>();
        types.add(TEISenseSegmentGroup.class);
        types.add(TEIMorphoSegmentGroup.class);
        types.add(TEISentenceSegmentGroup.class);
        for (Class clazz : types) {
            SegmentGroup s = this.getSegmentGroup(clazz);
            if (s == null) continue;
            l.add(s);
        }
        return l;
    }

    @Override
    public TEITextBlock getTextBlock() {
        if (this.textBlock == null) {
            try {
                TEITextReader reader = TEIReader.getTEITextReader(this.corpusText);
                this.textBlock = reader.getTextBlockById(this.textBlockId);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.textBlock;
    }

    public String toString() {
        return "TEISegment [orth=" + this.getOrth() + ", indx=" + this.segmentPosition + ", seg.id=" + this.segmentId + ", nextSegment=" + this.nextSegmentId + ", prevSegment=" + this.prevSegmentId + ", sentence.id = " + this.sentenceId + ", textblockId=" + this.textBlockId + "]";
    }

    @Override
    public String getOrth() {
        if (this.orth == null) {
            try {
                TEITextReader textReader = TEIReader.getTEITextReader(this.corpusText);
                StringReader reader = textReader.getTextReaderForOrth();
                ((Reader)reader).reset();
                ((Reader)reader).skip(this.getTextBlock().filePosition + (long)this.startIdx);
                char[] buf = new char[this.endIdx - this.startIdx];
                int length = buf.length;
                int read_chars = ((Reader)reader).read(buf, 0, length);
                if (read_chars == length) {
                    return new String(buf, 0, length);
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.orth;
    }

    public boolean isRelatedToSuccessor(TEISegment successor) {
        return this.getPId().equals(successor.getPId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.corpusText == null ? 0 : this.corpusText.hashCode());
        result = 31 * result + (this.segmentId == null ? 0 : this.segmentId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEISegment other = (TEISegment)obj;
        if (this.corpusText == null ? other.corpusText != null : !this.corpusText.equals(other.corpusText)) {
            return false;
        }
        return !(this.segmentId == null ? other.segmentId != null : !this.segmentId.equals(other.segmentId));
    }

    @Override
    public String getId() {
        return this.segmentId;
    }

    public int getEndIdx() {
        return this.endIdx;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public int getSegmentPosition() {
        return this.segmentPosition;
    }

    public String getNextSegmentId() {
        return this.nextSegmentId;
    }

    public String getTextBlockId() {
        return this.textBlockId;
    }

    public String getSentenceId() {
        return this.sentenceId;
    }

    public String getPId() {
        return this.pId;
    }
}

