/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.SenseSegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISenseReader;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class TEISenseSegmentGroup
extends TEISegmentGroup
implements SenseSegmentGroup {
    private String senseId;

    public TEISenseSegmentGroup(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId, String senseId) {
        super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
        this.senseId = senseId;
    }

    @Override
    public TEISenseSegmentGroup getNext(ContinueMode mode) {
        if (this.nextGroupId == null) {
            return null;
        }
        TEISenseSegmentGroup segmentGroup = null;
        try {
            TEISenseReader senseReader = TEIReader.getTEISenseReader(this.corpusText);
            segmentGroup = senseReader.getSenseSegmentGroupById(this.nextGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEISenseSegmentGroup)this.getNeighbour(mode, this, segmentGroup, false);
    }

    @Override
    public TEISenseSegmentGroup getPrev(ContinueMode mode) {
        if (this.prevGroupId == null) {
            return null;
        }
        TEISenseSegmentGroup segmentGroup = null;
        try {
            TEISenseReader senseReader = TEIReader.getTEISenseReader(this.corpusText);
            segmentGroup = senseReader.getSenseSegmentGroupById(this.prevGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEISenseSegmentGroup)this.getNeighbour(mode, segmentGroup, this, true);
    }

    @Override
    public String getSenseId() {
        return this.senseId;
    }

    @Override
    public String toString() {
        return "TEISenseSegmentGroup [senseId=" + this.senseId + ", " + super.toString() + "]";
    }
}

