/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei;

import corpusapi.ContinueMode;
import corpusapi.SentenceSegmentGroup;
import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEISegment;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISegmentationReader;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class TEISentenceSegmentGroup
extends TEISegmentGroup
implements SentenceSegmentGroup {
    public TEISentenceSegmentGroup(String id, List<String> segmentIdList, String nextGroupId, String prevGroupId, TEICorpusText corpusText) {
        super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
    }

    @Override
    public TEISentenceSegmentGroup getNext(ContinueMode mode) {
        if (this.nextGroupId == null) {
            return null;
        }
        TEISentenceSegmentGroup nextSentence = null;
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            nextSentence = segmentationReader.getSentenceSegmentGroupById(this.nextGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEISentenceSegmentGroup)this.getNeighbour(mode, this, nextSentence, false);
    }

    @Override
    public TEISentenceSegmentGroup getPrev(ContinueMode mode) {
        if (this.prevGroupId == null) {
            return null;
        }
        TEISentenceSegmentGroup prevSentence = null;
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            prevSentence = segmentationReader.getSentenceSegmentGroupById(this.prevGroupId);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (TEISentenceSegmentGroup)this.getNeighbour(mode, prevSentence, this, true);
    }

    @Override
    public int[] getSegmentPositions() {
        int[] result = new int[this.segmentIdList.size()];
        try {
            TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
            TEISegment seg = segmentationReader.getSegmentById((String)this.segmentIdList.get(0));
            int start = seg.segmentPosition;
            int i = 0;
            while (i < this.segmentIdList.size()) {
                result[i] = start + i;
                ++i;
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String toString() {
        String sentence = "";
        for (String id : this.segmentIdList) {
            TEISegment s = null;
            try {
                TEISegmentationReader segmentationReader = TEIReader.getTEISegmentationReader(this.corpusText);
                s = segmentationReader.getSegmentById(id);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            sentence = String.valueOf(sentence) + s.getOrth() + " ";
        }
        return "TEISentence [" + sentence + "]";
    }
}

