/*
 * Decompiled with CFR 0.152.
 */
package corpusapi.tei.readers;

import corpusapi.tei.TEICorpusText;
import corpusapi.tei.TEIMorphLex;
import corpusapi.tei.TEIMorphoSegmentGroup;
import corpusapi.tei.TEISegmentGroup;
import corpusapi.tei.readers.TEIReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;

public class TEIMorphoReader
extends TEIReader {
    private HashMap<String, TEIMorphoSegmentGroup> morphoCacheSegmentId;
    protected TEISegmentGroup lastSegmentGroup1 = null;
    protected XMLStreamReader2 streamReader1;
    protected TEISegmentGroup lastSegmentGroup2 = null;
    protected String currentSegmentId2 = null;
    protected XMLStreamReader2 streamReader2;

    protected TEIMorphoReader(String fileName, TEICorpusText corpusText) {
        super(fileName, corpusText);
        if (this.cached) {
            this.morphoCacheSegmentId = this.cacheMaxItems == null ? new LinkedHashMap<String, TEIMorphoSegmentGroup>() : new LinkedHashMap<String, TEIMorphoSegmentGroup>(){
                private static final long serialVersionUID = -6839392540762832442L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, TEIMorphoSegmentGroup> eldest) {
                    return this.size() > TEIMorphoReader.this.cacheMaxItems;
                }
            };
        }
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.currentSegmentId2 = null;
        this.lastSegmentGroup1 = null;
        this.lastSegmentGroup2 = null;
        if (this.streamReader1 != null) {
            this.streamReader1.close();
            this.streamReader1 = null;
        }
        if (this.streamReader2 != null) {
            this.streamReader2.close();
            this.streamReader2 = null;
        }
        if (this.morphoCacheSegmentId != null) {
            this.morphoCacheSegmentId.clear();
            this.morphoCacheSegmentId = null;
        }
        super.close();
    }

    public TEIMorphoSegmentGroup createMorpho(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId) {
        if (this.cached) {
            TEIMorphoSegmentGroup morpho = null;
            morpho = this.morphoCacheSegmentId.get(id);
            if (morpho == null) {
                morpho = new TEIMorphoSegmentGroup(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
                this.morphoCacheSegmentId.put(segmentIdList.get(0), morpho);
            }
            return morpho;
        }
        return new TEIMorphoSegmentGroup(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
    }

    public TEIMorphoSegmentGroup getFirstMorphoSegmentGroup() throws XMLStreamException, IOException {
        XMLStreamReader2 sr = this.createStreamReader();
        ArrayList<String> segmentIdList = new ArrayList<String>();
        String segmentId = null;
        TEIMorphoSegmentGroup result = null;
        while (sr.hasNext()) {
            int event = sr.next();
            if (event != 1) continue;
            QName name = sr.getName();
            String local = name.getLocalPart();
            if ("fs".equals(local)) {
                this.getMorphoInfo(sr, result);
                continue;
            }
            if (!"seg".equals(local)) continue;
            String corresp = sr.getAttributeValue(null, "corresp");
            String id = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            if (result == null) {
                segmentId = corresp.split("#")[1];
                segmentIdList.add(segmentId);
                result = this.createMorpho(id, this.corpusText, segmentIdList, null, null);
                continue;
            }
            result.nextGroupId = id;
            break;
        }
        sr.close();
        return result;
    }

    protected boolean setStreamReaderForGroupId(String groupId) throws XMLStreamException, IOException {
        if (this.lastSegmentGroup1 == null || !groupId.equals(this.lastSegmentGroup1.nextGroupId)) {
            this.streamReader1 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEIMorphoSegmentGroup getMorphoSegmentGroupById(String morphoId) throws XMLStreamException, IOException {
        boolean oldStream = this.setStreamReaderForGroupId(morphoId);
        ArrayList<String> segmentIdList = new ArrayList<String>();
        String segmentId = null;
        TEIMorphoSegmentGroup result = null;
        String prevMorphoId = null;
        while (this.streamReader1.hasNext() || oldStream) {
            QName name;
            String local;
            int event = 0;
            if (!oldStream) {
                event = this.streamReader1.next();
            }
            if (event != 1 && !oldStream) continue;
            if (oldStream) {
                oldStream = false;
                prevMorphoId = this.lastSegmentGroup1.getId();
            }
            if ("fs".equals(local = (name = this.streamReader1.getName()).getLocalPart())) {
                this.getMorphoInfo(this.streamReader1, result);
                continue;
            }
            if (!"seg".equals(local)) continue;
            String corresp = this.streamReader1.getAttributeValue(null, "corresp");
            String id = this.streamReader1.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            if (id.equals(morphoId)) {
                segmentId = corresp.split("#")[1];
                segmentIdList.add(segmentId);
                result = this.createMorpho(morphoId, this.corpusText, segmentIdList, null, prevMorphoId);
                continue;
            }
            if (segmentId != null) {
                result.nextGroupId = id;
                break;
            }
            prevMorphoId = id;
            this.streamReader1.skipElement();
        }
        this.lastSegmentGroup1 = result;
        return result;
    }

    protected boolean setStreamReaderForSegmentId(String segmentId) throws XMLStreamException, IOException {
        if (this.lastSegmentGroup2 == null || !segmentId.equals(this.currentSegmentId2)) {
            this.streamReader2 = this.createStreamReader();
            return false;
        }
        return true;
    }

    public TEISegmentGroup getMorphoSegmentGroupBySegmentId(String segmentId) throws XMLStreamException, IOException {
        if (this.cached && this.morphoCacheSegmentId.containsKey(segmentId)) {
            return this.morphoCacheSegmentId.get(segmentId);
        }
        boolean oldStream = this.setStreamReaderForSegmentId(segmentId);
        this.currentSegmentId2 = null;
        ArrayList<String> segmentIdList = new ArrayList<String>();
        segmentIdList.add(segmentId);
        TEIMorphoSegmentGroup result = null;
        String prevMorphoId = null;
        while (this.streamReader2.hasNext() || oldStream) {
            QName name;
            String local;
            int event = 0;
            if (!oldStream) {
                event = this.streamReader2.next();
            }
            if (event != 1 && !oldStream) continue;
            if (oldStream) {
                oldStream = false;
                prevMorphoId = this.lastSegmentGroup2.getId();
            }
            if ("fs".equals(local = (name = this.streamReader2.getName()).getLocalPart())) {
                this.getMorphoInfo(this.streamReader2, result);
                continue;
            }
            if (!"seg".equals(local)) continue;
            String currentSegmentId = this.streamReader2.getAttributeValue(null, "corresp").split("#")[1];
            String id = this.streamReader2.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
            if (currentSegmentId.equals(segmentId)) {
                result = this.createMorpho(id, this.corpusText, segmentIdList, null, prevMorphoId);
                continue;
            }
            if (result != null) {
                result.nextGroupId = id;
                this.lastSegmentGroup2 = result;
                this.currentSegmentId2 = currentSegmentId;
                break;
            }
            prevMorphoId = id;
            this.streamReader2.skipElement();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getMorphoInfo(XMLStreamReader2 sr, TEIMorphoSegmentGroup result) throws XMLStreamException {
        String type = sr.getAttributeValue("", "type");
        if (type.equals("morph") && result != null) {
            ArrayList<TEIMorphLex> interps = new ArrayList<TEIMorphLex>();
            TEIMorphLex interpretation = null;
            State state = State.OUTSIDE;
            block22: while (sr.hasNext()) {
                String local;
                QName name;
                int event = sr.next();
                if (event == 1) {
                    name = sr.getName();
                    local = name.getLocalPart();
                    switch (state) {
                        case ORTH: {
                            if (!"string".equals(local)) continue block22;
                            result.orth = sr.getElementText();
                            state = State.OUTSIDE;
                            break;
                        }
                        case INTERPS: {
                            String fstype;
                            if (!"fs".equals(local) || !(fstype = sr.getAttributeValue("", "type")).equals("lex")) continue block22;
                            state = State.INTERPS_LEX;
                            String id = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                            interpretation = new TEIMorphLex(id);
                            break;
                        }
                        case INTERPS_LEX: {
                            if (!"f".equals(local)) continue block22;
                            String fname = sr.getAttributeValue("", "name");
                            if (fname.equals("base")) {
                                state = State.INTERPS_LEX_BASE;
                                break;
                            }
                            if (fname.equals("ctag")) {
                                state = State.INTERPS_LEX_CTAG;
                                break;
                            }
                            if (!fname.equals("msd")) continue block22;
                            state = State.INTERPS_LEX_MSD;
                            break;
                        }
                        case INTERPS_LEX_BASE: {
                            if (!"string".equals(local)) continue block22;
                            interpretation.base = sr.getElementText();
                            state = State.INTERPS_LEX;
                            break;
                        }
                        case INTERPS_LEX_CTAG: {
                            if (!"symbol".equals(local)) continue block22;
                            interpretation.ctag = sr.getAttributeValue("", "value");
                            state = State.INTERPS_LEX;
                            break;
                        }
                        case INTERPS_LEX_MSD: {
                            if (!"symbol".equals(local)) continue block22;
                            String id = sr.getAttributeValue("http://www.w3.org/XML/1998/namespace", "id");
                            String value = sr.getAttributeValue("", "value");
                            interpretation.msd.put(id, value);
                            break;
                        }
                        case DISAMB: {
                            if (!"fs".equals(local) || !sr.getAttributeValue("", "type").equals("tool_report")) continue block22;
                            state = State.DISAMB_TOOL_REPORT;
                            break;
                        }
                        case DISAMB_TOOL_REPORT: {
                            if (!"f".equals(local)) continue block22;
                            String fname = sr.getAttributeValue("", "name");
                            if (fname.equals("tool")) {
                                state = State.DISAMB_TOOL;
                                break;
                            }
                            if (fname.equals("date")) {
                                state = State.DISAMB_DATE;
                                break;
                            }
                            if (fname.equals("resp")) {
                                state = State.DISAMB_RESP;
                                break;
                            }
                            if (!fname.equals("choice")) continue block22;
                            String choice = sr.getAttributeValue("", "fVal");
                            result.disambChoice = choice.substring(1);
                            break;
                        }
                        case DISAMB_TOOL: {
                            if (!"string".equals(local)) continue block22;
                            result.disambTool = sr.getElementText();
                            state = State.DISAMB_TOOL_REPORT;
                            break;
                        }
                        case DISAMB_DATE: {
                            if (!"string".equals(local)) continue block22;
                            result.disambDate = sr.getElementText();
                            state = State.DISAMB_TOOL_REPORT;
                            break;
                        }
                        case DISAMB_RESP: {
                            if (!"string".equals(local)) continue block22;
                            result.disambResp = sr.getElementText();
                            state = State.DISAMB_TOOL_REPORT;
                            break;
                        }
                        case OUTSIDE: {
                            if (!"f".equals(local)) continue block22;
                            String fname = sr.getAttributeValue("", "name");
                            if (fname.equals("orth")) {
                                state = State.ORTH;
                                break;
                            }
                            if (fname.equals("interps")) {
                                state = State.INTERPS;
                                break;
                            }
                            if (!fname.equals("disamb")) continue block22;
                            state = State.DISAMB;
                            break;
                        }
                    }
                    continue;
                }
                if (event != 2) continue;
                name = sr.getName();
                local = name.getLocalPart();
                switch (state) {
                    case OUTSIDE: {
                        if (!local.equals("fs")) break;
                        break block22;
                    }
                    case INTERPS: {
                        if (!local.equals("f")) break;
                        state = State.OUTSIDE;
                        break;
                    }
                    case INTERPS_LEX: {
                        if (!local.equals("fs")) break;
                        interps.add(interpretation);
                        state = State.INTERPS;
                        break;
                    }
                    case INTERPS_LEX_MSD: {
                        if (!local.equals("f")) break;
                        state = State.INTERPS_LEX;
                        break;
                    }
                    case DISAMB: {
                        if (!local.equals("f")) break;
                        state = State.OUTSIDE;
                        break;
                    }
                    case DISAMB_TOOL_REPORT: {
                        if (!local.equals("fs")) break;
                        state = State.DISAMB;
                    }
                }
            }
            result.setInterps(interps);
        }
    }

    private static enum State {
        OUTSIDE,
        ORTH,
        INTERPS,
        INTERPS_LEX,
        INTERPS_LEX_BASE,
        INTERPS_LEX_CTAG,
        INTERPS_LEX_MSD,
        DISAMB,
        DISAMB_TOOL_REPORT,
        DISAMB_TOOL,
        DISAMB_DATE,
        DISAMB_RESP;

    }
}

