package corpusapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CorpusTools {

	/**
	 * mapa corpusID->statystyka korpusu
	 */
	private HashMap<String,SenseStatistics> statisticsMap = new HashMap<String,SenseStatistics>(); 
	
	/**
	 * zwraca następne wystapienie danego sensu słowa wieloznacznego w korpusie
	 * @param corpus korpus
	 * @param sense sens jak mi zostać wyszukany
	 * @return następne wystąpienie danego sensu słowa wieloznacznego w korpusie
	 */
	public abstract SenseSegmentGroup getNextSenseInstance(Corpus corpus, String sense);
	
	/**
	 * zwraca nastepne wystapienie dowolnego slowa wieloznacznego w korpusie
	 * @param corpus
	 * @return nastepne wystapienie dowolnego slowa wieloznacznego w korpusie
	 */
	public abstract SenseSegmentGroup getNextSenseEntryInstance(Corpus corpus);
	
	/**
	 * 
	 * zwraca następne wystapienie danego słowa wieloznacznego w korpusie
	 * @param corpus korpus
	 * @param senseEntry słowo wieloznaczne do wyszukania
	 * @return następny wystąpienie danego słowa wieloznacznego w korpusie
	 */
	public abstract SenseSegmentGroup getNextSenseEntryInstance(Corpus corpus, String senseEntry);
	
	/**
	 * zwraca statystyki wystąpień danego słowa wieloznacznego w korpusie (wraz z sensami tego słowa wieloznacznego)
	 * @param corpus korpus
	 * @param senseEntry słowo wieloznaczne
	 * @return statystyki wystąpień danego słowa wieloznacznego w korpusie (wraz z sensami tego słowa wieloznacznego)
	 */
	public SenseStatistics getSenseStatistics(Corpus corpus, String senseEntry) {
		if (!statisticsMap.containsKey(corpus.getId()) || !statisticsMap.get(corpus.getId()).availableSenseEntries().contains(senseEntry)) {//nie bylo w ogole statystyki lub nie zawierala danego slowa
			//nadpisalem equal i hashCode zeby to contains dzialalo
			//stworz statysytke dla tego slowa i dodaj ja
			
			SenseStatistics s = makeSenseStatistics(corpus, new HashSet<String>(Arrays.asList(new String[]{senseEntry}))); //nie kompletna
			//dodaj ja do mapy
			statisticsMap.put(corpus.getId(), s);
			return statisticsMap.get(corpus.getId());
		} else { //czyli: if (statisticsMap.get(corpus.getId()).isComplete() | statisticsMap.get(corpus.getId()).availableSenseEntries().contains(senseEntry)) {//jezeli mam kompletna statystyke dla corpusu lub taka ktora zawiera dany sens					
			return statisticsMap.get(corpus.getId()).projectionToSenseEntries(Arrays.asList(new String[]{senseEntry}));
		}		
	}
	
	/**
	 * zwraca statystyki wystąpień wszystkich słów wieloznacznych wraz z ich sensami w zadanym korpusie
	 * @param corpus korpus
	 * @return statystyki wystąpień wszystkich słów wieloznacznych wraz z ich sensami w zadanym korpusie
	 */
	public SenseStatistics getSenseStatistics(Corpus corpus) {
		if (!statisticsMap.containsKey(corpus.getId()) || !statisticsMap.get(corpus.getId()).isComplete()) {//jezeli albo nie ma statystyki wcale, albo sa w niej jedynie poszczegolne slowa
			//stworz statysytke dla calego korpusu, dodaj ja
			SenseStatistics s = makeSenseStatistics(corpus, null);
			//dodaj ja do mapy
			statisticsMap.put(corpus.getId(), s);			
		} 
		//tutaj mam kompletna statystyke dla corpusu
		return statisticsMap.get(corpus.getId());
	}
	
	/**
	 * pretty print 
	 * @param corpus
	 * @param interp
	 * @return
	 */
	//TODO przeargumentowac, co to mialo robic dokladnie???
	public abstract String format(Corpus corpus, List<List<? extends SegmentGroup>> interp);
	
	/**
	 * podklasy implementuja te metode. metoda jest uzywana przez getSenseStatistics(xxx) i zawiera jej zasadniczą część.
	 * @param corpus
	 * @param senseEntries lista sensow, jesli null, to robimy dla wszystkich
	 * @return
	 */
	protected abstract SenseStatistics makeSenseStatistics(Corpus corpus, Set<String> senseEntries);
}
