package corpusapi;

import java.util.List;
import java.util.Set;

/**
 * Statystyka wystąpień sensów w korpusie
 * @author rm
 *
 */
public interface SenseStatistics {
	
	//dodawanie statstyk?
	
	
	/**
	 * id korpusu dla którego została statystyka policzona  
	 * @return id korpusu dla którego została statystyka policzona
	 */
	public String corpusId();
	
	/**
	 * czy jest to statystyka dla wszystkich słów wieloznacznych korpusu
	 * @return czy jest to statystyka dla wszystkich słów wieloznacznych korpusu
	 */
	public boolean isComplete();  
	
	/**
	 * zwraca zbiór słów wieloznacznych uwzględnionych w statystyce
	 */
	public Set<String> availableSenseEntries();
	
	/**
	 * przycina statystyke tak by uwzgledniala jedynie sensy z listy
	 * @param senseEntries
	 * @return przycieta statystyka do sensow z listy, zwraca null, jezeli chocby jednego sensu nie moze dac
	 */
	public SenseStatistics projectionToSenseEntries(List<String> senseEntries);
	
	public void addOccurence(String senseEntry, String sense); 
	
	
	/**
	 * zwraca ilość wystąpień danego sensu w korpusie
	 * @param sense dany sens
	 * @return ilość wystąpień danego sensu w korpusie 
	 * lub -1, jeśli dla danego sensu nie ma statystyk 
	 */
	public int getSenseCount(String sense);
	
	/**
	 * zwraca ilość wystąpień danego słowa wieloznacznego (SenseEntry) w korpusie
	 * @param senseEntry słowo wieloznaczne
	 * @return ilość wystąpień danego słowa wieloznacznego w korpusie 
	 * lub -1, jeśli dla danego słowa wieloznacznego nie ma statystyk
	 * 
	 */
	public int getSenseEntryCount(String senseEntry);
	
	
}
