package corpusapi.tei;

import java.io.IOException;
import java.util.List;

import javax.xml.stream.XMLStreamException;

import corpusapi.ContinueMode;
import corpusapi.SenseSegmentGroup;
import corpusapi.tei.readers.TEIReader;
import corpusapi.tei.readers.TEISenseReader;

public class TEISenseSegmentGroup extends TEISegmentGroup implements
		SenseSegmentGroup {

	private String senseId;

	public TEISenseSegmentGroup(String id, TEICorpusText corpusText, List<String> segmentIdList, String nextGroupId, String prevGroupId, String senseId) {
		super(id, corpusText, segmentIdList, nextGroupId, prevGroupId);
		this.senseId = senseId;
	}

	@Override
	public TEISenseSegmentGroup getNext(ContinueMode mode) {
		if (nextGroupId == null) return null;
		
		TEISenseSegmentGroup segmentGroup = null;
		try {
			TEISenseReader senseReader = TEIReader.getTEISenseReader(corpusText);
			segmentGroup = senseReader.getSenseSegmentGroupById(nextGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
		return (TEISenseSegmentGroup) getNeighbour(mode, this, segmentGroup, false);
	}

	@Override
	public TEISenseSegmentGroup getPrev(ContinueMode mode) {
		if (prevGroupId == null) return null;
		
		TEISenseSegmentGroup segmentGroup = null;
		try {
			TEISenseReader senseReader = TEIReader.getTEISenseReader(corpusText);
			segmentGroup = senseReader.getSenseSegmentGroupById(prevGroupId);
		} catch (XMLStreamException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return (TEISenseSegmentGroup) getNeighbour(mode, segmentGroup, this, true);
	}

	@Override
	public String getSenseId() {
		return senseId;
	}

	@Override
	public String toString() {
		return "TEISenseSegmentGroup [senseId=" + senseId + ", "
				+ super.toString() + "]";
	}
}
