 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

Uzytkownik.find( :first ) # żeby utworzyć Natrorów, gdyby ich nie było.


class AnotacjaController < ApplicationController

  include ApplicationHelper

  layout "admin"

  GOSCINNE = # mogą oglądać wszyscy
    [:ogladactwo, :ustal_akapit, :anotuj, :pokaz_transze,
     :wyszukaj_akapity,
     :pokaz_quasi_transze, :ukryj_quasi_transze, :ukryj_wszystkie_quasi_transze,
     :quasi_transza_brutal,
     :sense_long_toggle,
     :sense_inventory,
     :sense_long_hide_all,
     :zweryf,
     :wsze_transze_otwarte_toggle,
     :wsze_transze_BW_toggle
    ]
  
  ANNOTABLES_ET_AUDITABLES = [ :komentarz_dodaj, :komentarz_anulowany,
                               :komentarz_zatwierdz,
                               :nowa_segmentacja_ukryj, :nowa_segmentacja_pokaz,
                               :nowa_prośba_segmentacyjna
                               ]

  ANNOTER_ONLY = [:pobierz_transze, :prosba_o_odebranie_transzy, 
                  :prosba_anulowana, :prosbe_o_odebranie_zapisz,   
                  :odebrania_transz_ukryj,   :odebrania_transz_pokaz,
                  :nie_chce_transzy, :ramka_prosba_o_wzorzec]

WSZEWID_ONLY = [:spełnij_prośbę, :odrzuć_prośbę ]




  before_filter :authorize
  before_filter :przetwarzam_nie_przeszkadzac
  after_filter :skonczylam_przetwarzac
  
  before_filter :update_activity_time, :except => :session_expiry

  before_filter :check_annotant, :except => GOSCINNE + ANNOTABLES_ET_AUDITABLES + 
    ANNOTER_ONLY + WSZEWID_ONLY
  # check_annotant patrzy czy (anotator lub zarządca)
  before_filter :check_voyeur, :only => GOSCINNE
  before_filter :check_annotant_ou_auditeur, :only => ANNOTABLES_ET_AUDITABLES
  before_filter :check_anotator, :only => ANNOTER_ONLY
  before_filter :check_wszewid, :only => WSZEWID_ONLY

  # check_annotant_ou_auditeur patrzy czy (anotator lub zarządca lub audytor)
  ##  before_filter :check_zarzadca, :only => ZARZADCA_ONLY
  #  before_filter :check_idid

  EDYTOWALNY_EXCEPTIONS = [
                           :lista_transz,  :transze_zamkniete_pokaz,  :transze_zamkniete_ukryj, 
                           :dyzamb_anulowana,
                           :sensowanie_anulowane, 
                           :fraza_wybor_anulowany,
                           :segmentacja_anulowana,
                           :poziomuj
                          ] + 
    GOSCINNE + ANNOTABLES_ET_AUDITABLES + 
    ANNOTER_ONLY + WSZEWID_ONLY
  before_filter :check_edytowalny, :except => EDYTOWALNY_EXCEPTIONS
  
  before_filter :check_drag_queen, :only => :pobierz_transze # reszta sprawdza się w~#{check_edytowalny}.


  def pobierz_transze
    @anotator = Uzytkownik.find( session[:uzid] )
    if r_anotator?
      if @anotator.transze_otwarte( :refresh ).size < Transza::MAX_TRANSZ
        transze_zabronione = @anotator.odebrania_odebrane.collect { |ode| 
          ode.dotyczy_id # to jest #{transza_id}, tylko w~powiązaniu polimorficznym.
        } +  @anotator.transza.collect { 
          |tra| traid=tra.transza_id;   ((1+(traid-1)/4*4)..((traid+3)/4*4)).to_a}.flatten
        tr_przypisywana = Transza.find( :first,  
                                            :conditions => 
                                            " transza_id = ( select min(transza_id) as minid" + 
                                            " from transza ta where ta.transza_id not in " + 
                                            " (#{transze_zabronione.join(', ')}) " + 
                                            " and uzytkownik_id is null ) ")
        if (not tr_przypisywana) 
          flash[:notice]="Brak transz do przypisania"
        else
          ##        flash[:notice]="Pierwsza dopuszczalna to #{pierwsza_tr_dopuszczalna}"
          tr_przypisywana.uzytkownik_id=@anotator.uzytkownik_id
          tr_przypisywana.save!
        end
      end
      render :partial => 'lista_transz', :object => @anotator.transze_otwarte( :refresh )
      ##      redirect_to(:action => :lista_transz)
    else # to nie anotator
      flash[:notice] = "Próbowałaś/eś czynności dostępnej tylko anotatorom!"
      redirect_to( :controller => :logowanie, :action => :wylogowanie )
    end
  end # of #pobierz_transze


  def lista_transz
    session[:anotator] = nil if r_anotator?
    @anotator = Uzytkownik.find(session[:uzid])
    @sa_transze_zamkniete = ( @anotator.transze_zamkniete.size > 0 )
    @odebrania_transz = @anotator.odebrania_transz
  end

  # Na życzenie Adama Przepiórkowskiego 
  # w jego wersji ukrywamy prośbę o odebranie transzy na osobnej stronce.
  def nie_chce_transzy
    session[:anotator] = nil if r_anotator?
    @anotator = Uzytkownik.find(session[:uzid])
    @odebrania_transz = @anotator.odebrania_transz
  end


  def transze_zamkniete_pokaz
    session[:transze_zamkniete_pokaz] = true
    redirect_to :action => :lista_transz
  end

  def transze_zamkniete_ukryj
    session[:transze_zamkniete_pokaz] = false
    redirect_to :action => :lista_transz
  end


  def pokaz_transze
    conditiones = { :transza_id => ( params[:id] || session[:transza] ) }
    # anotatorowi pokażemy transzę tylko, jeśli jest jego
    if r_anotator?
      conditiones[:uzytkownik_id] = session[:uzid]
    end
    @transza=Transza.find( :first, :conditions => conditiones)
    if @transza
      @akapity=(unless r_gosc? : @transza.akapity_transzy_rozbiezne(:refresh) +
               @transza.akapity_transzy_niezatwierdzone(:refresh) +
               @transza.akapity_transzy_zatwierdzone(:refresh)
               else [] end +
               @transza.akapity_transzy_zamkniete(:refresh)).collect {|akat|
        [akat.akapit, akat] }
      session[:transza]=@transza.transza_id
      zniluj_akapitowe( :weryfikacja )
      session[:anotator] = @transza.uzytkownik_id unless r_anotator?
      session[:anotator] = nil if r_anotator?
    else # gdy  transza is nil
      if r_anotator?
        flash[:notice] = "Prawdopodobnie nie masz uprawnień do oglądania wybranego akapitu: nie znalazłam transzy #{params[:id]} wśród Twoich."
        redirect_to( :action => :lista_transz )
      else  redirect_to( :action => :ogladactwo )
      end
    end

  end # of #{pokaz_transze}.


  def wyszukaj_akapity
    zp = 'zawęź poprzednie'
    nowe_zapytanie=true
    zawez_poprzednie=false
    sa_kryteria = false
    if request.post? and params[:szukaj]
      #jeśli to post, to spodziewamy się danych z formularza (parametry zapytania)
      klucze = [:szukaj_lemat, :szukaj_sens, :szukaj_klasa]
      klucze.each{ |klucz|
        pk = params[:szukaj][klucz]
        pk = nil if pk == ''
        sa_kryteria = true if pk
        session[klucz] = pk}
      if session[:szukaj_commit] == zp and params[:commit] != zp
          nowe_zapytanie = true 
      end
      zawez_poprzednie = true if params[:commit] == zp
      session[:szukaj_commit] = params[:commit]
    end# of #{request.post?} etc.
    if sa_kryteria
      if nowe_zapytanie 
        akats = AkapitTranszy.wyszukaj(
                                     session[:szukaj_lemat], 
                                     session[:szukaj_sens],
                                     session[:szukaj_klasa])
      end

      if akats and akats[0]
        sakat = session[:szukaj_akapity_transzy]
        akats_poprz = sakat  if zawez_poprzednie and sakat
        session[:szukaj_akapity_transzy] = akats.collect{ |akat| akat.akapit_transzy_id }
        session[:szukaj_akapity_transzy] &= akats_poprz if zawez_poprzednie and akats_poprz
      elsif akats == [] : session[:szukaj_akapity_transzy] = nil
      end
      
      if session[:szukaj_akapity_transzy] and ((not akats) or zawez_poprzednie)
        akats = AkapitTranszy.find( session[:szukaj_akapity_transzy] )
      end
      
      @akapity = akats.collect{|akat| [akat.akapit, akat] } if akats
      zniluj_akapitowe( :weryfikacja )
    else
      flash[:notice] = "Podaj choć jedno kryterium wyszukiwania!"
    end
  end # of #{wyszukaj_akapity}.



  def ustal_akapit # wołany z widoku \file{pokaz_transze.rhtml}, \file{wyszukaj_akapity.rhtlm}, i~\file{ogladactwo.rhtml}.
    zniluj_akapitowe( :weryfikacja )
    ##    logger.info '@@@@ params: ' + params.inspect
    session[ :akapit ] = params[ :akapit ].to_i if params[ :akapit ]

    if params[ :goto ] and params[ :goto ][ :akapit ]
      blubra = params[ :goto ][ :akapit ].tr('^0123456789', '').to_i
      session[ :akapit ] = blubra if blubra > 0
    # if we get the akapit id from a form in ogladactwo view, we trim it of anything non decimal.
    end
    
    session[ :anotator ] = params[ :anotator ].to_i if params[ :anotator ]

    session[ :akat ] = params[ :akat ].to_i if params[ :akat ]

    if params[ :goto ] and params[ :goto ][ :akat ]
      blubra = params[ :goto ][ :akat ].tr('^0123456789', '').to_i 
      session[ :akat ] = blubra if blubra > 0
    end
    
    if session[ :akat ]
      session[ :transza ] =
        AkapitTranszy.find( session[ :akat ] ).transza_id

    elsif session[ :anotator ] and session[ :akapit ]
      akat = AkapitTranszy.znajdz(session[ :akapit ], session[ :anotator ])
      session[ :akat ] = akat.id
      session[ :transza ] = akat.transza_id
      
      # poniższy elsif dołożyłem 2010/4/9
    elsif Rola.wszewid?( session[ :rola_id ] ) and session[ :akapit ]
      akat = AkapitTranszy.find_by_akapit_id( session[ :akapit ] )
      session[ :akat ] = akat.id
      session[ :transza ] = akat.transza_id
    else  
      raise "##{annotation_controller.capitalize}Controller.ustal_akapit: parameters don't suffice to determine akapit_transzy."
    end

    ##    logger.info "@@@@ session[ :jak_anotator ]=#{session[ :jak_anotator ].inspect}"
    redirect_to :action => :anotuj, :akat => session[ :akat ], :anchor => :primafalsa
  end # of #{ustal_akapit}



  def anotuj
    ##                               logger.info "@@@@ aca w. 215. #{Time.now}"
    ##    logger.info "@@@@@@ session[:weryfikacja] = #{session[:weryfikacja].inspect}"
  
    set_uzid
    @komentarz_do_odrzucenia = true  if params[:kom_odrzuc] 
    inicjuj_akat_i_poziomy
    zrob_ramke_dup # tam jest if
    ##    @transza = ( session[ :transza ] && Transza.find( session[:transza] ) ) # poprawione na koniunkcję 2009/8/22.
    # sprawdź, czy akapit z jakiejś jego transzy

    logger.info "@@@@ #316 ak.t. #{@akapit_transzy.id} — statuski: #{@akapit_transzy.statuski}"
    @akapit_transzy.autozatwierdź_word_senses if @akapit_transzy

    logger.info "@@@@ #316 ak.t. #{@akapit_transzy.id} — statuski: #{@akapit_transzy.statuski}"
    
    if  (@transza or r_wszewid? # wszechwidzący nie zawsze pracują w~transzach.
         ) and @akapit_transzy and
        (  @akapit_transzy.uzytkownik_id == @anotid or
           @akapit_transzy.get_uzid == @anotid or r_wszewid? # wszechwidzący może chcieć oglądać akapit jeszcze nie przydzielony, jeśli jest on bliźniaczym jakiegoś przydzielonego.
           )
      @akapit = @akapit_transzy.akapit
      session[ :status ] = @akapit_transzy.status
      ##                               logger.info "@@@@ aca w. 229. #{Time.now}"
      if session[ :weryfikacja ] and session[:weryfikacja][:werdykt] == -1
        @weryfikacja = session[:weryfikacja]
        # w~tym wypadku mamy #{primafalsa}, do której będziemy kotwiczyć, więc nie kotwiczymy sensu.
      else  
        verifiables = @poziomy.verifiables( @akapit_transzy )
        ##        logger.info "@@@ verifiables: " + verifiables.inspect
        if verifiables[ 0 ]
          # weryfikujemy, i~to do końca, żeby ewentualnie mieć pełną listę niezgodności
          @weryfikacja = @akapit_transzy.weryfikacja(
                                                     :dokonca => true,
                                                     :rola_id => session[:rola_id],
                                                     :poziomy => verifiables,
                                                     :właśnie_zatwierdzamy => false,
                                                     :session_uzid => session[ :uzid ]
                                                     )
          session[:weryfikacja] = @weryfikacja
        end # of #{if verifiables}

        ##        logger.info "@@@@ " + @weryfikacja.inspect
      end # of #{if session[:weryfikacja]} or not

      # następnych 6 wierszy było dotąd powyżej powyższego #{end}, 
      # co powodowało \#252
      @werdykt = ( @weryfikacja ||= {:werdykt => 0} )[:werdykt]
      if ( not @weryfikacja[ :primafalsa ]) and 
          @poziomy.word_senses?
        # jeśli mamy wyświetlać do anotacji sensy słów, to ustawimy kotwiczkę na pierwszy sens
        @akapit_transzy.akapit.set_primafalsa( 
                                              @weryfikacja, @akapit_transzy.primus_sensibilis )
      end # of if not prima falsa.

    logger.info "@@@@ #316 ak.t. #{@akapit_transzy.id} — statuski: #{@akapit_transzy.statuski}"


      # pierwotnie @bluzid był ustawiany tylko gdy werdykt ==-1, 
      # ale może go potrzebować zarządca do zmiany strony
      @bluzid = @akat_bliźniak.get_uzid( session[ :uzid ] )
      @bliakath = @akat_bliźniak.akat_hash
      @statuski = @akapit_transzy.statuski
      @do_poprawki = (  Rola.anotator?( session[:rola_id] ) and
                         ( @statuski.include?( AkapitTranszy::STATI[ :do_poprawki] ) or
                           @statuski.include?( AkapitTranszy::STATI[ :po_poprawce] ) )
                         )
      @pokaż_bliź = ( @akapit_transzy.ma_Status?( :>=, :do_osądzenia ) or
                      Rola.wszewid?( session[:rola_id] ) )
    else # nie ma transzy lub akapit_transzy lub @transza_uzytkownik_id <> ...
      flash[:notice] = "Niewłaściwa deskrypcja akapitu: "+
        "akat_id: #{session[ :akat ]} akapit_id: #{session[ :akapit ]}; anotator: #{session[ :anotator ]}; transza_id:#{session[ :transza ]}."
      # Jeśli ta notycja się wyświetli, to znaczy, że transza była dobrze, 
      # bo gdyby źle, to by się pojawiła notycja z~przekierowania nie znalezienia transzy.
      redirect_to( :action => :pokaz_transze, :id => session[:transza] )
    end
    ##    logger.info "@@@@ aca w. 265. #{Time.now}"
  end # of #{anotuj}.


  def pokaz_interpretacje
      render :partial => 'token_wszi', :object => [akapit_transzy, Token.find(params[:id])]
  end


  def nowa_dyzambiguacja
    set_uzid
    intid=params[:interpretacja_anot]
    if intid
      intid=intid[:interpretacja_id].to_i
      tok = Interpretacja.find( intid ).token
      @tokid = tok.id
      @interpretacja_anot=InterpretacjaAnot.find(
                                                 :first,
                                                 :conditions => {
                                                   :akapit_transzy_id => akapit_transzy.id,
                                                   :token_id => @tokid
                                                 })
      @interpretacja_anot ||= InterpretacjaAnot.new
      @interpretacja_anot.interpretacja_id = intid
      @interpretacja_anot.uzytkownik_id=@uzid
      @interpretacja_anot.akapit_transzy_id = akapit_transzy.id
      @interpretacja_anot.token_id = @tokid
      InterpretacjaAnot.transaction do
        @interpretacja_anot.save!
        if DlaEli.nk
          obniz_status( akapit_transzy, :morphosyntactic)
          tok.odsmiec_interpretacje 
        else
          obniz_status( akapit_transzy )
        end
      end
    else# not intid
      @tokid=params[:id].to_i
    end
##    redirect_to :action => 'anotuj' # for debug
    raiseifzero( @tokid, "nowa_dyzambiguacja" )
    if ( szd = session[ :zmieniaj_dyzamb ] ) and szd[ @tokid ]
      szd[ @tokid ] = nil
    end
    odswiez_token(@tokid)
    tok.zambiguuj
  end # of #{nowa_dyzambiguacja}.



  def dyzamb_anulowana
# to by mogło iść do dyzamb_anulowana.rjs, ale nie chce mi się mnożyć plików
    @tokid=params[:id].to_i
    szd = session[ :zmieniaj_dyzamb ]
    if szd and szd[ @tokid ]
      szd[ @tokid ] = nil 
    end
    raiseifzero( @tokid, "dyzamb_anulowana" )
    odswiez_token(@tokid)
  end


  def pokaz_sensy
    set_uzid
    akat_hash
    tok187 = Token.find(params[:id])
    @the_sens = tok187.the_sens( @akat_hash )
    render :partial => 'token_wybs', :object => 
      [ @akapit_transzy, 
        tok187, 
        tok187.do_sensu?( @akat_hash ) ]
  end # of #{pokaz_sensy}


  def wybor_sensu # wołana z \file{_token_wybs.rhtml}
    set_uzid
    akat_hash # inicjuje #{@akat_hash}, jeśli jej nie było
    obniz_status( akapit_transzy, :word_senses )
    sensid = params[ :the_sens ]
    tokid = params[ :id ].to_i
    disaid = params[ :disamb_id ].to_i
    raiseifzero( tokid, "wybor_sensu")

    if sensid and sensid[:sensy_id] and 
        sensid[:sensy_id].to_i != 0
      # drugi człon koniunkcji na wypadek, 
      #gdyby nic nie wybrano, ale to i tak mało
      sensid=sensid[ :sensy_id ].to_i

      @sens_anot=SensAnot.znajdz( tokid, @akat_hash )

      @sens_anot ||= SensAnot.new

      @sens_anot.sensy_id = sensid
      @sens_anot.uzytkownik_id = @uzid
      @sens_anot.akapit_transzy_id = akapit_transzy.id
      @sens_anot.interpretacja_id = disaid
      @sens_anot.token_id = tokid
      @sens_anot.automatycznie = false
      sl187 = @sens_anot.sensy( :refresh )
      if sl187
        @sens_anot.save!
      else
        @sens_anot = nil
      end
    end  # of  sensid and sensid[:sensy_id] and sensid[:sensy_id].to_i != 0
    odswiez_token(tokid, :tylko_sens)
  end # of #{wybor_sensu}


  def sensowanie_anulowane
    t187 = Token.find( params[:id] )
    ##    @the_sens = t187.the_sens( akat_hash )
    ##    render :partial => 'token_sens', :object =>  [t187, @akapit_transzy, true]
    odswiez_token( t187.id, :tylko_sens )
  end


  def   sense_long_toggle
    akapit_transzy
    eltid192 = params[ :id ]
    ids192 = eltid192.split( '_' )[1, 3].collect { |i192| i192.to_i }

    session[ :show_long_sense ] ||= []
    if session[ :show_long_sense ].include?( eltid192 )
      session[ :show_long_sense ].delete( eltid192 )
    else
      session[ :show_long_sense ] <<  eltid192
    end

    arr192 =  [ ids192[0], ids192[1], Sensy.find( ids192[2] ) ] 

    render :update do |page| 
      page.replace eltid192, 
      :partial => 'sens_long', 
      :object => arr192

      page.replace eltid192 + '-link',
      :partial => 'sens_pelny_opis_link',
      :object => arr192
    end
  end # of #{sense_long_toggle}


  def sense_long_hide_all
    # używana w~widoku sense_inventory

    session[ :show_long_sense ] ||= []
    session[ :show_long_sense ].delete_if {|eltid192|
      eltid192 =~ /666_6666\d\d\d\d/ }
    redirect_to :action => :sense_inventory
  end


  def zatwierdz_akapit
    # to tylko wykonuje zatwierdzenie akapitu przez Anotatora. Weryfikacji i~ewentualnego dokonania zmian w~rekordach dokona #{zweryfikuj_akapit} i~jej metody #{commit_…}.
    akat = akapit_transzy
    if session[:zdziw_sie_akapitowi] : zdziw_sie = nil
    else zdziw_sie = :zdziw_sie
    end
    
    poziomy = params[:poziom].split('/').collect{ |poz| poz.intern }
    # sprawdź każdy poziom anotacji, którego dotyczy żądanie zatwierdzenia
    poziomy.freeze

    niezatw_notice = ''

    # superanotatorowi sprawdzimy, czy rozstrzygnął wszystkie rozbieżności:
    if r_zarzadca? and w = session[ :weryfikacja ]
        rozb = 
          poziomy.collect {|poz|
          if w[poz] and w[poz][0] # to mamy tablicę id-ów tokenów, oby pustą
            "na poziomie #{PoziomyAnotacji.gen(poz)} w tokenie/nach " + 
              w[poz].collect{ |id| "»" + Token.find( id).orth + "«" }.join(', ')
          end
        }.compact.join('; ')
        if rozb != ''
          niezatw_notice = "Nie zatwierdzam: nie rozstrzygnąłeś rozbieżności #{rozb}!"
        end
    end # of if zarządca (superanotator)

    poziomy_niegotowe = []
    
    poziomy.each{ |poz|
      self.send( "zatw_#{poz}", zdziw_sie, poziomy_niegotowe, niezatw_notice )
    }
    
    unless niezatw_notice[0]  # #niezatw_notice jest \<stringiem>, pytamy tutaj, czy niepustym.
      logger.info "poziomy: #{poziomy.inspect}"
      zweryfikuj_akapit(akat, :zatwierdz, poziomy)

    else 
      session[:zdziw_sie_akapitowi] = :dziwie_sie unless /^nie/i =~ niezatw_notice
      poziomy_niegotowe.each{ |poz|
        obniz_status( akat, poz )
      }
      # ale mogą być poziomy gotowe, i te zweryfikujemy (błąd \#157 2009/7/3)
      poziomy_gotowe = poziomy - poziomy_niegotowe
      if poziomy_gotowe[ 0 ]
        zweryfikuj_akapit(akat, :zatwierdz, poziomy_gotowe, niezatw_notice ) 
      else
        flash[:notice]= niezatw_notice
        redirect_to :action => :anotuj, :akat => akat, :anchor => :notizia
      end
    end # of # {unless niezatw_notice}.
    ##    logger.info "@@@@@@ session[:weryfikacja] = #{session[:weryfikacja].inspect}"
  end # of #{zatwierdz_akapit}.
  
  # tu następują metody zatwierdzenia na poszczególnych poziomach
  
    
    PoziomyAnotacji.poziomy_x.each{ |poz| 
  eval "  def zatw_#{poz}( zdziw_sie, poziomy_niegotowe, niezatw_notice )
    logger.info \"@@@@ zatw_#{poz} \"
    akat = akapit_transzy
    #{poz}_niegot =  akat.#{poz}_niegot?( session[ :rola_id ], zdziw_sie )
    if #{poz}_niegot[ 0 ] 
      niezatw_notice << #{poz}_niegot
      poziomy_niegotowe << :#{poz}
    else
      podnies_status(akat, :#{poz} )
      logger.info \"@@@@ podnies_status in zatw_#{poz}\"
      AkapitTranszy.transaction do
        akat.odrzucony=false
        akat.save!
      end # of transaction
    end
  end
  "    # pytamy w~tym warunku, czy #{niezatw_notice}, które jest # {Stringiem}, ma pierwszy znak — czyli czy jest niepuste.
    # of #{transaction}.
    # of #{if segm_niegot[0]}.
    # of #{zatw_\<poz>}.
  }

# powyższy kod tworzy nam dla każdego poziomu anotacji metodę #{zatw_\<poziom>}, mającą argumenty
# #{( zdziw_sie, poziomy_niegotowe, niezatw_notice )}.
    # # poziomy_niegotowe to \<array>, do której dopiszemy ten poziom, jeśli nie jest gotowy,
    # # niezatw_notice to budowany w~zatwierdzałkach kolejnych poziomów komunikat o niezatwierdzeniu
    # powyższe dwa parametry będziemy modyfikować, czyli obsługiwać jako przekazane przez zmienną (wszystko w~Rubym jest przekazywane przez zmienną, bo wszystko jest referencją do obiektu)
    # #zdziw_sie to symbol lub #nil — mówi, czy mamy się tylko dziwić, czy zatwierdzać do końca mimo ewentualnego zdziwienia. Akurat w~przypadku segmentacji nie ma się czemu dziwić.
#
# Metody te wołają #{akat.\<poziom>_niegot?( session[ :rola_id ], zdziw_sie )}.
 
  
  def odrzuc_akapit
    raise "##{annotation_controller.capitalize}.odrzuc_akapit: action forbidden."
    akat = akapit_transzy
    ko = akat.komentarz( session[:uzid], session[ :tylko_nowe_komentarze ] )
    if ko.size > 0 and ko[-1].przyczyna_odrzucenia != 0 and 
        ( /[a-a]/i =~ ko[-1].tresc.to_s or ko[-1].przyczyna != "" )
      
      podnies_status( akat )
      ## logger.info "@@@@ podnies_status in odrzuc_akapit"
      AkapitTranszy.transaction do
        akat.odrzucony=true
        akat.save!
        if r_zarzadca?
          zbli = akat.bliźniaczy
          zbli.odrzucony = true
          zbli.save!
        end
      end # of transaction

      logger.info "poziomy: #{poziomy.join(', ')}"
      zweryfikuj_akapit(akat, :odrzuc, poziomy)

    else # brak komentarza lub przyczyny odrzucenia lub p.o. jest "inne" i nie ma treści komentarza
      notice = "Przy odrzuceniu musisz dodać komentarz i&nbsp;wybrać w nim przyczynę odrzucenia."
      if ko[-1] and ko[-1].przyczyna_odrzucenia == 4
        notice += " Podałaś/eś przyczynę Inne. Musisz napisać dokładniej, o&nbsp;co chodzi."
      end
      flash[:notice] = notice
#      @komentarz_do_odrzucenia = true # nie działa, tzn akcja anotuj tego nie widzi.
      redirect_to :action => :anotuj, :kom_odrzuc => true, :akat => akat
    end
      
  end # of #{odrzuc_akapit}.


  def komentarz_dodaj
    komentarz_toggle( true )
  end

  def komentarz_anulowany
    komentarz_toggle( false )
  end

  
  def komentarz_zatwierdz
    ko = Komentarz.new(:akapit_transzy_id => params[:id],
                       :akapit_id => ( params[ :akapit_id ].to_i || session[:akapit] ) ,
                       :uzytkownik_id => ( session[ :drag_queen_id ] || session[ :uzid ]) 
                       )
    ko.tresc= params[:komentarz_nowy][:tresc]
    ko.przyczyna_odrzucenia = params[:komentarz_nowy][:przyczyna_odrzucenia].to_i
    if ( ko.tresc and /\w/i =~ ko.tresc ) or 
        ( ko.przyczyna_odrzucenia != 0 and ko.przyczyna_odrzucenia != 4)
      ko.save!
    end
    render :update do |page| 
      page.replace_html 'komentarze', 
      :partial => 'komentarze', 
      :object => [ AkapitTranszy.find(params[:id]), :anotacja ]
      page.replace_html 'komentarz_dodaj',
      :partial => 'komentarz_dod_link',
      :object => AkapitTranszy.find(params[:id])
    end
  end # of #komentarz_zatwierdz


  def fraza_upuszczono
    tokpocz, tokkon = params[:id].to_i, params[:upusc].to_i
    tokpocz, tokkon = tokkon, tokpocz if tokpocz > tokkon
    akat = akapit_transzy

# sprawdzamy, czy nie próbujemy objąć już jakiejś zaznaczonej frazy
    drogawolna=true
    tokpocz.upto(tokkon) { |tokid0|
      drogawolna = false if akat.fraza(tokid0) 
    }

    if drogawolna
      AkapitTranszy.transaction do
        obniz_status( akat, :syntactic )
        akat.fraza_anot.create(
                             :token_id_pocz => tokpocz,
                             :token_id_kon => tokkon)
      end
    end

    refresh_fraza(tokpocz, tokkon)
  end # of #fraza_upuszczono

  def frazy_wyczysc
    akat = akapit_transzy
    AkapitTranszy.transaction do
      obniz_status( akat, :syntactic )      
      akat.fraza_anot.delete_all
    end
    
    redirect_to :action => :anotuj, :akat => akat, :anchor => :primafalsa
  end # of #frazy_wyczysc

  def fraza_wyczysc
    FrazaAnot.transaction do
      FrazaAnot.delete(params[:id])
      obniz_status( akapit_transzy, :syntactic )
    end
    redirect_to :action => :anotuj, :akat => akapit_transzy, :anchor => :primafalsa # najprościej 
    # zrenderować całą stronę, żeby odbudować brakujące komórki
  end

  def fraza_ukryj_typ
    fraa=    FrazaAnot.find(params[:id])
    @pokaz_wybor_typu = true
    refresh_fraza( fraa.token_id_pocz, 0 )
  end

  def fraza_wybor_typu
    set_uzid
    akat_hash
    fraa=    FrazaAnot.find(params[:id])
    ftypid =  params[:fraza_typ][:fraza_typ_id]
    if ftypid
      ftyp = FrazaTyp.find(ftypid)
      vp = (ftyp.typ_symbol == "VP")
      vpneg = nil
      if vp
        fraa.tokens.each{ |tok|
          vpneg = true if tok.orth =~ /^nie$/i 
        }
      end
      
      synh = fraa.synheads(@akat_hash, ftypid)[0]
      semh = fraa.semheads(@akat_hash, ftypid)[0]
      # metoda semheads klasy FrazaAnot
      
      if (synh or ftyp.moze_bez_glowy?(:synh)) and 
          (semh or ftyp.moze_bez_glowy?(:semh))
        # jeśli nie ma którejś głowy, to fraza prawdop. 
        # jest źle oznaczona, a wtedy nic z nią nie robimy,
        # tylko wracamy do wyboru typu.
        fraa.vp_typ = 1 if vp and not vpneg
        fraa.vp_typ = 0 if vp and vpneg
        fraa.token_id_synhead = synh[1].token_id if synh
        fraa.token_id_semhead = semh[1].token_id if semh
        fraa.fraza_typ_id = ftypid
        FrazaAnot.transaction do
          fraa.save!
          obniz_status( akapit_transzy, :syntactic )
        end
        #      @pokaz_wybor_typu = false # sam znika, ciekawe dlaczego
      else
        @pokaz_wybor_typu = true
      end
      #   redirect_to :action => 'anotuj' # for debug
    else
      logger.error( "ftypid is nil!!!!" )
    end # of #{if ftypid}
    refresh_fraza( fraa.token_id_pocz, 0)
  end # of #{fraza_wybor_typu}
  
  
  def fraza_wybor_anulowany
    fraa=    FrazaAnot.find(params[:id])
    refresh_fraza( fraa.token_id_pocz, 0)    
  end


  def fraza_glowy_ukryj
    fraa=    FrazaAnot.find(params[:id])
    @pokaz_wybor_semh = true
    @pokaz_wybor_synh = true
    refresh_fraza( fraa.token_id_pocz, 0)    
  end

  def fraza_synh_ukryj
    fraa=    FrazaAnot.find(params[:id])
    @pokaz_wybor_synh = true
    @pokaz_dwie_glowy = true
    refresh_fraza( fraa.token_id_pocz, 0)    
  end

  def fraza_semh_ukryj
    fraa=    FrazaAnot.find(params[:id])
    @pokaz_wybor_semh = true
    @pokaz_dwie_glowy = true
    refresh_fraza( fraa.token_id_pocz, 0)    
  end


  def fraza_dwie_glowy
    fraa = FrazaAnot.find(params[:id])
    @pokaz_dwie_glowy = true
    refresh_fraza( fraa.token_id_pocz, 0)
  end

  def fraza_wybor_glowy
    fraa = FrazaAnot.find(params[:id])
    glowa_id = params[:fraza_glowa][:glowa_id].to_i
    glowa_id = nil if glowa_id == -1
    ktora_g = params[:ktora_g]
    if ktora_g == "obie" or ktora_g == "semh" : rob_semh = true
    else rob_semh = false;  end
    if ktora_g == "obie" or ktora_g == "synh" : rob_synh = true
    else rob_synh = false;  end
    fraa.token_id_synhead =  glowa_id if rob_synh
    fraa.token_id_semhead =  glowa_id if rob_semh
    FrazaAnot.transaction do
      fraa.save!
      obniz_status( akapit_transzy, :syntactic )
    end
    # @pokaz_wybor_synh # znika samo, ciekawe czemu
    # @pokaz_wybor_semh # znika samo, ciekawe czemu
    refresh_fraza( fraa.token_id_pocz, 0)    
  end # of #fraza_wybor_glowy


  def fraza_sie_typ_ukryj
    fraa=    FrazaAnot.find(params[:id])
    @pokaz_wybor_sie_typu = true
    refresh_fraza( fraa.token_id_pocz, 0)    
  end

  def fraza_sie_typ_wybor
    fraa=    FrazaAnot.find(params[:id])
    sie_typ = params[:fraza_sie_typ][:sie_typ]
    if sie_typ
      fraa.sie_typ = sie_typ.to_i
      FrazaAnot.transaction do
        fraa.save!
        obniz_status( akapit_transzy, :syntactic )
      end
    end
    refresh_fraza( fraa.token_id_pocz, 0)    
  end


  def ogladactwo
    if r_wszewid?
      @ile_rozbieznych = AkapitTranszy.ile_zaanotowanych( nil, :rozbieżny )
      @akapity_podsadne = Akapit.zaanotowane(
                                             :podsądny ## ,
                                             ## :where => "s.word_senses_uzid is not null"
                                             ## :having => "count( distinct s.akapit_transzy_id )=1"
                                             )
      @ile_podsadnych = AkapitTranszy.ile_zaanotowanych( nil, :podsądny ) + ", razem " +
        AkapitTranszy.ile_zaanotowanych_total( nil, :podsądny )
      @transze = Transza.find(:all,
                                  :conditions => "transza.uzytkownik_id is not null",
                                  :include => :uzytkownik,
                                  :order => "uzytkownik.uzytkownik_id, transza.transza_id" )
      # akapity skomentowane pobieramy w partialu, bo zależy, czy mamy session[:skomentowane_pokaż] czy nie
    end

    ##    @akapity_zweryfikowane = Akapit.zaanotowane( :zweryfikowany )
    # nie używane
    
  end # of #{ogladactwo}


  def quasi_transza_brutal
    ##    ( session[ :pokaz_qtra ] ||= Hash.new ) [ params[:klucz] ] = true
    @klucz = params[:klucz]
    @qt_klucz = @klucz.split("-")
  end # of #quasi_transza_brutal



  def pokaz_quasi_transze
    ( session[ :pokaz_qtra ] ||= Hash.new ) [ params[:klucz] ] = true
    qt_klucz = params[:klucz].split("-")
    
    render :partial => 'quasi_transza', 
    :object => [ Akapit.quasi_transza( qt_klucz ),
                 params[:klucz]   ]
  end # of #pokaz_quasi_transze



  def ukryj_quasi_transze
    if session[ :pokaz_qtra ] and session[ :pokaz_qtra ][ params[:klucz]] 
      session[ :pokaz_qtra ].delete( params[:klucz] )
    end
    render :partial => 'quasi_transza', 
    :object => [ [],    params[:klucz]   ]
  end # of #ukryj_quasi_transze


  def ukryj_wszystkie_quasi_transze
    session[ :pokaz_qtra ] = nil
    redirect_to :action => :zweryf
  end # of #ukryj_wszystkie_quasi_transze



  def prosba_o_odebranie_transzy
    render :partial => 'odbierz_transze', :object => Uzytkownik.find(params[:id])
  end

  def prosba_anulowana
    render :partial => 'prosba_link', :object =>  params[:id]
  end


  def prosbe_o_odebranie_zapisz
    # wygląda na to, że możliwość proszenia o~odebranie transzy w~tej wersji Anotatorni zosała zakryta przed oczyma śmiertelnych.
    poo = params[:prosba_o_odebranie]
    if poo
      @anotator = Uzytkownik.find(params[:id])
      tai =  poo[:transza_id].to_i
      utoc = @anotator.transze_otwarte.collect{ |tra| tra.transza_id }
      przy = poo[:przyczyna].to_s
      if tai and utoc.include?(tai) and przy and /[a-z]/i =~ przy
        ProsbyAnotatorek.create(
                                :dotyczy_id => tai,
                                :dotyczy_type => "Transza",
                                :uzytkownik_id => @anotator.uzytkownik_id,
                                :rozpatrzona => false,
                                :spelniona => false,
                                :opis => przy )
        # odebrana i tak jest 'f' by default.
      end# of if tai ...  and przy ...
    end # of if poo
    session[:odebrania_transz_pokaz] = true
    render :update do |page| 
      page.replace_html( 'odbierz_transze',  :partial => 'prosba_link', 
                         :object =>  @anotator.uzytkownik_id )
      page.replace_html( 'lista_odebranych', :partial => 'lista_odebranych', 
                         :object => @anotator.odebrania_transz)
    end # of render update do page

  end


  def odebrania_transz_toggle(val)
    @anotator = Uzytkownik.find(params[:id])
    session[:odebrania_transz_pokaz] = val
    render :partial => 'lista_odebranych', :object => @anotator.odebrania_transz
  end


  def  odebrania_transz_ukryj
    odebrania_transz_toggle(nil)
  end


  def odebrania_transz_pokaz
    odebrania_transz_toggle(true)
  end


  def token_tworz_tag
    session[:zmieniaj_dyzamb] ||= Hash.new
    session[:zmieniaj_dyzamb][params[:id].to_i] = :tworz
    token = Token.find(params[:id])
    td0 = token.disambs( akat_hash )[0]
    if td0 :    @lemat = td0.leksem.lemat 
    else # tokeny mogą nie być zdyzambiguowane
      @lemat =  if int0 = token.interpretacja[0]
                  int0.leksem.lemat
                else token.orth
                end
    end
      render :partial => 'token_tworz_tag', :object => [ token, @akapit_transzy ]
  end# of #{token_tworz_tag}.
  
  
  def autocomplete_tag
    currval = params["token_tag#{params[:id]}"][:tag].to_s.strip.downcase
    # #downcase added 2010/6/16 to fix \#356
    ##     re = Regexp.new("^#{currval}" , "i" )
    ##    @tags= Tagset.znajdz_pos( :all ).collect{ |t|
    ##      t.lewe if t.lewe.match re
    ##    }.compact
    ##    @tags = ['brekekekk', 'keke brekk']
    @tags = Tagset.matches( currval )
    ##    logger.info "@@@@@ "  + @tags.inspect
    render :layout => false
  end
  
  
  def interpretacja_z_tagu
    set_uzid
    @tokid = params[:id].to_i
    tagparam = "token_tag#{@tokid}".intern
    lematparam="token_lemat#{@tokid}".intern
    logger.info "@@@@ przed tworzeniem tagu: params=#{params.inspect}"
    tag = ( params[tagparam] || 
            (logger.info "@@@@@@ params[#{tagparam.inspect}] is nil!"
             {}) )[:tag].to_s.
      downcase # added 2010/6/16 to fix \#356
    lemat = params[lematparam][:lemat]
    ct  = Tagset.check_tag( tag, lemat )
    if ct[0]
      iid = Interpretacja.fc_by_fulltag( @tokid, lemat, tag ).id
      conds = { 
        :akapit_transzy_id => akapit_transzy.id,
        :token_id => @tokid
      }
      ia = InterpretacjaAnot.find( :first, :conditions => conds )
      ia ||= InterpretacjaAnot.new( conds )
      ia.uzytkownik_id = @uzid
      ia.interpretacja_id = iid
      ia.save!
      Interpretacja.odsmiec( :token_id => @tokid )
      Token.find( @tokid ).zambiguuj

      if ( szd = session[ :zmieniaj_dyzamb ] ) and szd[ @tokid ]
        szd[@tokid] = nil
      end
      odswiez_token( @tokid )
    else  flash.now[:tworz_tag] = ct[1]
      session[ :tworz_tag ] ||= Hash.new
        session[ :tworz_tag ][ @tokid ] = { :lemat => lemat, :tag => tag }
      odswiez_token( @tokid, :tworz_tag )
    end
  end# of #{interpretacja_z_tagu}.


  def  nowytag_skopiuj_orth
    session[ :tworz_tag ] ||= Hash.new
    @tokid = params[ :id ].to_i
    lemat = Token.find( @tokid ).orth
    session[ :tworz_tag ][ @tokid ] ||= Hash.new
    session[ :tworz_tag ][ @tokid ].update( @tokid => { :lemat => lemat } )

    render :update do |page| 
      page.replace_html "token_lemat#{@tokid}", :partial => 'tworz_tag_lemat', 
      :object => [ @tokid, lemat ] 
    end

  end # of #{nowytag_skopiuj_orth}
  

  def poziomuj
    set_uzid
    parampa = params[ :poziomy_anotacji ]
    if parampa
      ## logger.info( parampa.class )
      set_poziomy
      parampa.each_pair{ |key, val|
        poziom = key.intern
        ##          logger.info( "@@@@ poziom #{poziom}: #{val.to_bool}" )
        if PoziomyAnotacji.działające.include?( poziom )
          @poziomy_wybrane.set_poziom( poziom,  val.to_bool )  ## unless poziom == :morphosyntactic
          # AP chce móc wyłączyć morfosyntaks.
        end
      }
      @poziomy_wybrane.save!
      
      redirect_to :action => :anotuj, :akat => akapit_transzy, :anchor => :primafalsa
    end
  end # of #{poziomuj}.
  
  
  def zarządca_jak_anotator
    zja = params[:jak_anotator][:jak_anotator].to_bool
    session[ :jak_anotator ] = zja
    set_uzid
    @użytkownik.jak_anotator = zja
    @użytkownik.save!
    
    redirect_to :action => :anotuj, :akat => akapit_transzy, :anchor => :primafalsa
  end


  # akcje związane z ujednoznacznieniem segmentacji
  
  def segmentacja_zmieniaj
    set_poziomy
    @tokid = params[:id].to_i
    ( session[ :zmieniaj_segmentacje ] ||= {} )[ @tokid ] =  true
    odswiez_token(@tokid, :segmentation)
  end # of #segmentacja_zmieniaj


  def segmentacja_ujednoznacznij
    set_poziomy
    segdec=params[:sg_variant_anot]
    ##      logger.info( "@@@@ segdec: #{segdec}, class: #{segdec.class}" )
    session[:zmieniaj_segmentacje] ||= Hash.new
    if segdec
      segdec=segdec[ :wybierz ].to_bool
      # teraz #segdec jest #true gdy mamy ten wybrać, bądź #false gdy mamy ten odrzucić
      tokid = params[:id].to_i
      token = Token.find( tokid )
      sg_choice = token.sg_choice
      sgvid = token.sg_variant_id
      sguj_tokids = []
      SgVariantAnot.transaction do
        sg_choice.sg_variant.each{ |sgv|
          sgv_cond = {
            :akapit_transzy_id => akapit_transzy.id,
            :sg_choice_id => sg_choice.id,
            :sg_variant_id => sgv.id
          }
          sgvan = SgVariantAnot.find(
                                     :first,
                                     :conditions => sgv_cond)
          sgvan ||= SgVariantAnot.new( sgv_cond )
          # oznaczamy wariant jako wybrany wtw gdy 
          sgvan.chosen = if sgv.id == sgvid
                           segdec
                         else ( not segdec )
                         end
          sgvan.save!
          sgv.token.each{ |tok| 
            if sgvan.chosen? and not tok.chosen?
              tok.chosen =true
              tok.save!
            end
            sguj_tokids << tok.id }
        }# of each segm. variant
        obniz_status( akapit_transzy, :segmentation )
      end# of transaction
    else# #{not intid}
      sguj_tokids = [ params[:id].to_i ]
    end
    # #{    redirect_to :action => 'anotuj'} for debug
    sguj_tokids.each{ |tokid|
      raiseifzero( tokid, "segmentacja_ujednoznacznij" )
      session[ :zmieniaj_segmentacje][ tokid ] = nil }
    
    odswiez_token( sguj_tokids, :segmentation )
    
  end # of #{segmentacja_ujednoznacznij}.
  
  
  def segmentacja_anulowana
    @tokid=params[ :id ].to_i
    set_poziomy
    szs = session[ :zmieniaj_segmentacje ]
    szs[@tokid] = nil if szs
    raiseifzero( @tokid, "segmentacja_anulowana" )
    odswiez_token( @tokid, :segmentation )
  end # of #segmentacja_anulowana
  
  
  # granice zdań

  def konczymy_zdanie
    @tokid=params[ :id ].to_i
    set_poziomy
    akat=akapit_transzy
    kz = KoniecZdaniaAnot.znajdz( akat, @tokid )
    
    if kz
      kz.destroy
    else  
      KoniecZdaniaAnot.create( 
                              :akapit_id => akat.akapit.id,
                              :akapit_transzy_id => akat.id,
                              :uzytkownik_id => akat.get_uzid( session[ :uzid ] ),
                              :token_id => @tokid
                              )
    end
    odswiez_token( @tokid, :sentences )
  end # of #{konczymy_zdanie}.
  

  def nowa_prośba_segmentacyjna
    if params[ :akapit ]
      ak = Akapit.find( params[ :akapit ] )
    elsif r_anotator?
      raise "Prośba o nową segmentację bez akapitu! (anotacja_controller.rb l. 1005)"
    end
    if seg = params[ :nowa_segmentacja ]
      seg_is = seg[ :is ].split
      seg_should_be = seg[ :should_be ].split
      nps = true # domyślnie ma być bez spacji
      if seg_should_be.size > 1
        # jeśli nie zaznaczono opcji dot. spacjowania, przyjmujemy, że ma być bez spacji
        nps = ( seg[ :nps ] == nil ) || seg[ :nps ].to_bool
      end
      seg_opis = seg[ :opis ]
      seg_akids = seg[ :akids ]
    end

    ##    logger.info "@@@@ nps: #{nps.inspect}"

    ##    logger.info "@@@ akapit #{params[:akapit].inspect}"
    ##    logger.info "@@@ params[ :nowa_segmentacja] == #{params[:nowa_segmentacja].inspect}"
    ##    logger.info "@@@ seg_is.inspect == #{seg_is.inspect}"
    # chcemy ustalić akapit, w którym występują takie token(y)
    if ak and ak.są_orthy?( seg_is, :strict )
      ids = [ ak.id ]
    elsif seg_akids and (akids = ( seg_akids.split.collect{ |akid| akid.to_i } - [0] ))[0]
      ids = []
      akids.each { |id214|
        if a214 = Akapit.find( id214 ) and a214.są_orthy?( seg_is, :strict )
          ids << id214
        end
      }  
    else
      ids = Akapit.znajdź_po_orthach( seg_is, :strict ).collect{ |x| x.id }
    end

    if ak
      unless ids.include?( ak.id )
        notice = "Podane tokeny nie występują w akapicie #{ak.id}. Nic nie robię."
      else
        notice = nil
      end
    else # #{not ak} czyli nie podano akapitu, w~którym miałoby to być
      if ids[0]
        notice = nil
      else
        notice = "W akapicie/ach #{ids.join(', ')} nie ma takiego układu tokenów. Nic nie robię."
      end
    end

    unless notice
      # sprawdzimy, czy rzeczywiście chodzi o zmianę segmentacji
      if seg_is.join != seg_should_be.join
        notice = "Podany stan obecny (»#{seg_is.join(' ')}«) nie zgadza się ze stanem żądanym (»#{seg_should_be.join(' ')}«). Nic nie robię."
      elsif seg_is == seg_should_be
        notice = "Proponujesz to samo, co już jest (w obu polach »#{seg_is.join(' ')}«). Nic nie robię."
        # nie odrzucamy przypadku »ala ma kota« -> »ala makota« tzn. gdy któryś token pozostaje niezmieniony.
      elsif NowaSegmentacja.find( :first, 
                                  :conditions => ( 
                                                  ns_hash194 = {
                                                    :seg_is => seg_is.to_yaml, 
                                                    :seg_should_be => seg_should_be.to_yaml,
                                                    :ids => ids.to_yaml, 
                                                    :nps => nps } ) )
        notice = "Już zgłoszono taką prośbę o zmianę segmentacji »#{seg_is.join(' ')}«. Nic nie robię."
      elsif NowaSegmentacja.new( ns_hash194 ).instanze( :seg_should_be )[ 0 ]
        notice = "Takie »ma być« już <b>*jest*</b>. Nic nie robię."
      end
    end

    if notice
      flash.now[ :nowa_segmentacja ] = notice
    else
      ns_hasz = { :ids => ids,
        :seg_is => seg_is,
        :seg_should_be => seg_should_be,
        :nps => nps
      }
      if pakat = params[ :akat ]
        akat = AkapitTranszy.find( pakat )
        ns_hasz.update( 
                        :akapit_transzy_id => akat.id,
                        :transza_id => akat.transza_id )
      end

      p = ProsbyAnotatorek.create!(
                                   :uzytkownik_id => ( session[ :drag_queen_id] || session[:uzid] ),
                                   :dotyczy => NowaSegmentacja.new( ns_hasz ),
                                   :opis => seg_opis
                                   )
      flash.now[ :nowa_segmentacja ] = "Zapisałam prośbę o #{p.treść_acc}."
    end

    prośby_toggle( :nowa_segmentacja_pokaz, nil )
    refresh_prośby
  end # of #nowa_prośba_segmentacyjna
  
  
  
  def nowa_segmentacja_ukryj
    akapit_transzy if r_anotator?
    prośby_toggle( :nowa_segmentacja_pokaz, nil )
    render_prośby
  end
  
  def nowa_segmentacja_pokaz
    akapit_transzy if r_anotator?
    prośby_toggle( :nowa_segmentacja_pokaz, true )
    render_prośby
  end


  def spełnij_prośbę
    prośba = ProsbyAnotatorek.find(params[:id])
    unless prośba.dotyczy_type == params[:dotyczy_type] and 
        prośba.dotyczy_id == params[:dotyczy_id].to_i
      flash[:prosby_anotatorek] = "Prośba przekazana w parametrach niezgodna z prośbą zapisaną w bazie!"
    else # prośba zgodna z tym co w bazie
      if p =  prośba.commit( session[ :rola_id ] )
        flash[ :prosby_anotatorek ] = p
      end
      refresh_prośby( prośba.dotyczy.is_a?( Transza ))
    end # of prośba check
  end # of #rozpatrz_prośbę


  def dodaj_segmentacje # 2009/6/24 prawdopodobnie niepotrzebna: nie jest używana.
    @akapit = Akapit.find( params[:akapit_id] )
    @prośba = ProsbyAnotatorek.find( params[:prosba_id])
  end# of #dodaj_segmentacje


  def odrzuć_prośbę
    flash.now[ :prosby_anotatorek ] = 
      ProsbyAnotatorek.find( params[:id] ).odrzuć( session[ :rola_id ] )
    refresh_prośby
  end # of #odrzuć_prośbę


  def sense_inventory
  end
  
  def zweryf # używana przez Beatę
    @akapity_zweryfikowane = Akapit.zaanotowane( :zweryfikowany )
  end # of #{zweryf}
  


  def wsze_transze_otwarte_toggle
    if params[:direction] == 'show'
      session[:pokaż_wsze_transze_otwarte] = true
    else
      session[:pokaż_wsze_transze_otwarte] = false
    end      
    
    render :update do |page| 
      page.replace 'wsze_transze_otwarte',
      :partial => 'wsze_transze_otwarte'
    end
  end # of #{wsze_transze_otwarte_toggle}


  def wsze_transze_BW_toggle
    if params[:direction] == 'show'
      session[:pokaż_wsze_transze_BW] = true
    else
      session[:pokaż_wsze_transze_BW] = false
    end      
    
    render :update do |page| 
      page.replace 'wsze_transze_BW',
      :partial => 'wsze_transze_BW'
    end
  end # of #{wsze_transze_BW_toggle}


  private

  
  @akapit_transzy = nil
  @akat_bliźniak = nil


  def akapit_transzy
    set_uzid

    if ( pakat = params[ :akat ] ) and ( pakat.to_i != session[ :akat ] )
      zniluj_akapitowe
      session[ :akat ] = pakat.to_i
      @akapit_transzy = nil
    end

    unless @akapit_transzy
      
      if session[ :akat ]
        @akapit_transzy = AkapitTranszy.find( session[ :akat ] )
      else
        ##        logger.info "@@@@ no session[ :akat ] anotator: #{session[:anotator]}"
        @akapit_transzy = AkapitTranszy.znajdz( session[:akapit], @anotid )
      end
    end# of #{unless @akapit_transzy}

    @akapit_transzy.reload # bo status się nie odświeżał
    
    session[ :akat ] = @akapit_transzy.id

    unless @akat_bliźniak
      @akat_bliźniak = @akapit_transzy.bliźniaczy
    end
    
    if ( not @transza ) or @transza.id != @akapit_transzy.transza_id
      @transza = @akapit_transzy.transza
      if r_wszewid? and session[ :anotator ] != @akapit_transzy.uzytkownik_id and 
          session[ :anotator ] != @transza.uzytkownik_id 
        @anotid = ( session[ :anotator ] = @transza.uzytkownik_id )
      end
    end
    
    ###    logger.info "@@@@@ akapit transzy ustalony: #{@akapit_transzy.id}"
    @akapit_transzy
  end # of #{akapit_transzy}


  def akat_hash
    unless @akat_hash
      @akat_hash = akapit_transzy.akat_hash
    end
    @akat_hash
  end
  
  def akat_walencyjny?
    Walencja.x and ( @akapit_transzy.ramka_id or
                     (@akapit_transzy.ma_status?( :>=, :doramki ) and
                      (not @akapit_transzy.niefrazowny?) and 
                      not @akapit_transzy.niesensowny?))
  end
  
  def inicjuj_akat
    akapit_transzy
    akat_hash
  end

  def odswiez_token( *params )
    tokids = params.delete_at(0)
    ## logger.info "@@@@@ tokids w odśwież_token: #{[tokids].flatten.join(', ')}"
    tokens = Token.find( :all,
                         :conditions => { :token_id => [tokids].flatten,
                           :chosen => true } # drugi warunek dodany 2009/8/23 w~ramach tropienia  \#246.
                         ) # musi umieć obsłużyć tablicę idów, ze względu na #{segmentacja_ujednoznacznij}.
    set_uzid
    akat_hash
    render :update do |page| 
      if not ( params & [ :tylko_sens, :segmentation, :sentences ] )[ 0 ]
        if params.include?( :tworz_tag )
          tokpartial = 'token_tworz_tag'
        else 
          tokpartial = 'token_disamb'
          session[:tworz_tag] = nil if session[:tworz_tag]
        end
        tokens.each{ |tok| 
          page.replace_html "disa-token_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => tokpartial, :object => [tok, @akapit_transzy, true] }
        
      elsif (params & [ :segmentation, :sentences ])[ 0 ]
        tokens.each{ |tok|
          page.replace "outer_seg-token_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => 'token_td', :object => [tok, @akapit_transzy, true] }
      else
        tokens.each{ |tok|
          page.replace_html "sens-anot_#{@akapit_transzy.id}_#{tok.id}", 
          :partial => 'token_sens', :object => [tok, @akapit_transzy, true] }
      end

      if params.include?( :sentences )
      page.replace_html( 
                        'sentenśnik', 
                        :partial => 'sentenśnik', :object => @akapit_transzy
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      end
      
      page.replace_html( 
                        'status_info', 
                        :partial => 'status_info'
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      page.replace_html( 
                        'zatwod_buttons', 
                        :partial => 'anotuj_zatwod_nk'
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
    end
  end# of #{odswiez_token}.


  def refresh_fraza(tokpocz, tokkon)
    # musi być tokpocz<=tokkon, inaczej zrenderuje się tylko dla tokpocz
    tokkon = tokpocz if tokpocz > tokkon
    refresh_walencje if Walencja.x
    akat_hash
    
    render :update do |page| 
      tokpocz.upto(tokkon) do |tokid|
        page.replace( # replace_html zastępuje wnętrze eltu, ta --- cały elt
                     'token_fra_' + tokid.to_s, 
                     :partial => 'token_fra', 
                     :object => [Token.find(tokid), @akat_hash, :lewa])
        page.replace( # replace_html zastępuje wnętrze eltu, ta --- cały elt
                     'framka_' + tokid.to_s, 
                     :partial => 'token_framka', 
                     :object => [Token.find(tokid), @akat_hash])
      end
      page.replace_html( 
                        'status_info', 
                        :partial => 'status_info', 
                        :object => @akapit_transzy
                        # z jakiegoś powodu nie działało, kiedy wpisywałem tu akapit_transzy
                        )
      page.replace_html( 'walencja',  :partial => 'walencja')
    end
  end# of refresh_fraza


  def zniluj_akapitowe( *keys )
    ##  logger.info "@@@@ zniluj akapitowe"
    klucze = keys + [ :akapit, :akat, :status, :zdziw_sie_akapitowi ]
    # 2009/04/18 usunąłem z~powyższej listy klucz #{:weryfikacja}.
    klucze += [ :zmieniaj_dyzamb, 
                :tworz_tag, 
                :zmieniaj_segmentacje] if DlaEli.nk
    klucze.each{|klucz| session[ klucz ] = nil }
    #    session[:anotator] = nil
  end# of #{zniluj_akapitowe}

    
  def podnies_status( akat, poziom, weryfikacja=nil, czy_bliźniaczy=nil )
    # ostatni argument jest podany jako nie\dy #{nil} tylko przy przyklepywaniu akapitu.
    ##    logger.info "@@@@ ##{annotation_controller.capitalize}Controller.podnies_status: akat #{akat.id} \n" +
      "poziom: #{poziom.inspect}, weryfikacja: #{weryfikacja.inspect},\n " +
      " czy_bliźniaczy: #{czy_bliźniaczy.inspect}"
    akat_STATI = AkapitTranszy::STATI
    stati_pdn = AkapitTranszy::STATI_podnies# hasz kodujący graf podnoszenia poziomu
    akats = akat.statusy
    blis = akat.bliźniaczy.statusy
    
    if r_zarzadca?
      akatsp = AkapitTranszy::STATI[:osądzany]
      czy_bliźniaczy = true
    else
      akatsp = akats.send( poziom )
    end
    ##    logger.info "@@@@@ podnies_status, weryfikacja: ›#{session[:weryfikacja].inspect}‹, czy bliźniaczy: #{czy_bliźniaczy.inspect}\n"
    if ( not ( weryfikacja and
               ( werdykcik = # (jedno #{=}!)
                 weryfikacja[:werdykciki][poziom] )
               # taki układ spójników logicznych, żeby koniecznie obliczyć werdykcik, bo potrzebujemy go dalej
               )) and stati_pdn.has_key?( akatsp )
      nowy_statusek = stati_pdn[ akatsp ]
      Statusy.transaction( akats, blis ) do
        akats.set_poziom( poziom, nowy_statusek )
        akats.save!
        if czy_bliźniaczy or nowy_statusek >= akat_STATI[ :do_osądzenia ]
          ##          logger.info "@@@@ ustawiam bliźniaczy"
          blis.set_poziom( poziom, nowy_statusek )
          blis.save!
        end
      end # of transaction
    elsif werdykcik
      # (Może być nieznilowany werdykcik dla poprzedniego poziomu, a~dla naszego może jeszcze nie być.)
      #  w tym wypadku uwzględnimy werdykcik:
      Statusy.transaction( akats, blis ) do
        nowy_statusek = stati_pdn[ [akatsp, werdykcik] ]
        akats.set_poziom( poziom, nowy_statusek )
        akats.save!
        if czy_bliźniaczy or nowy_statusek >= akat_STATI[ :do_osądzenia ]
          ##          logger.info "@@@@ ustawiam bliźniaczy"
          blis.set_poziom( poziom, nowy_statusek )
          blis.save!
        end
      end# of transaction
    else
      raise( "#{annotation_controller}_controller.podnies_status: ani weryfikacji, ani gołego statuska w haszu???" ) 
    end
    
    # ten akapit jest skopiowany z metody #\<akapit_transzy>.status_co_najmniej=
    # która zapewne jest tym sposobem niepotrzebna.
    if akat.statusy.send( poziom ) < akat_STATI[ :zweryfikowany ] and 
        akat.bliźniaczy.statusy.send( poziom ) >= akat_STATI[ :zweryfikowany ]
      blis.set_poziom( poziom, akat_STATI[ :osądzany ] )
      blis.save!
      ##        logger.info( "@@@@ podnies_poziom: obniżyłam status bliźn. na poz. :#{poziom} do :osądzany." )
    end
  end# of #{podnies_status}.
  

  def obniz_status( akat, poziom )
    akats = akat.statusy
    akatsp = akats.send( poziom )
    stati = AkapitTranszy::STATI_obniz
    ##    logger.info "@@@@@ tu działa #{session[ :login ].inspect}"
    ##    logger.info "@@@@ obniżam status akat. #{akat.id} #{poziom.inspect} z #{akatsp} na #{stati} (akat.status był #{akat.status})"
    Statusy.transaction do
      akats.set_poziom( poziom, stati[akatsp] )  # jeśli akapit było na tym poziomie zakończony, a teraz obniżamy status, to musimy zakazać anotacji na wyższych poziomach, i~ta metoda to robi.
      akats.save!
      akat_STATI = AkapitTranszy::STATI
      if akats.send( poziom ) == akat_STATI[ :osądzany ]
        blis = akat.bliźniaczy.statusy
        blisp = blis.send( poziom )
        if blisp > akat_STATI[ :osądzany ]
          blis.set_poziom( poziom, akat_STATI[ :osądzany ] )
          blis.save!
        end # of #{if bli.status}
      end # of #**akat.satus == osądzany*
    end # of #transaction
    session[ :status ] = akat.status
    ##    logger.info "@@@@  akat. #{akat.id} .status == #{akat.status}"
  end


  def przypisz_oba_uzidy( poziom ) 
    akats = akapit_transzy.statusy.reload
    uzid = @akapit_transzy.get_uzid( session[ :uzid ] )

    blis = @akat_bliźniak.statusy.reload
    bluzid = @akat_bliźniak.get_uzid( session[ :uzid ] )
    
    Statusy.transaction( akats, blis ) do
      akats.set_uzid( poziom, uzid )
      blis.set_uzid( poziom, bluzid )
      akats.save!
      blis.save!
    end # of transaction
  end# of #{przypisz_oba_uzidy}

  
  def zweryfikuj_akapit( akat, destiny, poziomy, notice=nil )
    ##    logger.info "@@@@ zweryfikuj_akapit 1164: poziomy: #{poziomy.inspect}"
    ##    logger.info "               statuski: #{akat.statuski.inspect}"

    pd = akat.poziomy_dostępne( 
                               session[:rola_id], 
                               :jak_anotator => session[ :jak_anotator ] )
    ##    logger.info "@@@@ statuski: ›#{akat.statuski.inspect}‹, rola_id: ›#{session[:rola_id]}‹,  pd: ›#{pd.inspect}‹"
    pd &= poziomy 

    ##        logger.info "@@@ po weryfikacji 1476: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    

    weryf = akat.weryfikacja(
                             :dokonca => true, 
                             :protokoluj => true, # protokoluj rozbieznosci
                             :poziomy => pd,
                             :rola_id => session[:rola_id],
                             :właśnie_zatwierdzamy => true,
                             :session_uzid => session[ :uzid ]
                             )

    session[:weryfikacja] = weryf

    ##        logger.info "@@@ po weryfikacji 1489: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
    
    ver = {}

    # podprocedura gdy wszystko gra i~bucy:
    przyklep = Proc.new { |poz| 
      na_poz = "Na poz. #{PoziomyAnotacji.gen( poz )}"
      ver[ poz ] = "#{na_poz} przeszedł on weryfikację, gratuluję." if destiny == :zatwierdz
      ver[ poz ] = "#{na_poz} Twój partner także go odrzucił. Gratuluję." if destiny == :odrzuc
  
      ##      logger.info "@@@ po weryfikacji 1494: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"

      podnies_status( akat, poz, weryf, :bliźniacze_też )
      ## logger.info "@@@ po podnies_status 1502: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
      przypisz_oba_uzidy( poz )
      ##        akat.set_status(poz, :zweryfikowany) if r_anotator?
      ##        akat.set_status(poz, :osądzony) if r_zarzadca?
      ##      logger.info "@@@ zweryfikuj_akapit  l.1506 (przyklep), akat. #{akat.id}: #{akat.statuski.inspect} bliźniaczy: #{akat.bliźniaczy.statuski.inspect}"
      akat.send( "commit_#{poz}" )
      # na poziomach seg i~sent, których zatwierdzenie zmienia treść (tekst) akapitu przeznaczoną do wyświetlania, metoda #{commit_…} aktualizuje ją.
      ##      logger.info "@@@ po weryfikacji 1500: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
      Protokol.superancje( poz, akat, session[ :uzid ] ) if r_zarzadca?
      ##        logger.info "@@@ po weryfikacji 1511: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
    } # of #przyklep
    
    # podprocedura w~wypadku niezrobienia przez partnera
    no_verdict = Proc.new { |poz|
      na_poz = "Na poz. #{PoziomyAnotacji.gen( poz )}"
      obrobił = "zaanotował"
      # tu ma być zależnie od statuska
      podnies_status( akat, poz, weryf )
      ## logger.info "@@@@ podnies_status in zweryfikuj_akapit 1197"
      obrobił = "poprawił" if akat.ma_status?( poz, :==, :po_poprawce )
      ##        logger.info "zweryfikuj_akapit 1178, akat. #{akat.id}: #{akat.statuski.inspect}"
      ver[ poz ] = "#{na_poz} Twój partner jeszcze go nie #{obrobił} &#0151; weryfikacja odłożona."    
    } # of #no_verdict
  
    nie_poprawki = true
    bli_po_poprawce = true

    # podprocedura gdy źle
    condemn = Proc.new { |poz|
      na_poz = "na poz. #{PoziomyAnotacji.gen( poz )}"
      nie_poprawki = true
      nie_poprawki &&= akat.ma_status?( poz, :<, :do_poprawki ) 
      ##  if (not session[:weryfikacja]) or session[:weryfikacja][:werdykt]==0  
      if nie_poprawki 
        akat.set_status( poz,  :do_poprawki )
        ##        logger.info "zweryfikuj_akapit 1188, akat. #{akat.id}: #{akat.statuski.inspect}"
        ver[ poz ] =  "Akapit #{akat.akapit_id} poddany weryfikacji #{na_poz} nie przeszedł jej. Do poprawki." if destiny == :zatwierdz
        ver[ poz ] = "Twój partner zaanotował akapit #{akat.akapit_id} #{na_poz} i&nbsp;zatwierdził. Do poprawki." if destiny == :odrzuc
      else
        bli_po_poprawce = true
        bli_po_poprawce &&= akat.bliźniaczy.ma_status?( poz, :>=, :po_poprawce ) 
        if bli_po_poprawce
          akat.set_status( poz,  :do_osądzenia )
          ## logger.info "zweryfikuj_akapit 1200, akat. #{akat.id}: #{akat.statuski.inspect}"
          ver[ poz ] = "Akapit #{akat.akapit_id} poddany ponownej weryfikacji #{na_poz} nie przeszedł jej. Przechodzi pod sąd Superanotatora." if destiny == :zatwierdz
          ver[ poz ]= "Twój partner zaanotował akapit #{akat.akapit_id} #{na_poz} i&nbsp;zatwierdził ponownie. Pod sąd Superanotatora." if destiny == :odrzuc
        else # nie #bli_po_poprawce
          akat.set_status( poz, :po_poprawce, 
                           unless Rola.zarzadca?( session[:rola_id ] )
                             :tylko_to
                           else nil
                           end
                           ) 
          ##          logger.info "zweryfikuj_akapit 1207, akat. #{akat.id}: #{akat.statuski.inspect}"
          ver[ poz ] = "Twój partner jeszcze nie poprawił anotacji #{na_poz}  &#0151; weryfikacja odłożona."
        end # of #{if bli_po_poprawce}
      end # of #{if nie_poprawki}.
    } # of #condemn
    
    case weryf[:werdykt]
    when 1
      poziomy.each{ |poz| przyklep.call( poz ) }
      ##        logger.info "@@@ po weryfikacji 1557: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
    else ##    when 0
      poziomy.each{ |poz|
        case weryf[ :werdykciki ][ poz ] 
        when 1
          przyklep.call( poz )
        when 0 
          no_verdict.call( poz )
        when -1
          condemn.call( poz )
        end
        }
      ##    logger.info "@@@ po weryfikacji 1569: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    
    end# of #{case weryf[:werdykt]}
    ## end

    ##    logger.info "@@@ po weryfikacji 1572: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"    

    ver_total = ( [ notice ] + poziomy.collect { |poz| ver[ poz ] }).compact.join( "<br>\n")

    if weryf[:werdykt] == -1
      flash[:notice] = "Zażądałaś/eś zatwierdzenia akapitu #{akat.akapit.id}:\n <br><i style=\"font-weight: normal\">#{akat.akapit.tresc}</i><br>" + 
        ver_total
      if nie_poprawki or bli_po_poprawce
        redirect_to :action => :anotuj, :akat => akat, :anchor => :notizia
      else
        zniluj_akapitowe
        redirect_to :action => :pokaz_transze 
      end
    else # #{weryf[:werdykt] != -1}
      flash[:notice] =
        "#{destiny}iłaś/eś akapit #{akat.akapit.id}:\n <br><i style=\"font-weight: normal\">#{akat.akapit.tresc}</i><br>" + 
        ver_total
      if weryf[ :werdykt ] == 1 and  akat.ma_Status?( :<, :zatwierdzony )
        # jeżeli akapit na tych poziomach się zweryfikowało, a~jeszcze jest w~nim co anotować, to renderujemy stronę jego anotacji.
        ##        logger.info "@@@@ redirecting to anotuj"
        redirect_to :action => :anotuj, :akat => akat
      else
        zniluj_akapitowe
        redirect_to :action => :pokaz_transze if r_anotator?
        redirect_to :action => :ogladactwo if r_zarzadca?
      end
    end
    ##    logger.info "@@@ po weryfikacji 1597: akat: #{akat.statusy.reload.statuski.inspect}, bliźniaczy: #{akat.bliźniaczy.statusy.reload.statuski.inspect}"
  end # of #{zweryfikuj_akapit},
  
  @anotid=nil
  @uzid=nil
  @użytkownik=nil

  
  def set_uzid
    @anotid = ( session[ :anotator ] || session[ :uzid ] ) unless @anotid
    @anotid = params[ :anotator ].to_i if params[ :anotator ] 
    @użytkownik = Uzytkownik.find( session[ :uzid ] ) unless @użytkownik
    @uzid = ( session[:uzid] ) unless @uzid
    @uzid
  end
  

  def set_poziomy
    inicjuj_akat
    set_uzid
    @poziomy_wybrane = PoziomyAnotacji.znajdz_u( @uzid )
    @poziomy = @poziomy_wybrane.z_pokaźnymi( @akapit_transzy, session[ :rola_id ] )
    session[ :poziomy ] = @poziomy.trues
    # to się znajdzie, bo w migracji 042 zapełniamy tablicę idami użytkowników.
    ##    logger.info "@@@@@ wybrane: #{@poziomy_wybrane.inspect}\n\t\t z_pokaźnymi: #{@poziomy.inspect}"
  end # of #set_poziomy
  
  alias :inicjuj_akat_i_poziomy :set_poziomy


  if Walencja.x
    def refresh_walencje( with_render=nil )
      @akapit_transzy ||= akapit_transzy
      @akat_walencyjny = akat_walencyjny?
      Ramka.odsmiec
      zrob_ramke_dup
      if session[:weryfikacja] and session[:weryfikacja][:werdykt] == -1
        @weryfikacja = session[:weryfikacja]
        @werdykt = @weryfikacja[:werdykt]
      end
    
      if with_render # bo może być tylko jeden render w akcji.
        render :update do |page| 
          page.replace_html( 'walencja',  :partial => 'walencja')
        end
      end
    end# of #refresh_walencje
  end # of #{if Walencja.x}

def refresh_prosby_o_nowy_wzorzec
  render :update do |page| 
    page.replace_html( 'prosby_o_nowy_wzorzec',  
                       :partial => 'prosby_o_nowy_wzorzec' )
  end
end# of refresh_prosby_o_nowy_wzorzec


  def zrob_ramke_dup
    srd = session[:ramka_dup]
    if srd # w tym razie robimy ramkę do zrenderowania w częśći „ramki ze słownika”
      rf = Ramka.find( srd[:ramka_id] )
      @ramka_dup = [rf.ramka, srd[:ramka_id], srd[:elipsy], srd[:frazyluzne],
                    rf.orig_id, srd[:sensczas_ok], srd[:zdduplices], srd[:sloduplices]
                   ]
      
      ##      session[:ramka_dup] = {
      ##        :ramka_id => sloid, :elipsy => elipsy, :frazyluzne => frazyluzne,
      ##        :sloduplices => sloduplices, :zdduplices => zdduplices }
      #
      # ram, ramka_id, elipsy, frazyluzne, orid, sensczas_ok, 
      ##     zdduplices, sloduplices = ram     
    end
  end # of #zrob_ramke_dup


  def raiseifzero( obj, message )
    raise message if ( not obj ) or obj == 0
  end  # of raiseifzero


  def prośby_toggle( które, val )
    h = { :odebrania_bp_pokaz => nil, 
      :nowa_segmentacja_pokaz => nil}
    h[ które ] = val
    h.each_pair{ |k, v|    session[ k ] = v }
  end


  def refresh_prośby( czy_liste_transz=nil )
    render :update do |page| 
##      page.replace_html( 'flash_notice',  :partial => '/layouts/notice' )
      page.replace_html( 'prosby_anotatorek',  :partial => 'prosby_anotatorek' )
      if czy_liste_transz
        page.replace_html( 'wsze_transze_otwarte',  :partial => 'wsze_transze_otwarte' )
      end
    end # of #**render do |page|*
  end# of #refresh_prośby

  def render_prośby
    render :partial => 'prosby_anotatorek'
  end# of #render_prośby



  def komentarz_toggle( val )
    session[ :komentarz_dodaj ] = val
    render :update do |page| 
      page.replace_html( 
                        'komentarz_dodaj', 
                        :partial => 'komentarz_dodaj', 
                        :object => [AkapitTranszy.find(params[:id]), params[:odrzuc]]
                      )
    end
  end

end # of class

### Local Variables: 
### mode: ruby
### End:
