 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

require 'ramkowanie'

class DebugController < ApplicationController
  layout 'admin'

  before_filter :authorize
  before_filter :update_activity_time

  auto_complete_for :interpretacja, :reszta_tagu


  def debug
  end

  def create_dummies
    if AnoVersion.port == 8004
      Dummy1.create!( :tresc => "rekord utworzony #{Time.now}" )
      Dummy2.create!( :tresc => "rekord utworzony #{Time.now}" )
    end

    redirect_to :action => :debug
  end

  
  def elektroforeza
    @to_są_akapity = Zmienna4RadioButton.new
    @to_są_akapity.wartość = true
    @mają_być_transze = Zmienna4RadioButton.new
    @mają_być_transze.wartość = true
  end

  def znajdź_te_idy
    @lista211 = ( params[:lista_idow] && params[ :lista_idow ][ :lista ] )
    @between211 = false
    if @lista211 and @lista211 =~ /^ *(\d+ *, *)*(\d+)+$/ or 
        ( @between211 = ( @lista211 =~ /^ *between +\d+ +and +\d+ */i ) )
      
      @to_są_akapity = params[ :to_są_akapity ][ :wartość ].to_bool
      @mają_być_transze = params[ :mają_być_transze ][ :wartość ].to_bool

      render :update do |page| 
        if @mają_być_transze
          page.replace_html "lista_transz",
          :partial => "lista_transz" 
        else
          page.replace_html "lista_ścieżek",
          :partial => "lista_sciezek" 
        end # of transze or ścieżki
      end # of #{render}

    else 
      render :update do |page| 
        page.replace_html "lista_ścieżek",
        :partial => "mwa_ha_ha", :object => "ta specyfikacja akapitów jest niepoprawna"

      end # of #{render}'s block


    end # of if
  end

end
