 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class ZarzadcaController < ApplicationController

  layout "admin"

  before_filter :authorize
  before_filter :update_activity_time, :except => :session_expiry
  before_filter :check_zarzadca


  def lista_anotatorow
    @wszyscy_anotatorzy = Uzytkownik.find(
                                          :all, 
                                          :order => :login, 
                                          :conditions =>{:rola_id => Rola.rid(:anotator)}
                                          )
  end

  def odbierz_transze
    @transza=TranszaAuto.find(params[:id])
    @anotator=Uzytkownik.find(params[:anotator])
    if request.post?
      if @transza.uzytkownik_id == @anotator.uzytkownik_id
        @transza.uzytkownik_id=nil
        @transza.save
        flash[:notice]= "Odebrałam transzę #{@transza.transza_auto_id} " +
          "anotatorowi #{@anotator.login}."
      else
      flash[:notice] = "Próba odebrania transzy #{@transza.transza_auto_id} " +
          "uzytkownikowi #{@anotator.login} nie powiodła się."
      end
      redirect_to (:action => "lista_anotatorow")
    end
  end


end
