 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

module AnotacjaHelper

  
  def akat_edytowalny?( poziom=nil, akat=nil, lewy=true )
    if lewy or r_zarzadca?
      uzid = session[ :uzid ]
      akat ||= AkapitTranszy.find( session[ :akat ] || params[ :akat ] )
      if poziom 
        return akat.poziomy_dostępne( 
                                     session[ :rola_id ], 
                                     ##                                     :segmentation_specjalnie => true,
                                     # zmienione na wyraźne życzenie AP 2009/7/28
                                     :jak_anotator => session[:jak_anotator],
                                     :poziomy_pokaźne => session[ :poziomy ]).
          include?( poziom ) 
      else # #{not poziom} — patrzymy na duży Status
        status = ( session[ :status ] || akat.status )
        
        if Rola.anotator?( session[ :rola_id ] )
          wynik = (AkapitTranszy.editable_par_annoteur?( status ))
          if session[ :anotator ]
            return((session[:anotator] == uzid) and wynik)
          else return wynik
          end
        elsif Rola.zarzadca?( session[:rola_id]) 
          return true
        else return false
        end # of #{if Rola.anotator?}
        
      end# of #{if poziom}
      
    else # #{not lewy or super}
      return false
    end # of #{if lewy}
    
  end# of #akat_edytowalny?

  # Ale dlaczego mamy test edytowalności w dwóch miejscach: tu i~w \file{application.rb}, #check_edytowalny ?
  # Ten jest taki wstępny, żeby coś wyświetlić lub nie.
  # Ten w #check_edytowalny wykonuje się przed konkretnymi działaniami.

  def znak_zatwierdź_tę
    "&#9745;"
  end


  def akat_proszalny_segmentnie?
    akat ||= AkapitTranszy.find( session[ :akat ] || params[ :akat ] )
    akat.ma_status?( :morphosyntactic, :<=, :po_poprawce )
  end # of #akat_proszalny_segmentnie?
  

  
end# of module

### Local Variables: 
### mode: ruby
### End:
