# == Schema Information
# Schema version: 51
#
# Table name: cz_m_leksem
#
#  cz_m_leksem_id :integer         primary key
#  lemat          :text            not null
#  xmlid          :text            not null
#  cz_m_id        :integer         not null
#  created_at     :timestamp       
#  updated_at     :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

require 'ramkowanie'

class CzMLeksem < ActiveRecord::Base
  has_many :sensy, :order => :xmlid
  belongs_to :interpretacja
  belongs_to :cz_m

  
  def self.przypisz_leksemom_i_interpretacjom
    ##    puts Time.now.to_s( :db )
    ##    self.pragmas_for_update

    CzM.przypisz_leksemom

    join186 = " leksem inner join interpretacja i186 using( leksem_id )" 
      
    self.connection.execute " create temporary view interp_leksem186 as "  + 
      " select interpretacja_id, lemat, cz_m_id from " + join186
      
    # #{puts "temp view created"} — chwila
    namierzacz_czmleksemu = {
      Leksem  => " where czl.lemat=leksem.lemat and czl.cz_m_id=leksem.cz_m_id ",
      Interpretacja => " where czl.lemat=( " +
      " select lemat from interp_leksem186 where interpretacja_id=interpretacja.interpretacja_id) " +
      " and czl.cz_m_id=(" +
      " select cz_m_id from interp_leksem186 where interpretacja_id=interpretacja.interpretacja_id) " 
    }
    
    # patrzymy na max #updated_at rekordu, który ma przypisany nasz id
    [ Interpretacja, Leksem ].each { |model186|
      ##      puts model186.to_s
      
      model186.connection.execute( " update #{model186.table_name} set cz_m_leksem_id = " +
                                   "( select cz_m_leksem_id from cz_m_leksem czl " + 
                                   namierzacz_czmleksemu[ model186 ] +
                                   " ), updated_at=current_timestamp, cz_m_leksem_przypisany='t' " +
                                   " where cz_m_leksem_przypisany='f' ") # próba zastosowania wbudowanych konwersji (znak zapytania i~tablica) spowodowała segmentation fault error
    }# of each model

    self.connection.execute " drop view interp_leksem186 "
    ##    self.pragmas_normal
    ##    puts Time.now.to_s( :db )
    true
  end# of #self.przypisz_się_leksemom_i_interpretacjom

  
  def self.dopisz_inne
    bezinne = self.find( :all, :conditions => 
                         "not exists (select * from sensy s where s.cz_m_leksem_id = " +
                         " cz_m_leksem.cz_m_leksem_id and s.xmlid like '%.inne') "
                         )
    if bezinne[0]
      ##      pragmas_for_update
      bezinne.each { |czml199|
        sen199 = czml199.sensy.create!(
                                       :cz_m_id => czml199.cz_m_id,
                                       :xmlid => czml199.lemat.odpolszcz + '.INNE',
                                       :n => 666666,
                                       :short_def => Sensy::INNE_short,
                                       :long_def_xml => Sensy::INNE_long,
                                       :long_def_html => Sensy::INNE_long_html
                                       ) 
      }
      
      ##      pragmas_normal
      return true
    else
      return false
    end
    ## bezinne[0] != nil
    end # of #self.dopisz_inne
    


end
