# == Schema Information
# Schema version: 51
#
# Table name: klasa_gram
#
#  klasa_gram_id    :integer         primary key
#  cz_m_id          :integer         
#  klasa_gram_nazwa :text            
#  klasa_gram_ozn   :text            
#  klasa_sem        :text            
#  created_at       :timestamp       
#  updated_at       :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class KlasaGram < ActiveRecord::Base
  belongs_to :cz_m

  def self.zsynchronizuj_z_tagsetem
    Tagset.find( :first )
    esquelle = "select lewe from tagset t left join klasa_gram k on t.lewe=k.klasa_gram_ozn  where t.typ='pos' and k.klasa_gram_ozn is null "
    if self.find_by_sql( esquelle )[0]
      self.connection.execute " insert into klasa_gram(  created_at, klasa_gram_ozn ) " + esquelle.sub( "select", "select current_timestamp, " )
    end
    
  end # of #{self.zsynchronizuj_z_tagsetem}

  zsynchronizuj_z_tagsetem

  INTERP = 'interp'

  @@nulla = nil

  def self.nulla
    unless @@nulla
      unless @@nulla = self.find( :first, :conditions => "klasa_gram_ozn is null" )
        @@nulla = self.create!( {
                                 :cz_m_id   => nil,
                                 :klasa_gram_nazwa => nil,
                                 :klasa_gram_ozn  => nil,
                                 :klasa_sem => nil })
      end # of the most inner #unless
    end # of the less inner #unless
    
    @@nulla
  end

  @@ignota = nil
  def self.ignota
    unless @@ignota = self.find( :first, :conditions => {:klasa_gram_ozn =>'ign'} )
      @@ignota = self.create!( {
                                :cz_m_id   => nil,
                                :klasa_gram_nazwa => "ignota",
                                :klasa_gram_ozn  => "ign",
                                :klasa_sem => nil
                              } )
    end # of #unless
    
    @@ignota
  end # of #{self.ignota}

  
  def self.kgs
    unless defined?(@@kgs)
      kgs = self.find(:all, :include => :cz_m)
      @@kgs = Hash.new
      kgs.each{|k|
        @@kgs[k.klasa_gram_id] = [
                                  k.klasa_gram_ozn, 
                                  if k.cz_m : k.cz_m.cz_m_nazwa ; else "" end
                                 ]
      }
    end
    return @@kgs
  end # of self.kgs


end # of class
