# == Schema Information
# Schema version: 51
#
# Table name: komentarz
#
#  komentarz_id         :integer         primary key
#  akapit_id            :integer         
#  uzytkownik_id        :integer         
#  akapit_transzy_id    :integer         
#  przyczyna_odrzucenia :integer         default(0)
#  tresc                :text            
#  nowy                 :boolean         default(TRUE)
#  created_at           :timestamp       
#  updated_at           :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class Komentarz < ActiveRecord::Base
  belongs_to :akapit
  belongs_to :uzytkownik
  belongs_to :akapit_transzy


  PO = {
    1 => "Błędne granice zdania",
    2 => "Błędny opis morfologiczny",
    3 => "Fraza nieciągła i synh &#8800; semh",
    4 => "Błędna klas. fleksyjna czasownika z transzy",
    5 => "Inne",
    0 => ""  }

  PO_select = [ # ["(zd. OK)", 0],
               ["złe granice zdania", 1],
               ["zły opis morfologiczny", 2],
               ["fraza nieciągła, synh≠semh", 3],
               ["zła klasyfikacja czasownika", 4],
               ["inne", 5] ]


  def przyczyna
    PO[self.przyczyna_odrzucenia]
  end


  def self.ile
    self.find_by_sql( "select count(*) as ile from komentarz")[0].ile.to_i
  end # of #self.ile

  
  def self.ile_akapitów
    self.find_by_sql( "select count( distinct akapit_id ) as ile from komentarz")[0].ile.to_i
  end # of #self.ile


end


### Local Variables: 
### mode: ruby
### End:
