# == Schema Information
# Schema version: 51
#
# Table name: koniec_zdania_anot
#
#  koniec_zdania_anot_id :integer         primary key
#  akapit_id             :integer         not null
#  akapit_transzy_id     :integer         not null
#  uzytkownik_id         :integer         not null
#  token_id              :integer         not null
#  created_at            :timestamp       
#  updated_at            :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class KoniecZdaniaAnot < ActiveRecord::Base
  belongs_to :akapit_transzy
  belongs_to :akapit
  belongs_to :token

  def self.znajdz( akat, token )
    self.find( :first, :conditions => {
                 :akapit_transzy_id => akat,
                 :token_id => token
               })
  end # of #{self.znajdz}

  
  def bliźniaczy
    @bli_hasz = {
      :akapit_id => self.akapit_id,
      :akapit_transzy_id => self.akapit_transzy.blizniaczy_id,
      :token_id => self.token_id
    }
    self.class.find( :first, :conditions => @bli_hasz )
  end # of #bliźniaczy

  
  def zniszcz_oba
    if bli = self.bliźniaczy : bli.destroy
    end
    self.destroy
  end

  def self.zrób_oba( hasz )
    hasz_inicjalny = {
      :akapit_id => hasz[:akat].akapit_id,
      :akapit_transzy_id => hasz[:akat].akapit_transzy_id,
      :uzytkownik_id => hasz[:uzytkownik_id],
      :token_id => hasz[:token_id]}
    
    unless self.znajdz( hasz[:akat], hasz[:token_id] ) 
      self.create( hasz_inicjalny )
    end
    unless self.znajdz( ( abli = hasz[:akat].blizniaczy_id ) , hasz[:token_id] )
      self.create( 
                hasz_inicjalny.update({ :akapit_transzy_id => abli })
                )
    end
  end #   of #{self.zrób_oba}



  
end
