# == Schema Information
# Schema version: 51
#
# Table name: leksem
#
#  leksem_id              :integer         primary key
#  lex_xmlid              :text            not null
#  path_id                :integer         not null
#  lemat                  :text            
#  klasa_gram_id          :integer         
#  cz_m_id                :integer         
#  cz_m_leksem_id         :integer         
#  created_at             :timestamp       
#  updated_at             :timestamp       
#  cz_m_przypisana        :boolean         
#  cz_m_leksem_przypisany :boolean         
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

# to jest tabela pierwszych instancji danego lex-a w poszczególnych plikach ann_….
# lex_xmlid powinien być brany z tabeli interpretacja (i tak jest w exml.rb).
# w zasadzie należałoby utworzyć pośrednią tabelę lex między leksem a interpretacja.
# Miałaby ona unikalne lex_xmlid-y w obrębie danej ścieżki.

require 'ramkowanie'

class Leksem < ActiveRecord::Base
  belongs_to :klasa_gram

  belongs_to :cz_m_leksem
  belongs_to :cz_m


  def sensy_sensemu
    # Raczej nierelewantne — w \ac{NKJP} operujemy zawsze częścią mowy.
    SensySensemu.find(:all,
                      :conditions =>{
                        :lemat => self.lemat, :klasa_sem => self.klasa_gram.klasa_sem})
  end# of #{sensy_sensemu}

  # Zdarzają się tokeny bez żadnej interpretacji, a~zd
  @@nullus = nil

  def self.nullus
    unless @@nullus
      unless  @@nullus = self.find( :first, :conditions => { :lemat => '' } )
        @@nullus = self.create( {
                                  :lex_xmlid => '0.0.0',
                                  :path_id => Path.dummy,
                                  :lemat => '',
                                  :klasa_gram_id => KlasaGram.nulla
                                } )                                  
      end # of the most inner #unless
    end # of the less inner #unless
    @@nullus
  end

  @@nulli_et_ignoti = nil

  def self.nulli_et_ignoti
    unless @@nulli_et_ignoti
      # nie występuje problem odświeżania, bo  po wlaniu danych do bazy nowe 'ign'-y mają nie móc być dodane.
      @@nulli_et_ignoti = self.find( :all, 
                                     :conditions => " klasa_gram_id in (#{KlasaGram.nulla.id}, #{KlasaGram.ignota.id})" )
    end
    @@nulli_et_ignoti
  end # of #{self.nulli_et_ignoti}

  @@inei = nulli_et_ignoti.collect{ |inus| inus.id }

  def self.idi_nulli_et_ignoti
    @@inei
  end # of #{self.idi_nulli_et_ignoti}


end # of class
