# == Schema Information
# Schema version: 51
#
# Table name: path
#
#  path_id    :integer         primary key
#  path_text  :text            not null
#  created_at :timestamp       
#  updated_at :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class Path < ActiveRecord::Base
  has_many :morph, :foreign_key => "path_text"
  has_many :akapit
  
  @@dummy = nil

  def self.dummy
    unless @@dummy
      unless @@dummy = self.find( :first, :conditions => { :path_id => -1 } ) # bo #{find( -1)} podnosi krzyk, gdy nie ma
        self.connection.execute "insert into path(  created_at, path_id, path_text ) values( current_timestamp, -1, 'created_automatically_for_Interpretacja_and_Leksem')"
      end # of inner #unless
    end # of main #unless
    @@dummy ||= @@dummy = self.find( -1 ) 
    # bo jeśli dummy jest, to drugie (wewn.) unless będzie fałszywe i~zwróci nil.
  end # of #self.dummy

  
  def akapit_range
    min199 = self.akapit.minimum( :akapit_id )
    max199 = self.akapit.maximum( :akapit_id )
    if min199 and max199
      min199..max199
    else
      nil
    end
  end



end
