# == Schema Information
# Schema version: 51
#
# Table name: protokol
#
#  protokol_id     :integer         primary key
#  poziom          :text            not null
#  akapit_id       :integer         not null
#  czy_rozbieznosc :boolean         default(TRUE), not null
#  czy_superancja  :boolean         not null
#  created_at      :timestamp       
#  updated_at      :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class Protokol < ActiveRecord::Base

# Uwaga. Są w~bazie rekordy bez powiązanych punktów protokołu. Znaczy to, że weryfikacja, której dotyczą, przebiegła pomyślnie (nie było żadnej rozbieżności do zaprotokołowania).

  has_many :punkt_protokolu, 
  :order => "elt_protokol_type, elt_protokol_id",
  :dependent => :delete_all
  serialize :poziom

  def self.zrób_się( akapit, poziom )
    self.create(
                   :poziom => poziom,
                   :akapit_id => akapit.id,
                   :czy_rozbieznosc => true             
                   )
  end # of {self.zrób_się}

  def build_ppr( akat, uzid=nil )
    self.punkt_protokolu.build(
                               :akapit_transzy_id  => akat.id,
                               :uzytkownik_id => ( uzid || akat.get_uzid )  )
  end # of #{build_ppr}
  
  def protokoluj_segmentation( akat, sg_choice, sg_variant, uzid=nil )
    ppr = build_ppr( akat, uzid )
    ppr.elt_protokol = SegmentationRozbieznosc.new(
                                                   :sg_choice_id  => sg_choice.id,
                                                   :sg_variant_id => sg_variant.id
                                                   )
    ppr.save!
  end # of #{protokoluj_segmentation}.


  def protokoluj_sentences( akat, tok, uzid=nil )
    ppr =  build_ppr( akat, uzid )
    ppr.elt_protokol = SentencesRozbieznosc.new(
                                                :token_id  => tok.id,
                                                :czy_konczy_zdanie => (
                                                                       if KoniecZdaniaAnot.znajdz( akat, tok ) 
                                                                         true
                                                                       else false
                                                                       end
                                                                       )
                                                )
    ppr.save!
  end # of #{protokoluj_sentences}

  
  def protokoluj_morphosyntactic( akat, tok, disa, uzid=nil )
    ppr = build_ppr( akat, uzid )

    if disa
      ppr.elt_protokol = MorphosyntacticRozbieznosc.new(
                                                        :token_id => disa.token_id,
                                                        :interpretacja_id => disa.id,
                                                        :reszta_tagu => disa.reszta_tagu,
                                                        :leksem_id => disa.leksem_id)
    else
      ppr.elt_protokol_nil
      logger.info "@@@@@ null disambiguation for token »#{tok.orth}« #{tok.id} in akapit_transzy #{akat.id}"
    end
    
    ppr.save!
  end # of #{self.protokoluj_morphosyntactic}.


  def protokoluj_word_senses( akat, tok, sens, uzid=nil )
    ppr =  build_ppr( akat, uzid )
    ppr.elt_protokol = WordSensesRozbieznosc.new(
                                                 :token_id  => tok.id,
                                                 :sensy_id => sens.id
                                                 )
    ppr.save!
  end # of #{protokoluj_sentences}




  
  def self.superancje( poziom, akat, uzid )
    ak = akat.akapit
    
    v = ak.superancje[ poziom ]
    # dostajemy hasz indeksowany poziomami, którego wartości to tablice tokenów
    if v
      pr = self.create(
                       :poziom => poziom,
                       :akapit_id => ak.id,
                       :czy_rozbieznosc => false,
                       :czy_superancja => true
                       )
      
      case poziom
      when :segmentation
        ##                     sg_choice, sg_variant, uzid=nil
        params = v.collect { |tok|
          [tok.sg_choice_id, tok.sg_variant_id]          if tok.chosen?
        }.compact.uniq
        params.each{ |par| 
          pr.protokoluj_segmentation( akat, par[0], par[1], uzid )
        }
      when :sentences
        #    :sentences:                           akat, tok, uzid=nil
        v.each{ |tok|          pr.protokoluj_sentences( akat, tok, uzid ) }
        
      when :morphosyntactic
        # :morphosyntactic:              akat, tok, disa, uzid=nil
        v.each{ |tok| 
          pr.protokoluj_morphosyntactic(
                                        akat, tok, tok.disambs( akat.akat_hash )[0], uzid )
          
        }
      when :word_senses
        v.each{ |tok| 
          pr.protokoluj_word_senses(
                                    akat, tok, tok.sensy( akat.akat_hash )[0], uzid )
        }
      else
        raise "Protokol.superancje: unhandled poziom #{poziom.inspect}"
      end
    end # of #{if v}
    
  end # of #{superancje}
    


end# of class


### Local Variables: 
### mode: ruby
### End:
