# == Schema Information
# Schema version: 51
#
# Table name: rola
#
#  opis       :text            
#  rola_id    :integer         primary key
#  opis_kr    :string          
#  created_at :timestamp       
#  updated_at :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

load 'interpretacja_anot.rb'
load 'sens_anot.rb'
# bo krzyczało "Expected interpretacja_anot to define InterpretacjaAnot"

class Rola < ActiveRecord::Base

  has_many :uzytkownik

  ROLE={
    :zablokowany => {:rola_id => 0, :opis => "zablokowany", :opis_kr => "zablokowany"}.freeze,
    :gosc =>                {:rola_id => 1, :opis => "gość (widzi uzgodnione)", :opis_kr => "gość"}.freeze,
    :audytor =>          {:rola_id => 2, :opis => "audytor (widzi wszystko)", :opis_kr => "audytor"}.freeze,
    :anotator =>        {:rola_id => 4, :opis => "anotator", :opis_kr => "anotator"}.freeze,
    :zarzadca =>       {:rola_id => 8, :opis => "superanotator (jego anotacja zawsze będzie zatwierdzona i ostateczna)", :opis_kr => "superanotator"}.freeze,
    :admin =>             {:rola_id => 16, :opis => "administrator (informatyczny)", :opis_kr => "admin"}.freeze
  }.freeze

  
  @@nazwy_ról = {}

  ROLE.each_pair { |k206, v206|
    @@nazwy_ról[ v206[:rola_id] ] = v206[:opis_kr]
  }
  
  
  def self.zrob_sie
    unless self.find( :first )
      ROLE.each_pair { |key128, val128|
        self.connection.execute "insert into rola ( created_at, rola_id, opis, opis_kr) " +
                                 " values(  current_timestamp, #{val128[:rola_id]}, '#{val128[:opis]}', '#{val128[:opis_kr]}' )"
        # pierwsze podejście, #{self.create( val )}, powodowało, że zadane przeze Mnie idy były ignorowane.
      }
    end
  end # of #{self.zrob_sie}.

  zrob_sie unless self.find( :first )
  
  def self.rid( rola )
    ROLE[rola][:rola_id]
  end


  def self.usuwalny?( uzytkownik )
    # Mówi, czy można użytkownika z taką rolą usunąć, czy tylko zablokować.
    # Nie usuniemy audytora, który pozostawił jakiś komentarz ani anotatora, który coś zweryfikował,
    # ani zarządcy, jeśli są akapity osądzane bądź osądzone.
    if no_record?(:komentarz, uzytkownik) and
        ((not uzytkownik.ktoras_z_rol?(:anotator, :zarzadca, :zablokowany))  or
         (no_record?(:akapit_transzy, uzytkownik) and
          no_record?(:statusy, uzytkownik ) and
          no_record?(:interpretacja_anot, uzytkownik) and
          no_record?(:sens_anot, uzytkownik))) and
        ((not uzytkownik.ktoras_z_rol?(:zarzadca, :zablokowany)) or 
         AkapitTranszy.find_by_sql(
                                   ["select * from akapit_transzy where status=? or status=?",
                                    AkapitTranszy::STATI[:osądzony], 
                                    AkapitTranszy::STATI[:osądzany]]).size == 0)  
      return true 
    else return false
    end
  end # of #{self.usuwalny?}


  def self.admin?(rola_id)
    self.rola?(rola_id, :admin)
  end


  def self.zarzadca?( rola_id )
    self.rola?(rola_id, :zarzadca)
  end


  def self.anotator?( rola_id )
    self.rola?( rola_id, :anotator )
  end


  def self.audytor?(rola_id)
    self.rola?(rola_id, :audytor)
  end

  
  def self.wszewid?( rola_id )
    # audytor lub zarządca: ma prawo oglądać wszystko i dodawać komentarze
    return  ( self.rola?(rola_id, :audytor) or self.rola?(rola_id, :zarzadca) )
  end

  def self.gosc?(rola_id)
    return self.rola?( rola_id, :gosc )
  end


  def self.rola?(rola_id, rola_symb)
    # czy dany identyfikator roli odpowiada danemu symbolowi roli
    if rola_id & self.rid(rola_symb) == 0
      return false
    else
      return true
    end
  end


  def self.ktoras_z_rol?( uzytkownik, *lista_rol )
    # chcemy wołać tę metodę dla ( użytkownik, [:rola1, :rola2, ...] )
    # drugi argument może też być pojedynczym symbolem roli.
    # gdzie uzytkownik może być Uzytkownik-iem lub idem Uzytkownika.

    uzytkownik=Uzytkownik.find(uzytkownik) if uzytkownik.kind_of?( Integer )
    lista_rol = [lista_rol]  unless lista_rol.kind_of?( Array )

    r_c = lista_rol.collect{ |r128|
      if Rola.rola?(uzytkownik.rola_id, r128) :  1
      else nil
      end      }.compact
    return( r_c.size > 0 )
  end # of #{self.ktoras_z_rol?}.

  
  def self.nazwa_roli( rola_id )
    @@nazwy_ról[ rola_id ]
  end


  private
  
  def self.no_record?(tab_symb, uzytkownik)
    uzytkownik.no_record?( tab_symb )
  end
  



end # of class


### Local Variables: 
### mode: ruby
### End:
