# == Schema Information
# Schema version: 51
#
# Table name: sens_anot
#
#  sens_anot_id      :integer         primary key
#  uzytkownik_id     :integer         
#  akapit_transzy_id :integer         not null
#  token_id          :integer         not null
#  interpretacja_id  :integer         not null
#  sensy_id          :integer         not null
#  automatycznie     :boolean         
#  created_at        :timestamp       
#  updated_at        :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class SensAnot < ActiveRecord::Base
  belongs_to :uzytkownik
  belongs_to :interpretacja
  ##  belongs_to :sensy_leksemu, :counter_cache => true
  # counter cache chce pluralizować, więc dodałem do inflektora regułę,
  # że „sens” i „anot” są niepoliczalne
  belongs_to :akapit_transzy
  belongs_to :sensy

  def self.znajdz( tokid, param )
    if param.kind_of?( Integer )
      phash = { :akapit_transzy_id => param }
    elsif param.kind_of?( Hash )
      phash = param.dup
    end
    phash[:token_id] = tokid

    self.find( :first,
              :conditions => phash)
  end

end



### Local Variables: 
### mode: ruby
### End:
