# == Schema Information
# Schema version: 51
#
# Table name: sg_variant
#
#  sg_variant_id :integer         primary key
#  sg_choice_id  :integer         not null
#  xmlid         :text            
#  dodany        :boolean         
#  created_at    :timestamp       
#  updated_at    :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

require 'ramkowanie'


class SgVariant < ActiveRecord::Base
  belongs_to :sg_choice
  has_many :token, :order => :kolejnosc
  has_many :sg_variant_anot

  include XpointerCreator

  @tokids = nil

  def tokids
    unless @tokids
      @tokids = self.token.collect{ |t| t.id }
    end
    @tokids
  end


  def równoległy_oryginalny
    unless self.token[0].dodany?
      # fajnie byłoby przechowywać informację o pochodzeniu tokenów w naszej kolumnie, ale ciężko znaleźć miejsce/a, w których taką informację byłoby wygodnie wpisać: w momencie tworzenia nowego wariantu zwykle jeszcze nie ma on tokenów.
      self
    else
      self.class.find( :first, :conditions =>
                       " sg_choice_id=#{self.sg_choice_id} and " +
                       " ( select dodany from token where " +
                       " token.sg_variant_id=sg_variant.sg_variant_id )='f' "
                       )
    end
  end # of #{równoległy_oryginalny}


  def popraw_xpointers
    if self.token[0].dodany? and self.token[0].chosen?
      # poprawiać jest sens jedynie xpointery wariantów dodanych.
      # ograniczam też do wariantów z tokenami wybranymi, bo tylko one się liczą dla wypluwki.
      orths_list = self.token.collect { |t223| t223.orth }
puts self.token.collect { |t223| t223.id }.join( ' ' )
      tokens_list = self.równoległy_oryginalny.token
      xpo = create_xpointers( orths_list, tokens_list )
      sto = self.token
      xpo.each_index { |i223|
        if        ( old_xpo = sto[ i223 ].xpointer ) != xpo[ i223 ]
          sto[ i223 ].xpointer = xpo[ i223 ]
          sto[ i223 ].save!
          puts "#{sto[i223].id} było #{old_xpo} jest #{xpo[i223]}"
        end
      }
    end
  end # of #{popraw_xpointers}

  
  def self.popraw_xpointers( ids )
    [    self.find( ids ) ].flatten.each { |sgv223|
      sgv223.popraw_xpointers
    }
  end


  def self.tokododane
    self.find( :all, :conditions =>
               " exists (select * from token where " +
               " sg_variant_id=sg_variant.sg_variant_id and " +
               " dodany='t' and chosen='t' )"
               )
  end # of #{self.tokododane}


  def self.sprawdź_xpointer( id, oryginalny=nil )
    if oryginalny
      sgv = self.find( id ).równoległy_oryginalny
    else
      sgv = self.find( id )
    end
    Token.sprawdź_xpointer( sgv.token[0].id )
  end

end # of class
