# == Schema Information
# Schema version: 51
#
# Table name: sg_variant_anot
#
#  sg_variant_anot_id :integer         primary key
#  sg_choice_id       :integer         not null
#  sg_variant_id      :integer         not null
#  chosen             :boolean         not null
#  akapit_transzy_id  :integer         not null
#  uzytkownik_id      :integer         
#  created_at         :timestamp       
#  updated_at         :timestamp       
#

 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class SgVariantAnot < ActiveRecord::Base

  belongs_to :akapit_transzy
  belongs_to :sg_choice
  belongs_to :sg_variant
  
  def token
    self.sg_variant.token
  end

  ##  def self.znajdz( tokid, akat_id )
  ##    self.find( :first, :conditions => {:token_id => tokid, :akapit_transzy_id => akat_id })    
  ##  end

  def bliźniaczy
    @bli_hasz = { 
      :sg_variant_id => self.sg_variant_id,
      :akapit_transzy_id => self.akapit_transzy.blizniaczy_id
    }
    self.class.find( :first, :conditions => @bli_hasz )
  end # of #bliźniaczy

  def skopiuj_na_bliźniaczy
    bli = self.bliźniaczy # ta met. tworzy #@bli_hasz
    bli ||= self.class.new( @bli_hasz )  
    bli.sg_choice_id = self.sg_choice_id
    bli.chosen = self.chosen
    bli.uzytkownik_id= self.uzytkownik_id
    bli.save!
  end # of #skopiuj_na_bliźniaczy

end


### Local Variables: 
### mode: ruby
### End:
