 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

# anotatornia
#
# Be sure to restart your web server when you modify this file.

# Uncomment below to force Rails into production mode when 
# you don't control web/app server and can't set it the proper way
# ENV['RAILS_ENV'] ||= 'production'

# Specifies gem version of Rails to use when vendor/rails is not present
RAILS_GEM_VERSION = '1.2.4' unless defined? RAILS_GEM_VERSION

# Bootstrap the Rails environment, frameworks, and default configuration
require File.join(File.dirname(__FILE__), 'boot')

Rails::Initializer.run do |config|
  # Settings in config/environments/* take precedence over those specified here
  
  # Skip frameworks you're not going to use (only works if using vendor/rails)
  # config.frameworks -= [ :action_web_service, :action_mailer ]

  # Only load the plugins named here, by default all plugins in vendor/plugins are loaded
  # config.plugins = %W( exception_notification ssl_requirement )

  # Add additional load paths for your own custom dirs
  # config.load_paths += %W( #{RAILS_ROOT}/extras )

  # Force all environments to use the same logger level 
  # (by default production uses :info, the others :debug)
  # config.log_level = :debug
  config.log_level = :info


  # Use the database for sessions instead of the file system
  # (create the session table with 'rake db:sessions:create')
  #  config.action_controller.session_store = :active_record_store

  # Use SQL instead of Active Record's schema dumper when creating the test database.
  # This is necessary if your schema can't be completely dumped by the schema dumper, 
  # like if you have constraints or database-specific column types
  config.active_record.schema_format = :sql
  config.active_record.record_timestamps = :sql

  # Activate observers that should always be running
  # config.active_record.observers = :cacher, :garbage_collector

  # Make Active Record use UTC-base instead of local time
  config.active_record.default_timezone = :utc
  
  # See Rails::Configuration for more options
end

# Add new inflection rules using the following format 
# (all these examples are active by default):
Inflector.inflections do |inflect|
#   inflect.plural /^(ox)$/i, '\1en'
#   inflect.singular /^(ox)en/i, '\1'
#   inflect.irregular 'person', 'people'
#   inflect.uncountable %w( fish sheep )
  #  inflect.uncountable %w( anot sens )
  inflect.irregular 'anot', 'anot'
  # żeby działał sens_anot_count cache
end

# Add new mime types for use in respond_to blocks:
# Mime::Type.register "text/richtext", :rtf
# Mime::Type.register "application/x-mobile", :mobile

# Include your application configuration below

ActiveRecord::Base.pluralize_table_names = false
ActiveRecord::Base.primary_key_prefix_type = :table_name_with_underscore

ActiveRecord::Errors.default_error_messages = {
  :inclusion => "nie figuruje na liście", #"is not included in the list" ,
  :exclusion => "jest zastrzeżony", # "is reserved" ,
  :invalid => "jest nieprawidłowy", # "is invalid" ,
  :confirmation => "nie zgadza się z potwierdzeniem", #"doesn't match confirmation" ,
  :accepted => "musi być zaakceptowany", #"must be accepted" ,
  :empty => "nie może być puste", # "can't be empty" ,
  :blank => "nie może pozostać niewypełnione", #"can't be blank" ,
  :too_long => "jest zbyt długie (max. %d znak/i/ów)", # "is too long (maximum is %d characters)" ,
  :too_short => "jest zbyt krótkie (min. %d znak/i/ów)",#"is too short (minimum is %d characters)" ,
  :wrong_length => "ma niewłaściwą długość (powinno być %d znak/i/ów)", #"is the wrong length (should be %d characters)" ,
  :taken => "już jest w użyciu", # "has already been taken" ,
  :not_a_number => "nie jest liczbą" #"is not a number"
}


class AnoVersion

  def self.nkjp?
    File.exists?( 'bazy-bk-2009-08-22-2037.tar.bz2' ) ||
      File.exists?( '../anotatornia-trash/bazy-bk-2009-08-22-2037.tar.bz2' )
  end

end # of #{class AnoVersion}. Further tests are defined in particular env. files., e.g. \file{nk8003.rb}.
