 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class AddSensowe < ActiveRecord::Migration

  extend MigrationHelper
  
  
  def self.up
    sth_done = 
      addcolumn 'interpretacja', 'cz_m_leksem_id', 'integer' 
    addcolumn 'interpretacja', 'sensy_id', 'integer' 
    
    addcolumn  'leksem', 'cz_m_leksem_id',  'integer'

    unless Interpretacja.find( :first, :conditions => "sensy_id is not null" ) or
        ( tables.include?( "sens_anot" ) and SensAnot.find( :first ) )
      droptable :cz_m
      droptable :sensy
      droptable :sens_anot
      droptable :cz_m_leksem
    end

    execute "CREATE TABLE IF NOT EXISTS cz_m(
-- Attributes --
cz_m_id integer primary key autoincrement,
cz_m_ozn text, 
created_at timestamp,
updated_at timestamp);"

    execute "CREATE TABLE IF NOT EXISTS sensy(
-- Attributes --
   sensy_id integer primary key autoincrement,
   cz_m_id integer not null,
   cz_m_leksem_id integer not null, 
   xmlid text,
   n integer, -- przy wlewie sprawdzamy czy lemat.odpolszcz.n == xmlid
   short_def text,
   long_def_xml text,
   long_def_html text,
   created_at timestamp,
   updated_at timestamp
);"
    
    addindex :sensy, :cz_m_id
    addindex :sensy, :xmlid, :unique

    execute "CREATE TABLE IF NOT EXISTS sens_anot(
-- Attributes --
   sens_anot_id integer primary key autoincrement,
   uzytkownik_id integer,
   akapit_transzy_id integer not null,
   interpretacja_id integer not null,
   sensy_id integer not null, 
   automatycznie boolean,
   created_at timestamp,
   updated_at timestamp);"

    addindex :sens_anot, :sensy_id
    addindex :sens_anot, :interpretacja_id
    addindex :sens_anot, [:interpretacja_id, :akapit_transzy_id]
    addindex :sens_anot, :akapit_transzy_id

    execute "CREATE TABLE IF NOT EXISTS cz_m_leksem(
-- Attributes --
cz_m_leksem_id integer primary key autoincrement,
lemat text not null,
xmlid text not null,
cz_m_id integer not null,
created_at timestamp,
updated_at timestamp);"
    
    addindex :cz_m_leksem, [:lemat, :cz_m_id], :unique
    addindex :cz_m_leksem, :xmlid, :unique
    
    execute "vacuum;"

    # zainicjować \sql{cz_m}
    if sth_done
      Tagset.zainicjuj( :force )
      KlasaGram.zsynchronizuj_z_tagsetem
      CzM.zainicjuj
    end

  end

  def self.down
  end
end
