 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class PoprawTokXpointers < ActiveRecord::Migration

  extend MigrationHelper

  def self.up

    addcolumn :nowa_segmentacja, :akapit_transzy_id, :integer
    addindex :nowa_segmentacja, :akapit_transzy_id

    addcolumn :nowa_segmentacja, :transza_id, :integer
    addindex  :nowa_segmentacja, :transza_id


tokproc = Proc.new {|t|
      puts "@@@@ t. #{t.id} »#{t.orth}« #{t.xpointer}"
      
      # sprawdzimy, czy nasz sg_choice ma \emph{jakiekolwiek} tokeny wybrane i~ew. poprawimy
      sgc = t.sg_choice
      sgct= sgc.token
      jest_wybrany = false
      sgct.each { |t0| if t0.chosen? : jest_wybrany = true end }

      unless jest_wybrany
        # jeśli wszystkie warianty oznaczyło jako odrzucone, to wybieramy ten, który ma najstarsze tokeny, co z~dobrym przybliżeniem odpowiada minimalnemu idowi.
        puts "#{t.id} »#{t.orth}«ma sg_choice cały odrzucony! Poprawiam"
  
        Token.find( sgc.tokids.min ).sg_variant.token.each {|t1|
          t1.chosen = true
          t1.save!
        }
      end
      
      tp = t.poprzedni
      md = /^(.*),(\d+),(\d+)\)$/.match( tp.xpointer )
      if md
        tp_od_znaku = md[ 2 ].to_i # #{$2}
        tp_ile_znaków = md[ 3 ].to_i # #{$3}
        t_od_znaku = tp_od_znaku + tp_ile_znaków + if t.ns_poprzedza? : 0 else 1 end
      
        t_ile_znaków = t.orth.jlength
      end
      
      t.xpointer = md[ 1 ].gsub( '–', '-') + ",#{t_od_znaku},#{t_ile_znaków})"
      t.save!
      puts "t. #{t.id} fixed to #{Token.find( t.id ).xpointer}"
    } # of tokproc

    if AnoVersion.port == 8003 and t169 =  Token.
        find( :first, :conditions => {:token_id => 169274} ) 
      tokproc.call( t169 )
    end
    
    Token.find( :all, :conditions => {:dodany => true}, :order => :kolejnosc ).each { |tok|
      tokproc.call( tok )
    }

    if AnoVersion.port == 8003
      ProsbyAnotatorek.find( :all, :conditions => { :prosby_anotatorek_id => [36, 100]} ).each {|pro|
        if pro.updated_at < '2009-07-28 0:00'.to_time
          pro.rozpatrzona = false
          pro.save!
        end
      }
    end #of if 8003
  end  # of #{self.up}


  def self.down
  end
end
