 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class AddDziubnijWSegmentacjach < ActiveRecord::Migration

  extend MigrationHelper

  def self.up
    pragmas_for_update
    
    if Time.now < '2009-07-29 03:37'.to_time
      idy = [1053, 1339, 1340, 1606, 1684]
    
      NowaSegmentacja.find_all.each { |ns|
        if (ns.ids & idy)[0]
          puts "@@@ ns #{ns.id}"
          puts ns.seg_is.inspect + " --> " + ns.seg_should_be.inspect
          ns.wprowadzona = false
          ncomm = ns.commit
          puts " wystąpiłam w ak. #{(ncomm && ncomm[:akids]).inspect} \n"
        end
      }


      atytr = AkapitTranszy.find( :all, :conditions => {:akapit_id => idy } )
      atytr.each {|akat|
        puts "@@@@ akapit #{akat.akapit_id}: atr #{akat.id}, tr #{akat.transza_id}"
        akat.set_status( :segmentation, :dopuszczony, :tylko_ten )
      }
      Akapit.find( idy ).each { |ak|
        ak.token_rejected.each { |t|
          t.chosen = true
          t.save!
        }
      }

    end
    pragmas_normal
  end

  def self.down
  end
end
