 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

class UspojnijPathId < ActiveRecord::Migration
  
  extend MigrationHelper
  
  def self.up
    kill_anotatorniæ_if_8003
    if Token.find_by_sql( "select count(*) as ile from token inner join akapit using( akapit_id ) where token.path_id<>akapit.path_id" )[0].ile.to_i != 0

      puts "038 niespójność ścieżek!"
      
      execute "update token set path_id=(select path_id from akapit where akapit_id=token.akapit_id) where path_id <> (select path_id from akapit where akapit_id=token.akapit_id)"
    end
    # powyższe szczęśliwie jest niepotrzebne: w tokenach się zgadza.
    
    # teraz poprawimy tokeny zweryfikowane bez dezambiguacji
    
    Token.find_by_sql( "select  token.*, akapit_id from statusy inner join token using(akapit_id) where chosen='t' and morphosyntactic>=16 and not exists ( select * from interpretacja where token_id=token.token_id and disamb='t')" ).each { |t200|
      # wersja SQLite'a czy też adaptera na Chopinie nie obsługuje nawiasowania joinów (nawiasowanie zakrywa nazwę tabeli)
      if ta200 = t200.akapit
        ta200.akat0.set_status( :morphosyntactic, :do_osądzenia )
      else
        puts "#{t200.id}: #{t200.orth} bez akapittu!"
        sleep 1
      end
    }
    
    if Interpretacja.find_by_sql( "select count(*) as ile from interpretacja inner join token using( token_id ) where token.path_id<>interpretacja.path_id" )[0].ile.to_i != 0
      
      InterpretacjaAnot.
        find_by_sql(
                    "select interpretacja_anot.*, akapit_transzy_id, interpretacja_id, interpretacja_anot.token_id " +
                    "  from " +
                    " statusy  inner join interpretacja_anot using( akapit_transzy_id) " + 
                    " inner join interpretacja using( interpretacja_id ) " +
                    " inner join token using( token_id ) " +
                    " where morphosyntactic>=16 and chosen='t' and disamb='f'" ).
        # jeśli jest interpretacja anot wskazująca w zatwierdzonym akapicie nie\dy dezambiguację, to ją przewskażemy:
        each { |ia200|
        t200 = ia200.token
        puts t200.id
        ia200.interpretacja_id = t200.the_disambiguation.id
        ia200.save!
      }

      execute "delete from interpretacja where dodana='t' and disamb='f' and " +
        " (not exists (select interpretacja_id from interpretacja_anot " +
        " where interpretacja_id=interpretacja.interpretacja_id )) and " +
        " (select count(*) from interpretacja i1 where leksem_id=interpretacja.leksem_id " +
        " and reszta_tagu=interpretacja.reszta_tagu and " +
        " token_id=interpretacja.token_id )>1 "
      
      execute  "update interpretacja set path_id=(select path_id from token where token_id=interpretacja.token_id) where path_id<>(select path_id from token where token_id=interpretacja.token_id)"
    end # of niezgodność ścieżki w tokenie ze ścieżką w interpretacji
    
    # poprawimy przypisanie „leksemów” do interpretacyj, czyli niezg. ścieżki w~leksemie ze ścieżką w~interpretacji

    Interpretacja.
      find_by_sql(
                  "select interpretacja.*, leksem_id  from leksem inner join interpretacja using( leksem_id ) where interpretacja.path_id<>leksem.path_id"
                  ).
      each { |int200|
      # schemat tej pętli pochodzi z metody #{Interpretacja.get_xmlids}.  
      path_id = int200.path_id
      le200 = int200.leksem

      puts "interpretacja #{int200.id}"

      unless le200 
        puts "int. #{int200.id} bez leksemu! (leksem_id=#{int200.leksem_id.inspect})"
        sleep 5
    
      else
             
        if le201 =  Leksem.find( :first, 
                                 :conditions => 
                                 { :lemat => le200.lemat,
                                   :klasa_gram_id => le200.klasa_gram_id,
                                   :path_id => path_id })
          
          puts "        leksem jest"
          int200.leksem_id = le201.id
          int200.save!
          
        else # nie ma takiego leksemu w tej ścieżce — to bierzemy z~innej ścieżki i~duplikujemy, przypisując odpowiedni xmlid. Jakiś jest na pewno: wszak został już kiedyś przypisany.
          puts "        nowy leksem"
          t200 = int200.token
          
          lex_xmlid201 = Interpretacja.get_xmlids(
                                                  t200.id,
                                                  le200.lemat,
                                                  le200.klasa_gram_id )[ 1 ]

          le201 = Leksem.create!(
                                 ##  :leksem_id => le200.leksem_id
                                 :lex_xmlid => lex_xmlid201,
                                 :path_id => path_id,
                                 :lemat => le200.lemat,
                                 :klasa_gram_id => le200.klasa_gram_id,
                                 :cz_m_id => le200.cz_m_id,
                                 :cz_m_leksem_id => le200.cz_m_leksem_id 
                                 )
          int200.leksem_id = le201.id
          int200.save!
        end    
      end # of ma leksem albo nie.
    } # of each trefe interpretacja
    
    if Leksem.find_by_sql( "select count(*) as ile from leksem inner join interpretacja using( leksem_id ) where interpretacja.path_id<>leksem.path_id " )[0].ile.to_i != 0
      raise "A jednak nadal się nie zgadza!"
    end
    
  end # of up
  
  def self.down
  end
end
