 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

require 'interpretacja_anot'


class AdminController < ApplicationController

  layout "admin"

  before_filter :authorize
  before_filter :update_activity_time, :except => :session_expiry
  before_filter :check_admin, :except => :zmien_haslo

#  ssl_required :dodaj_uzytkownika,  :usun_uzytkownika, :zmien_haslo, :lista_uzytkownikow, :zablokuj_uzytkownika

  def dodaj_uzytkownika
    @uzytkownik = Uzytkownik.new(params[:uzytkownik])
    if request.post? and @uzytkownik.save
      flash.now[:notice] = "Stworzyłam użytkownika #{@uzytkownik.login} (#{@uzytkownik.rola.opis_kr})."
      @uzytkownik = Uzytkownik.new
    end
  end


  def usun_uzytkownika
    if request.post?
      uzytkownik = Uzytkownik.find(params[:id])
      if Rola.usuwalny?( uzytkownik )
        if  Rola.anotator?( uzytkownik.rola_id ) # dołożone na życzenie AP 2009/6/5
          # anotatorowi odbieramy wszystkie transze
          uzytkownik.transze_otwarte.each{ |trao|
            trao.uzytkownik_id = nil
            trao.save!  }
        end
        uzytkownik.destroy
        flash[:notice]="Usunęłam użytkownika #{uzytkownik.login}"
        redirect_to(:action => :lista_uzytkownikow)
      else
        flash[:notice] = "Nie usuniesz takiego użytkownika, ewentualnie możesz go zablokować"
        redirect_to (:action => "zablokuj_uzytkownika", :id => uzytkownik)
      end
    end
  end # of #usun_uzytkownika
  

  def zablokuj_uzytkownika
    if request.post?
      uzytkownik= Uzytkownik.find(params[:id])
      if uzytkownik.uzytkownik_id != session[:uzid]
        moznablokowac=true
      else
        moznablokowac=false
        flash[:notice] = 'Nie będziesz blokować samej/go siebie'
      end
      if moznablokowac
        if false and Rola.anotator?( uzytkownik.rola_id ) # wyłączone na życzenie AP 2009/6/5
          # anotatorowi odbieramy wszystkie transze
          uzytkownik.transze_otwarte.each{ |trao|
            trao.uzytkownik_id = nil
            trao.save!  }
        end
        uzytkownik.rola_id = Rola.rid(:zablokowany)
        uzytkownik.save!
        flash[:notice]= "Zablokowałam użytkownika #{uzytkownik.login}"
      end
      redirect_to( :action => :lista_uzytkownikow )
    end
  end# of #zablokuj_uzytkownika


  def lista_uzytkownikow
    @wszyscy_uzytkownicy = Uzytkownik.find(:all, :order => :login)
  end


  def zmien_haslo
    @uzytkownik = Uzytkownik.find(params[:id])
    
    if (@uzytkownik.uzytkownik_id != session[:uzid]) and 
      ( session[:rola_id] & Rola.rid(:admin) ==0)
      flash[:notice] = "Nie masz uprawnień do wykonania tej czynności. Za karę wylogowuję Cię."
      redirect_to(:controller => "logowanie" , :action => "wylogowanie" )
      
    elsif request.post? and params[:uzytkownik]
      stare_haslo = params[:uzytkownik][:stare_haslo]

      if session[:rola_id] & Rola.rid(:admin) != 0 or 
        ( @uzytkownik.uzytkownik_id == session[:uzid] and 
          stare_haslo and 
         @uzytkownik.hasz_haslo == 
          Uzytkownik.haslo_szyfrowane(stare_haslo, @uzytkownik.sol))

        @uzytkownik.haslo=params[:uzytkownik][:haslo] 
        @uzytkownik.haslo_confirmation=params[:uzytkownik][:haslo_confirmation]
        @uzytkownik.haslo_updated_at = Time.now
        if  @uzytkownik.save
          if session[:rola_id] & Rola.rid(:admin) != 0 
            flash[:notice] = "Zmieniłam hasło użytkownika #{@uzytkownik.login}."
            redirect_to(:action => :lista_uzytkownikow)
          else
            flash[:notice] = "#{@uzytkownik.login}, właśnie zmieniłeś/aś swoje hasło."
            redirect_to(:controller => :logowanie, :action => :index)
          end
        end
      else
        if session[:rola_id] & Rola.rid(:admin) != 0
          redirect_to(:action => :lista_uzytkownikow)
        else
          flash[:notice] = "Zmiana hasła nie powiodła się (złe stare hasło)"
          redirect_to(:action => :zmien_haslo)
        end
      end
    end
  end # of #{zmien_haslo}



end # of class
