 #
 # This file is part of the Anotatornia suite.
 # 
 # Copyright © 2007, 2008, 2009, 2010 by Instytut Podstaw Informatyki
 # Polskiej Akademii Nauk (IPI PAN; Institute of Computer Science, Polish
 # Academy of Sciences; cf. www.ipipan.waw.pl).  All rights reserved.
 # 
 # This file may be distributed and/or modified under the terms of the
 # GNU General Public License version 3 as published by the Free Software
 # Foundation and appearing in the file COPYING included in the packaging
 # of this file.  (See http://www.gnu.org/licenses/translations.html for
 # unofficial translations.)
 # 
 # A commercial license is available from IPI PAN (contact
 # Michal.Ciesiolka.waw.pl or ipi.waw.pl for more
 # information).  Licensees holding a valid commercial license from IPI
 # PAN may use this file in accordance with that license.
 # 
 # This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING
 # THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 # PURPOSE.
 #

# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

require 'jcode'
require 'vendor/plugins/gm/gm_methods'

# Enough is enough: I have enough the "Expected corpus_path.rb to define CorpusPath" error
## load 'corpus_path.rb' 
## load 'fraza_typ.rb'
## load 'leksem.rb'
## load 'rozbieznosc.rb'
## load 'token_rozbiezny.rb'
## load 'czasownik_auto.rb'
## load 'interpretacja_anot.rb'
## load 'odebrania_transz.rb'
##load 'sens_anot.rb'
## load 'transza_auto.rb'
## load 'cz_m.rb'
## load 'interpretacja.rb'       
## load 'plik_morph.rb'
## load 'sensy_leksemu.rb'
## load 'uzytkownik.rb'
## load 'fraza_anot.rb'
## load 'klasa_gram.rb'
## load 'protokol_rozbieznosci.rb'
## load 'sensy.rb'
## load 'akapit_transzy.rb'
## load 'fraza_rozbiezna.rb'
## load 'komentarz.rb'
## load 'rola.rb'
## load 'token.rb'  
## load 'akapit.rb'

# dalsze load'y przeniesione za klasę

class ApplicationController < ActionController::Base
  # Pick a unique cookie name to distinguish our session data from others'
  session :session_key => '_anotatornia_session_id'

  filter_parameter_logging :haslo #, :uzid, :uzytkownik
  # dla bezpieczeństwa: \ac{AWDWR} s.~610
  # 2008/07/14 jednak odsłaniam #:uzid i~#:uzytkownik, żeby było wiadomo, kto się logował.
  include SslRequirement

  include ApplicationHelper
  # to chyba nie tak miało być, ale potrzebuję metod.


  private
# nie-prywatne mogłyby być wywołane z przeglądarki.

  def authorize
    logger.info "@@@@@ tu działa #{session[ :login ].inspect} (#{Rola.nazwa_roli(session[:rola_id])})"
    unless Uzytkownik.find_by_uzytkownik_id(session[:uzid])
      ##     session[:original_uri] = request.request_uri
      # nie będziemy pamiętać uri, bo niektóre podstrony wymagają parametrów, 
      # a bez parametrów dają błąd.
      flash[:notice] = "Najpierw, proszę, zaloguj się."
      redirect_to(:controller => "logowanie" , :action => "logowanie" )
      return false
    end
  end


  def check_role (*rola)
    uzytkownik=Uzytkownik.find(session[:uzid])
    if (not uzytkownik) or  (not Rola.ktoras_z_rol?(uzytkownik, *rola) )
      # jak widać, rola ma być \emph{symbolem} roli do sprawdzenia
      ##      session[:original_uri] = nil
      flash[:notice] = "Nie masz uprawnień do wykonania tej czynności. Za karę wylogowuję Cię."
      redirect_to(:controller => "logowanie" , :action => "wylogowanie" )
      return false
    end
  end

  
  def check_admin
    check_role(:admin)
  end


  def check_anotator
    check_role(:anotator)
  end


  def check_annotant
    check_role(:anotator, :zarzadca)
  end


  def check_annotant_ou_auditeur
    check_role(:anotator, :zarzadca, :audytor)
  end

  def  check_voyeur
    check_role(:anotator, :zarzadca, :audytor, :gosc)
  end

  def check_zarzadca
    check_role(:zarzadca)
  end

  def check_wszewid
    check_role( :zarzadca, :audytor )
  end

  def check_audytor
    check_role(:audytor)
  end


  def check_idid
    if session[:uzid] != params[:id].to_i
      session[:original_uri] = nil
      flash[:notice] = "Próbowałeś/aś oglądać nie swój zasób. Wylogowanie."
      redirect_to(:controller => "logowanie" , :action => "wylogowanie" )
      return false
    end
  end


  def check_edytowalny
    # jeśli pojawia się błąd w tej akcji, to sprawdź, czy nie jest wołana z dziwnego miejsca,
    # np. bez #session[:akapit].
    rola_OK = ( Rola.anotator?(session[:rola_id]) || Rola.zarzadca?(session[:rola_id])) && 
      ( ( not session[ :drag_queen_id ] ) || AnoVersion.port == 8004 )
    if session[ :akat ]
      akat = AkapitTranszy.find( session[ :akat ] )
    elsif params[ :akat ]
      akat = AkapitTranszy.find( params[ :akat ] )
    else
      logger.info( "@@@@@ brak session[:akat] i params[ :akat ] #{Time.now.to_s(:db)}" )
      akat = AkapitTranszy.znajdz(
                                session[:akapit], 
                                (session[:anotator] || session[:uzid]))
    end
    logger.info "@@@@ akapit #{akat.akapit_id} (tr. #{akat.transza_id}, atr. #{akat.id})"
    if DlaEli.nk : poziomy =  params[ :poziom ]
      raise "@@@@ w wersji NKJP musi być podany poziom, np. :any!" unless poziomy
      poziomy = poziomy.split('/').collect{ |poz| poz.intern }
      poziomy = nil if poziomy == [ :any ]
    else poziomy = nil
    end
    if poziomy
      edytowalny = ( poziomy.collect{|poz| 
                       akat.edytowalny_przez_anotatora?( poz ) }.uniq ==
                     [ true ] )
      edytowalny &&=
        (( akat.poziomy_dostępne( session[:rola_id], 
                                  :jak_anotator => session[ :jak_anotator ] ) &  
           poziomy ) == poziomy )
      ##      logger.info( "@@@@ poziomy: :#{poziomy.inspect}, edytowalny: #{edytowalny}" )
    else # #{not poziom}
      edytowalny =  akat.ma_Status?( :<, :zweryfikowany )
      session[:status] = akat.status unless edytowalny
    end
    uzid_OK = ( akat.get_uzid == session[:uzid] ) 
    if rola_OK  and edytowalny  and uzid_OK
      return true
    elsif Rola.zarzadca?(session[:rola_id]) 
      # na wyraźne życzenie Eli zarządca może też zmieniać anotacje zdań zweryfikowanych.
      if poziomy : return true # #edytowalny #poziom jest brany pod uwagę tylko w~wersji \ac{NKJP}, w~wersji dla Eli jest #{nil}.
      else return true
      end
      ##    elsif Rola.gosc?(session[:rola_id])
      ##      redirect_to( :controller=> 'anotacja', :action => 'ogladactwo' )
      ##      return false
    else
      ##      logger.info( "check edytowalny #{Time.now.to_s(:db)}" +
      ##      " rola_ok: #{rola_OK}, zakonczony: #{zakonczony}, uzid_OK: #{uzid_OK}")
      ##      logger.info( "::: session:#{session[:uzid]}, akat.uzid:::::#{akat.get_uzid}")
      if session[ :drag_queen_id ]
        flash[ :notice ] = "Niestety, nie możesz anotować w dragu."
      else
        flash[ :notice ]="Akapit zweryfikowany lub nie masz prawa zmienić anotacji."
      end
      redirect_to( :controller=> annotation_controller, :action => 'anotuj', :akat => akat )
      return false
    end
  end # of #check_edytowalny


  def check_drag_queen
    # tak naprawdę używana tylko do zablokowania pobrania transzy
    if session[ :drag_queen_id ]
        flash[ :notice ] = "Niestety, nie możesz tego zrobić w dragu."
      return false
    else
      return true
    end
  end # of #{check_drag_queen}


  def update_activity_time
    if UNatrora.x :     timeout =  1600.minutes.from_now
    else     timeout =  60.minutes.from_now
    end
    if session[:expires_at] and session[:expires_at] > Time.now
    session[:expires_at]=timeout
      return true
    elsif session[:expires_at]
      reset_session
      flash[:notice] = "Sesja wygasła. Zaloguj się."
      redirect_to :controller => 'logowanie', :action => "logowanie"
      return false
    else # nie ma #:expires_at
      session[:expires_at]=timeout
      return true
    end # of #session[:expires_at]... i #elsif
  end # of #update_activity_time


  def przetwarzam_nie_przeszkadzac
    # Chcielibyśmy uodpornić aplikację na wielokrotne naciskanie przycisku.
    # i tę metodę wywołamy jako #before_filter, a następną jako #after_filter.
    if session[:wlasnie_przetwarzam]
      ##      flash[:notice] = "Ooops, jakiś błędzik, ale żyję i działam."
      session[:wlasnie_przetwarzam]=nil
      if r_rola?( :audytor, :anotator, :gosc, :zarzadca )
        ##        redirect_to :controller => :anotacja , :action => :ogladactwo
      else ## redirect_to :controller => :logowanie, :action => :index
      end
      return true ## false
    else # czyli nie ma #:wlasnie_przetwarzam w sesji
      session[:wlasnie_przetwarzam] = true
      return true
    end
  end
  # Kiedy naciskam np. Zatwierdź w widoku anotacji akapitu, 
  # nie jestem przekierowany, ale też się nie wykłada.

  
  def skonczylam_przetwarzac
    session[:wlasnie_przetwarzam] = nil
    return true
  end


end # of class.



# Z kontrolerami jeszcze poczekajmy, nie zdarzyło się "Expected..." z kontolerem.
# A jednak, także na nie przyszła pora
## load 'admin_controller.rb'
## load 'logowanie_controller.rb'
## load 'anotacja_controller.rb'
## load 'zarzadca_controller.rb'

### Local Variables: 
### mode: ruby
### End:
